/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.fido2.ws.rs.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.fido2.exception.Fido2RPRuntimeException;
import org.gluu.oxauth.fido2.model.entry.Fido2AuthenticationData;
import org.gluu.oxauth.fido2.model.entry.Fido2AuthenticationEntry;
import org.gluu.oxauth.fido2.model.entry.Fido2AuthenticationStatus;
import org.gluu.oxauth.fido2.model.entry.Fido2RegistrationData;
import org.gluu.oxauth.fido2.model.entry.Fido2RegistrationEntry;
import org.gluu.oxauth.fido2.persist.AuthenticationPersistenceService;
import org.gluu.oxauth.fido2.persist.RegistrationPersistenceService;
import org.gluu.oxauth.fido2.service.Base64Service;
import org.gluu.oxauth.fido2.service.ChallengeGenerator;
import org.gluu.oxauth.fido2.service.DataMapperService;
import org.gluu.oxauth.fido2.service.verifier.AuthenticatorAssertionVerifier;
import org.gluu.oxauth.fido2.service.verifier.ChallengeVerifier;
import org.gluu.oxauth.fido2.service.verifier.CommonVerifiers;
import org.gluu.oxauth.fido2.service.verifier.DomainVerifier;
import org.slf4j.Logger;
import org.xdi.oxauth.model.configuration.AppConfiguration;

@ApplicationScoped
public class AssertionService {
    @Inject
    private Logger log;
    @Inject
    private ChallengeVerifier challengeVerifier;
    @Inject
    private DomainVerifier domainVerifier;
    @Inject
    private RegistrationPersistenceService registrationsRepository;
    @Inject
    private AuthenticationPersistenceService authenticationsRepository;
    @Inject
    private AuthenticatorAssertionVerifier authenticatorAuthorizationVerifier;
    @Inject
    private ChallengeGenerator challengeGenerator;
    @Inject
    private DataMapperService dataMapperService;
    @Inject
    private Base64Service base64Service;
    @Inject
    private CommonVerifiers commonVerifiers;
    @Inject
    private AppConfiguration appConfiguration;

    public JsonNode options(JsonNode params) {
        this.log.info("options {}", (Object)params);
        return this.assertionOptions(params);
    }

    public JsonNode verify(JsonNode params) {
        JsonNode clientDataJSONNode;
        this.log.info("authenticateResponse {}", (Object)params);
        ObjectNode authenticateResponseNode = this.dataMapperService.createObjectNode();
        JsonNode response = params.get("response");
        this.commonVerifiers.verifyBasicPayload(params);
        String keyId = this.commonVerifiers.verifyThatString(params, "id");
        this.commonVerifiers.verifyAssertionType(params.get("type"));
        this.commonVerifiers.verifyThatString(params, "rawId");
        JsonNode userHandle = params.get("response").get("userHandle");
        if (userHandle != null && params.get("response").hasNonNull("userHandle")) {
            this.commonVerifiers.verifyThatString(userHandle);
        }
        try {
            clientDataJSONNode = this.dataMapperService.readTree(new String(this.base64Service.urlDecode(params.get("response").get("clientDataJSON").asText()), Charset.forName("UTF-8")));
        }
        catch (IOException e) {
            throw new Fido2RPRuntimeException("Can't parse message");
        }
        catch (Exception e) {
            throw new Fido2RPRuntimeException("Invalid assertion data");
        }
        this.commonVerifiers.verifyClientJSON(clientDataJSONNode);
        this.commonVerifiers.verifyClientJSONTypeIsGet(clientDataJSONNode);
        String clientDataChallenge = clientDataJSONNode.get("challenge").asText();
        String clientDataOrigin = clientDataJSONNode.get("origin").asText();
        Fido2AuthenticationEntry authenticationEntity = (Fido2AuthenticationEntry)this.authenticationsRepository.findByChallenge(clientDataChallenge).parallelStream().findFirst().orElseThrow(() -> new Fido2RPRuntimeException(String.format("Can't find matching request by challenge '%s'", clientDataChallenge)));
        Fido2AuthenticationData authenticationData = authenticationEntity.getAuthenticationData();
        this.domainVerifier.verifyDomain(authenticationData.getDomain(), clientDataOrigin);
        Fido2RegistrationEntry registrationEntry = this.registrationsRepository.findByPublicKeyId(keyId).orElseThrow(() -> new Fido2RPRuntimeException(String.format("Couldn't find the key by PublicKeyId '%s'", keyId)));
        Fido2RegistrationData registrationData = registrationEntry.getRegistrationData();
        this.authenticatorAuthorizationVerifier.verifyAuthenticatorAssertionResponse(response, registrationData, authenticationData);
        authenticationData.setW3cAuthenticatorAssertionResponse(response.toString());
        authenticationData.setStatus(Fido2AuthenticationStatus.authenticated);
        this.authenticationsRepository.update(authenticationEntity);
        authenticateResponseNode.put("status", "ok");
        authenticateResponseNode.put("errorMessage", "");
        return authenticateResponseNode;
    }

    private JsonNode assertionOptions(JsonNode params) {
        String host;
        JsonNode authenticatorSelector;
        this.log.info("assertionOptions {}", (Object)params);
        String username = params.get("username").asText();
        String userVerification = "required";
        if (params.hasNonNull("authenticatorSelection") && (authenticatorSelector = params.get("authenticatorSelection")).hasNonNull("userVerification")) {
            userVerification = this.commonVerifiers.verifyUserVerification(authenticatorSelector.get("userVerification"));
        }
        this.log.info("Options {} ", (Object)username);
        ObjectNode assertionOptionsResponseNode = this.dataMapperService.createObjectNode();
        List<Fido2RegistrationEntry> registrationEntries = this.registrationsRepository.findAllByUsername(username);
        if (registrationEntries.isEmpty()) {
            throw new Fido2RPRuntimeException("No record of registration. Have you registered");
        }
        List registrations = registrationEntries.parallelStream().map(f -> f.getRegistrationData()).collect(Collectors.toList());
        String challenge = this.challengeGenerator.getChallenge();
        assertionOptionsResponseNode.put("challenge", challenge);
        ObjectNode credentialUserEntityNode = assertionOptionsResponseNode.putObject("user");
        credentialUserEntityNode.put("name", username);
        ArrayNode publicKeyCredentialDescriptors = assertionOptionsResponseNode.putArray("allowCredentials");
        boolean foundPublicKeys = false;
        for (Fido2RegistrationData registration : registrations) {
            if (StringUtils.isEmpty((String)registration.getPublicKeyId())) continue;
            foundPublicKeys = true;
            ObjectNode publicKeyCredentialDescriptorNode = publicKeyCredentialDescriptors.addObject();
            publicKeyCredentialDescriptorNode.put("type", "public-key");
            ArrayNode authenticatorTransportNode = publicKeyCredentialDescriptorNode.putArray("transports");
            authenticatorTransportNode.add("usb").add("ble").add("nfc");
            publicKeyCredentialDescriptorNode.put("id", registration.getPublicKeyId());
        }
        if (!foundPublicKeys) {
            throw new Fido2RPRuntimeException("Can't find associated key. Have you registered");
        }
        assertionOptionsResponseNode.put("userVerification", userVerification);
        if (params.hasNonNull("extensions")) {
            assertionOptionsResponseNode.set("extensions", params.get("extensions"));
        }
        try {
            host = new URL(this.appConfiguration.getIssuer()).getHost();
        }
        catch (MalformedURLException e) {
            host = this.appConfiguration.getIssuer();
        }
        Fido2AuthenticationData authenticationData = new Fido2AuthenticationData();
        authenticationData.setUsername(username);
        authenticationData.setChallenge(challenge);
        authenticationData.setDomain(host);
        authenticationData.setW3cCredentialRequestOptions(assertionOptionsResponseNode.toString());
        authenticationData.setUserVerificationOption(userVerification);
        authenticationData.setStatus(Fido2AuthenticationStatus.pending);
        this.authenticationsRepository.save(authenticationData);
        assertionOptionsResponseNode.put("status", "ok");
        assertionOptionsResponseNode.put("errorMessage", "");
        return assertionOptionsResponseNode;
    }
}

