/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.fido2.ws.rs.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.gluu.oxauth.fido2.service.DataMapperService;
import org.slf4j.Logger;
import org.xdi.oxauth.model.configuration.AppConfiguration;
import org.xdi.oxauth.model.fido.u2f.U2fConfiguration;

@ApplicationScoped
@Path(value="/fido2/configuration")
@Api(value="/.well-known/fido2-configuration", description="The FIDO2 server endpoint that provides configuration data in a JSON [RFC4627] document that resides in at /.well-known/fido-configuration directory at its hostmeta [hostmeta] location. The configuration data documents conformance options and endpoints supported by the FIDO2 server.")
public class ConfigurationController {
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private DataMapperService dataMapperService;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Provides configuration data as json document. It contains options and endpoints supported by the FIDO U2F server.", response=U2fConfiguration.class)
    public Response getConfiguration() {
        if (this.appConfiguration.getFido2Configuration() == null || this.appConfiguration.getFido2Configuration().isDisable()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        String baseEndpointUri = this.appConfiguration.getBaseEndpoint();
        ObjectNode response = this.dataMapperService.createObjectNode();
        response.put("version", "1.0");
        response.put("issuer", this.appConfiguration.getIssuer());
        ObjectNode attestation = this.dataMapperService.createObjectNode();
        response.set("attestation", (JsonNode)attestation);
        attestation.put("options_enpoint", baseEndpointUri + "/fido2/attestation/options");
        attestation.put("result_enpoint", baseEndpointUri + "/fido2/attestation/result");
        ObjectNode assertion = this.dataMapperService.createObjectNode();
        response.set("assertion", (JsonNode)assertion);
        assertion.put("options_enpoint", baseEndpointUri + "/fido2/assertion/options");
        assertion.put("result_enpoint", baseEndpointUri + "/fido2/assertion/result");
        Response.ResponseBuilder builder = Response.ok().entity((Object)response.toString());
        return builder.build();
    }
}

