/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.fido2.ws.rs.controller;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.gluu.oxauth.fido2.service.DataMapperService;
import org.gluu.oxauth.fido2.ws.rs.service.AttestationService;
import org.xdi.oxauth.model.configuration.AppConfiguration;

@ApplicationScoped
@Path(value="/fido2/attestation")
public class AttestationController {
    @Inject
    private AttestationService attestationService;
    @Inject
    private DataMapperService dataMapperService;
    @Inject
    private AppConfiguration appConfiguration;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/options")
    public Response register(String content) throws IOException {
        if (this.appConfiguration.getFido2Configuration() == null || this.appConfiguration.getFido2Configuration().isDisable()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        JsonNode params = this.dataMapperService.readTree(content);
        JsonNode result = this.attestationService.options(params);
        Response.ResponseBuilder builder = Response.ok().entity((Object)result.toString());
        return builder.build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/result")
    public Response verify(String content) throws IOException {
        if (this.appConfiguration.getFido2Configuration() == null || this.appConfiguration.getFido2Configuration().isDisable()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        JsonNode params = this.dataMapperService.readTree(content);
        JsonNode result = this.attestationService.verify(params);
        Response.ResponseBuilder builder = Response.ok().entity((Object)result.toString());
        return builder.build();
    }
}

