/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.fido2.service.verifier;

import java.net.MalformedURLException;
import java.net.URL;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gluu.oxauth.fido2.exception.Fido2RPRuntimeException;
import org.slf4j.Logger;

@ApplicationScoped
public class DomainVerifier {
    @Inject
    private Logger log;

    public boolean verifyDomain(String domain, String clientDataOrigin) {
        this.log.info("Domains comparison {} {}", (Object)domain, (Object)clientDataOrigin);
        try {
            if (!domain.equals(new URL(clientDataOrigin).getHost())) {
                throw new Fido2RPRuntimeException("Domains don't match");
            }
            return true;
        }
        catch (MalformedURLException e) {
            if (!domain.equals(clientDataOrigin)) {
                throw new Fido2RPRuntimeException("Domains don't match");
            }
            return true;
        }
    }
}

