/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.fido2.service.verifier;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.codec.digest.DigestUtils;
import org.gluu.oxauth.fido2.exception.Fido2RPRuntimeException;
import org.gluu.oxauth.fido2.model.auth.AuthData;
import org.gluu.oxauth.fido2.model.auth.CredAndCounterData;
import org.gluu.oxauth.fido2.model.entry.Fido2RegistrationData;
import org.gluu.oxauth.fido2.service.AuthenticatorDataParser;
import org.gluu.oxauth.fido2.service.Base64Service;
import org.gluu.oxauth.fido2.service.DataMapperService;
import org.gluu.oxauth.fido2.service.processors.AttestationFormatProcessor;
import org.gluu.oxauth.fido2.service.processors.impl.AttestationProcessorFactory;
import org.gluu.oxauth.fido2.service.verifier.CommonVerifiers;
import org.slf4j.Logger;

@ApplicationScoped
public class AuthenticatorAttestationVerifier {
    @Inject
    private Logger log;
    @Inject
    private CommonVerifiers commonVerifiers;
    @Inject
    private AuthenticatorDataParser authenticatorDataParser;
    @Inject
    private Base64Service base64Service;
    @Inject
    private DataMapperService dataMapperService;
    @Inject
    private AttestationProcessorFactory attestationProcessorFactory;

    public CredAndCounterData verifyAuthenticatorAttestationResponse(JsonNode response, Fido2RegistrationData credential) {
        if (!response.hasNonNull("attestationObject") || !response.hasNonNull("clientDataJSON")) {
            throw new Fido2RPRuntimeException("Authenticator data is invalid");
        }
        JsonNode authenticatorResponse = response;
        String base64AuthenticatorData = authenticatorResponse.get("attestationObject").asText();
        String clientDataJson = authenticatorResponse.get("clientDataJSON").asText();
        byte[] authenticatorDataBuffer = this.base64Service.urlDecode(base64AuthenticatorData);
        CredAndCounterData credIdAndCounters = new CredAndCounterData();
        try {
            if (authenticatorDataBuffer == null) {
                throw new Fido2RPRuntimeException("Attestation object is empty");
            }
            JsonNode authenticatorDataNode = this.dataMapperService.cborReadTree(authenticatorDataBuffer);
            String fmt = this.commonVerifiers.verifyFmt(authenticatorDataNode, "fmt");
            this.log.info("Authenticator data {} {}", (Object)fmt, (Object)authenticatorDataNode.toString());
            credential.setAttestationType(fmt);
            JsonNode authDataNode = authenticatorDataNode.get("authData");
            String authDataText = this.commonVerifiers.verifyAuthData(authDataNode);
            JsonNode attStmt = authenticatorDataNode.get("attStmt");
            AuthData authData = this.authenticatorDataParser.parseAttestationData(authDataText);
            int counter = this.authenticatorDataParser.parseCounter(authData.getCounters());
            this.commonVerifiers.verifyCounter(counter);
            credIdAndCounters.setCounters(counter);
            byte[] clientDataHash = DigestUtils.getSha256Digest().digest(this.base64Service.urlDecode(clientDataJson));
            AttestationFormatProcessor attestationProcessor = this.attestationProcessorFactory.getCommandProcessor(fmt);
            attestationProcessor.process(attStmt, authData, credential, clientDataHash, credIdAndCounters);
            return credIdAndCounters;
        }
        catch (IOException e) {
            throw new Fido2RPRuntimeException("Problem with processing authenticator data");
        }
    }
}

