/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.fido2.service.verifier;

import com.fasterxml.jackson.databind.JsonNode;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gluu.oxauth.fido2.exception.Fido2RPRuntimeException;
import org.gluu.oxauth.fido2.model.entry.Fido2AuthenticationData;
import org.gluu.oxauth.fido2.model.entry.Fido2RegistrationData;
import org.gluu.oxauth.fido2.service.Base64Service;
import org.gluu.oxauth.fido2.service.processors.impl.AssertionFormatProcessor;
import org.gluu.oxauth.fido2.service.processors.impl.AssertionProcessorFactory;
import org.slf4j.Logger;

@ApplicationScoped
public class AuthenticatorAssertionVerifier {
    @Inject
    private Logger log;
    @Inject
    private Base64Service base64Service;
    @Inject
    private AssertionProcessorFactory assertionProcessorFactory;

    public void verifyAuthenticatorAssertionResponse(JsonNode response, Fido2RegistrationData registration, Fido2AuthenticationData authenticationEntity) {
        if (!(response.hasNonNull("authenticatorData") && response.hasNonNull("clientDataJSON") && response.hasNonNull("signature"))) {
            throw new Fido2RPRuntimeException("Authenticator data is invalid");
        }
        JsonNode authenticatorResponse = response;
        String base64AuthenticatorData = authenticatorResponse.get("authenticatorData").asText();
        String clientDataJson = authenticatorResponse.get("clientDataJSON").asText();
        String signature = authenticatorResponse.get("signature").asText();
        this.log.info("Authenticator data {}", (Object)base64AuthenticatorData);
        AssertionFormatProcessor assertionProcessor = this.assertionProcessorFactory.getCommandProcessor(registration.getAttestationType());
        assertionProcessor.process(base64AuthenticatorData, signature, clientDataJson, registration, authenticationEntity);
    }
}

