/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.fido2.service.processors.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gluu.oxauth.fido2.cryptoutils.CoseService;
import org.gluu.oxauth.fido2.cryptoutils.CryptoUtils;
import org.gluu.oxauth.fido2.ctap.AttestationFormat;
import org.gluu.oxauth.fido2.model.auth.AuthData;
import org.gluu.oxauth.fido2.model.auth.CredAndCounterData;
import org.gluu.oxauth.fido2.model.entry.Fido2RegistrationData;
import org.gluu.oxauth.fido2.service.Base64Service;
import org.gluu.oxauth.fido2.service.CertificateSelector;
import org.gluu.oxauth.fido2.service.CertificateValidator;
import org.gluu.oxauth.fido2.service.processors.AttestationFormatProcessor;
import org.gluu.oxauth.fido2.service.processors.impl.AttestationProcessorFactory;
import org.gluu.oxauth.fido2.service.verifier.CommonVerifiers;
import org.slf4j.Logger;

@ApplicationScoped
public class U2FAttestationProcessor
implements AttestationFormatProcessor {
    @Inject
    private Logger log;
    @Inject
    private CommonVerifiers commonVerifiers;
    @Inject
    private AttestationProcessorFactory attestationProcessorFactory;
    @Inject
    private CertificateSelector certificateSelector;
    @Inject
    private CertificateValidator certificateValidator;
    @Inject
    private CoseService coseService;
    @Inject
    private Base64Service base64Service;
    @Inject
    private CryptoUtils cryptoUtils;

    @Override
    public AttestationFormat getAttestationFormat() {
        return AttestationFormat.fido_u2f;
    }

    @Override
    public void process(JsonNode attStmt, AuthData authData, Fido2RegistrationData registration, byte[] clientDataHash, CredAndCounterData credIdAndCounters) {
        int alg = -7;
        String signature = this.commonVerifiers.verifyBase64String(attStmt.get("sig"));
        this.commonVerifiers.verifyAAGUIDZeroed(authData);
        this.commonVerifiers.verifyUserPresent(authData);
        this.commonVerifiers.verifyRpIdHash(authData, registration.getDomain());
        if (attStmt.hasNonNull("x5c")) {
            Iterator i = attStmt.get("x5c").elements();
            ArrayList<String> certificatePath = new ArrayList<String>();
            while (i.hasNext()) {
                certificatePath.add(((JsonNode)i.next()).asText());
            }
            List<X509Certificate> certificates = this.cryptoUtils.getCertificates(certificatePath);
            credIdAndCounters.setSignatureAlgorithm(alg);
            List<X509Certificate> trustAnchorCertificates = this.certificateSelector.selectRootCertificate(certificates.get(0));
            X509Certificate verifiedCert = this.certificateValidator.verifyAttestationCertificates(certificates, trustAnchorCertificates);
            this.commonVerifiers.verifyU2FAttestationSignature(authData, clientDataHash, signature, verifiedCert, alg);
        } else {
            if (attStmt.hasNonNull("ecdaaKeyId")) {
                String ecdaaKeyId = attStmt.get("ecdaaKeyId").asText();
                throw new UnsupportedOperationException("TODO");
            }
            PublicKey publicKey = this.coseService.getPublicKeyFromUncompressedECPoint(authData.getCOSEPublicKey());
            this.commonVerifiers.verifyPackedSurrogateAttestationSignature(authData.getAuthDataDecoded(), clientDataHash, signature, publicKey, alg);
        }
        credIdAndCounters.setAttestationType(this.getAttestationFormat().getFmt());
        credIdAndCounters.setCredId(this.base64Service.urlEncodeToString(authData.getCredId()));
        credIdAndCounters.setUncompressedEcPoint(this.base64Service.urlEncodeToString(authData.getCOSEPublicKey()));
    }
}

