/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.fido2.service.processors.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.security.PublicKey;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.gluu.oxauth.fido2.cryptoutils.CoseService;
import org.gluu.oxauth.fido2.ctap.AttestationFormat;
import org.gluu.oxauth.fido2.exception.Fido2RPRuntimeException;
import org.gluu.oxauth.fido2.model.auth.AuthData;
import org.gluu.oxauth.fido2.model.entry.Fido2AuthenticationData;
import org.gluu.oxauth.fido2.model.entry.Fido2RegistrationData;
import org.gluu.oxauth.fido2.service.AuthenticatorDataParser;
import org.gluu.oxauth.fido2.service.Base64Service;
import org.gluu.oxauth.fido2.service.DataMapperService;
import org.gluu.oxauth.fido2.service.processors.impl.AssertionFormatProcessor;
import org.gluu.oxauth.fido2.service.verifier.CommonVerifiers;
import org.slf4j.Logger;

@ApplicationScoped
public class U2FAssertionFormatProcessor
implements AssertionFormatProcessor {
    @Inject
    private Logger log;
    @Inject
    private CoseService coseService;
    @Inject
    private CommonVerifiers commonVerifiers;
    @Inject
    private AuthenticatorDataParser authenticatorDataParser;
    @Inject
    private DataMapperService dataMapperService;
    @Inject
    private Base64Service base64Service;

    @Override
    public AttestationFormat getAttestationFormat() {
        return AttestationFormat.fido_u2f;
    }

    @Override
    public void process(String base64AuthenticatorData, String signature, String clientDataJson, Fido2RegistrationData registration, Fido2AuthenticationData authenticationEntity) {
        AuthData authData = this.authenticatorDataParser.parseAssertionData(base64AuthenticatorData);
        this.commonVerifiers.verifyUserPresent(authData);
        byte[] clientDataHash = DigestUtils.getSha256Digest().digest(this.base64Service.urlDecode(clientDataJson));
        try {
            JsonNode uncompressedECPointNode = this.dataMapperService.cborReadTree(this.base64Service.urlDecode(registration.getUncompressedECPoint()));
            PublicKey publicKey = this.coseService.createUncompressedPointFromCOSEPublicKey(uncompressedECPointNode);
            int coseCurveCode = this.coseService.getCodeCurve(uncompressedECPointNode);
            this.log.info("Uncompressed ECpoint node {}", (Object)uncompressedECPointNode.toString());
            this.log.info("Public key hex {}", (Object)Hex.encodeHexString((byte[])publicKey.getEncoded()));
            this.commonVerifiers.verifyAssertionSignature(authData, clientDataHash, signature, publicKey, registration.getSignatureAlgorithm());
            int counter = this.authenticatorDataParser.parseCounter(authData.getCounters());
            this.commonVerifiers.verifyCounter(registration.getCounter(), counter);
            registration.setCounter(counter);
        }
        catch (Exception e) {
            throw new Fido2RPRuntimeException("General server error " + e.getMessage());
        }
    }
}

