/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.fido2.service.processors.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.binary.Hex;
import org.gluu.oxauth.fido2.certification.CertificationKeyStoreUtils;
import org.gluu.oxauth.fido2.cryptoutils.CoseService;
import org.gluu.oxauth.fido2.cryptoutils.CryptoUtils;
import org.gluu.oxauth.fido2.ctap.AttestationFormat;
import org.gluu.oxauth.fido2.exception.Fido2RPRuntimeException;
import org.gluu.oxauth.fido2.model.auth.AuthData;
import org.gluu.oxauth.fido2.model.auth.CredAndCounterData;
import org.gluu.oxauth.fido2.model.entry.Fido2RegistrationData;
import org.gluu.oxauth.fido2.service.Base64Service;
import org.gluu.oxauth.fido2.service.CertificateValidator;
import org.gluu.oxauth.fido2.service.processors.AttestationFormatProcessor;
import org.gluu.oxauth.fido2.service.verifier.CommonVerifiers;
import org.slf4j.Logger;

@ApplicationScoped
public class PackedAttestationProcessor
implements AttestationFormatProcessor {
    @Inject
    private Logger log;
    @Inject
    private CommonVerifiers commonVerifiers;
    @Inject
    private CertificateValidator certificateValidator;
    @Inject
    private CoseService coseService;
    @Inject
    private Base64Service base64Service;
    @Inject
    private CertificationKeyStoreUtils utils;
    @Inject
    private CryptoUtils cryptoUtils;

    @Override
    public AttestationFormat getAttestationFormat() {
        return AttestationFormat.packed;
    }

    @Override
    public void process(JsonNode attStmt, AuthData authData, Fido2RegistrationData registration, byte[] clientDataHash, CredAndCounterData credIdAndCounters) {
        int alg = this.commonVerifiers.verifyAlgorithm(attStmt.get("alg"), authData.getKeyType());
        String signature = this.commonVerifiers.verifyBase64String(attStmt.get("sig"));
        X509TrustManager tm = this.utils.populateTrustManager(authData);
        if (attStmt.hasNonNull("x5c")) {
            if (tm.getAcceptedIssuers().length == 0) {
                throw new Fido2RPRuntimeException("Packed full attestation but no certificates in metadata for authenticator " + Hex.encodeHexString((byte[])authData.getAaguid()));
            }
            Iterator i = attStmt.get("x5c").elements();
            ArrayList<String> certificatePath = new ArrayList<String>();
            while (i.hasNext()) {
                certificatePath.add(((JsonNode)i.next()).asText());
            }
            List<X509Certificate> certificates = this.cryptoUtils.getCertificates(certificatePath);
            credIdAndCounters.setSignatureAlgorithm(alg);
            X509Certificate verifiedCert = this.certificateValidator.verifyAttestationCertificates(certificates, Arrays.asList(tm.getAcceptedIssuers()));
            PublicKey verifiedKey = verifiedCert.getPublicKey();
            this.commonVerifiers.verifyPackedAttestationSignature(authData.getAuthDataDecoded(), clientDataHash, signature, (Certificate)verifiedCert, alg);
            try {
                verifiedCert.verify(verifiedKey);
                throw new Fido2RPRuntimeException("Self signed certificate ");
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException generalSecurityException) {}
        } else {
            if (attStmt.hasNonNull("ecdaaKeyId")) {
                String ecdaaKeyId = attStmt.get("ecdaaKeyId").asText();
                throw new UnsupportedOperationException("TODO");
            }
            PublicKey publicKey = this.coseService.getPublicKeyFromUncompressedECPoint(authData.getCOSEPublicKey());
            this.commonVerifiers.verifyPackedSurrogateAttestationSignature(authData.getAuthDataDecoded(), clientDataHash, signature, publicKey, alg);
        }
        credIdAndCounters.setAttestationType(this.getAttestationFormat().getFmt());
        credIdAndCounters.setCredId(this.base64Service.urlEncodeToString(authData.getCredId()));
        credIdAndCounters.setUncompressedEcPoint(this.base64Service.urlEncodeToString(authData.getCOSEPublicKey()));
    }
}

