/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.fido2.service.processors.impl;

import com.fasterxml.jackson.databind.JsonNode;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gluu.oxauth.fido2.ctap.AttestationFormat;
import org.gluu.oxauth.fido2.exception.Fido2RPRuntimeException;
import org.gluu.oxauth.fido2.model.auth.AuthData;
import org.gluu.oxauth.fido2.model.auth.CredAndCounterData;
import org.gluu.oxauth.fido2.model.entry.Fido2RegistrationData;
import org.gluu.oxauth.fido2.service.processors.AttestationFormatProcessor;
import org.gluu.oxauth.fido2.service.verifier.CommonVerifiers;
import org.slf4j.Logger;

@ApplicationScoped
public class NoneAttestationProcessor
implements AttestationFormatProcessor {
    @Inject
    private Logger log;
    @Inject
    private CommonVerifiers commonVerifiers;

    @Override
    public AttestationFormat getAttestationFormat() {
        return AttestationFormat.none;
    }

    @Override
    public void process(JsonNode attStmt, AuthData authData, Fido2RegistrationData credential, byte[] clientDataHash, CredAndCounterData credIdAndCounters) {
        this.log.info("None/Surrogate attestation {}", (Object)attStmt);
        if (attStmt.iterator().hasNext()) {
            throw new Fido2RPRuntimeException("Problem with None/Surrogate attestation");
        }
        credIdAndCounters.setAttestationType(this.getAttestationFormat().getFmt());
    }
}

