/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.fido2.service.processors.impl;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.oxauth.fido2.ctap.AttestationFormat;
import org.gluu.oxauth.fido2.exception.Fido2RPRuntimeException;
import org.gluu.oxauth.fido2.service.processors.AttestationFormatProcessor;

@ApplicationScoped
public class AttestationProcessorFactory {
    private Map<AttestationFormat, AttestationFormatProcessor> processorsMap;

    @Inject
    private void initCommandProcessors(@Any Instance<AttestationFormatProcessor> attestationFormatProcessors) {
        this.processorsMap = new EnumMap<AttestationFormat, AttestationFormatProcessor>(AttestationFormat.class);
        for (AttestationFormatProcessor app : attestationFormatProcessors) {
            this.processorsMap.put(app.getAttestationFormat(), app);
        }
    }

    public AttestationFormatProcessor getCommandProcessor(String fmtFormat) {
        try {
            AttestationFormat attestationFormat = AttestationFormat.valueOf(fmtFormat.replace('-', '_'));
            return this.processorsMap.get((Object)attestationFormat);
        }
        catch (Exception e) {
            throw new Fido2RPRuntimeException("Unsupported format " + e.getMessage());
        }
    }

    @Produces
    @ApplicationScoped
    @Named(value="supportedAttestationFormats")
    public List<String> getSupportedAttestationFormats() {
        return Arrays.stream(AttestationFormat.values()).map(f -> f.getFmt()).collect(Collectors.toList());
    }
}

