/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.fido2.service.processors.impl;

import java.util.EnumMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.gluu.oxauth.fido2.ctap.AttestationFormat;
import org.gluu.oxauth.fido2.exception.Fido2RPRuntimeException;
import org.gluu.oxauth.fido2.service.processors.impl.AssertionFormatProcessor;

@ApplicationScoped
public class AssertionProcessorFactory {
    private Map<AttestationFormat, AssertionFormatProcessor> processorsMap;

    @Inject
    private void initCommandProcessors(@Any Instance<AssertionFormatProcessor> assertionFormatProcessors) {
        this.processorsMap = new EnumMap<AttestationFormat, AssertionFormatProcessor>(AttestationFormat.class);
        for (AssertionFormatProcessor app : assertionFormatProcessors) {
            this.processorsMap.put(app.getAttestationFormat(), app);
        }
    }

    public AssertionFormatProcessor getCommandProcessor(String fmtFormat) {
        try {
            AttestationFormat attestationFormat = AttestationFormat.valueOf(fmtFormat.replace('-', '_'));
            return this.processorsMap.get((Object)attestationFormat);
        }
        catch (Exception e) {
            throw new Fido2RPRuntimeException("Unsupported format " + e.getMessage());
        }
    }
}

