/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.fido2.service.processors.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.gluu.oxauth.fido2.certification.CertificationKeyStoreUtils;
import org.gluu.oxauth.fido2.cryptoutils.AndroidKeyUtils;
import org.gluu.oxauth.fido2.cryptoutils.CryptoUtils;
import org.gluu.oxauth.fido2.ctap.AttestationFormat;
import org.gluu.oxauth.fido2.exception.Fido2RPRuntimeException;
import org.gluu.oxauth.fido2.model.auth.AuthData;
import org.gluu.oxauth.fido2.model.auth.CredAndCounterData;
import org.gluu.oxauth.fido2.model.entry.Fido2RegistrationData;
import org.gluu.oxauth.fido2.service.CertificateValidator;
import org.gluu.oxauth.fido2.service.processors.AttestationFormatProcessor;
import org.gluu.oxauth.fido2.service.verifier.CommonVerifiers;
import org.slf4j.Logger;

@ApplicationScoped
public class AndroidKeyAttestationProcessor
implements AttestationFormatProcessor {
    @Inject
    private Logger log;
    @Inject
    private CommonVerifiers commonVerifiers;
    @Inject
    private CryptoUtils cryptoUtils;
    @Inject
    private CertificateValidator certificateValidator;
    @Inject
    private AndroidKeyUtils androidKeyUtils;
    @Inject
    private CertificationKeyStoreUtils utils;

    @Override
    public AttestationFormat getAttestationFormat() {
        return AttestationFormat.android_key;
    }

    @Override
    public void process(JsonNode attStmt, AuthData authData, Fido2RegistrationData credential, byte[] clientDataHash, CredAndCounterData credIdAndCounters) {
        this.log.info("Android-key payload ");
        Iterator i = attStmt.get("x5c").elements();
        ArrayList<String> certificatePath = new ArrayList<String>();
        while (i.hasNext()) {
            certificatePath.add(((JsonNode)i.next()).asText());
        }
        List<X509Certificate> certificates = this.cryptoUtils.getCertificates(certificatePath);
        List<X509Certificate> trustAnchorCertificates = this.utils.getCertificates(authData);
        X509Certificate verifiedCert = this.certificateValidator.verifyAttestationCertificates(certificates, trustAnchorCertificates);
        ECPublicKey pubKey = (ECPublicKey)verifiedCert.getPublicKey();
        try {
            ASN1Sequence extensionData = this.androidKeyUtils.extractAttestationSequence(verifiedCert);
            int attestationVersion = AndroidKeyUtils.getIntegerFromAsn1(extensionData.getObjectAt(0));
            int attestationSecurityLevel = AndroidKeyUtils.getIntegerFromAsn1(extensionData.getObjectAt(1));
            int keymasterSecurityLevel = AndroidKeyUtils.getIntegerFromAsn1(extensionData.getObjectAt(3));
            byte[] attestationChallenge = ((ASN1OctetString)extensionData.getObjectAt(4)).getOctets();
            if (!Arrays.equals(clientDataHash, attestationChallenge)) {
                throw new Fido2RPRuntimeException("Invalid android key attestation ");
            }
            ASN1Encodable[] softwareEnforced = ((ASN1Sequence)extensionData.getObjectAt(6)).toArray();
            ASN1Encodable[] aSN1EncodableArray = ((ASN1Sequence)extensionData.getObjectAt(7)).toArray();
        }
        catch (Exception e) {
            this.log.warn("Problem with android key", (Throwable)e);
            throw new Fido2RPRuntimeException("Problem with android key");
        }
        String signature = this.commonVerifiers.verifyBase64String(attStmt.get("sig"));
        this.commonVerifiers.verifyAttestationSignature(authData, clientDataHash, signature, verifiedCert, authData.getKeyType());
    }
}

