/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.fido2.service.mds;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.ECDSAVerifier;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.apache.commons.codec.digest.DigestUtils;
import org.gluu.oxauth.fido2.cryptoutils.CryptoUtils;
import org.gluu.oxauth.fido2.exception.Fido2RPRuntimeException;
import org.gluu.oxauth.fido2.service.Base64Service;
import org.gluu.oxauth.fido2.service.CertificateValidator;
import org.gluu.oxauth.fido2.service.DataMapperService;
import org.slf4j.Logger;
import org.xdi.oxauth.model.configuration.AppConfiguration;
import org.xdi.oxauth.model.configuration.Fido2Configuration;
import org.xdi.service.cdi.event.ApplicationInitialized;
import org.xdi.util.StringHelper;

@ApplicationScoped
public class MdsTocService {
    @Inject
    private Logger log;
    @Inject
    private DataMapperService dataMapperService;
    @Inject
    private CertificateValidator certificateValidator;
    @Inject
    private CryptoUtils cryptoUtils;
    @Inject
    private Base64Service base64Service;
    @Inject
    private AppConfiguration appConfiguration;
    private Map<String, JsonNode> tocEntries;
    private MessageDigest digester;

    @PostConstruct
    public void create() {
        this.tocEntries = Collections.synchronizedMap(new HashMap());
    }

    public void init(@Observes @ApplicationInitialized(value=ApplicationScoped.class) Object init) {
        this.tocEntries.putAll(this.parseTOCs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, JsonNode> parseTOCs() {
        Fido2Configuration fido2Configuration = this.appConfiguration.getFido2Configuration();
        if (fido2Configuration == null) {
            this.log.warn("Fido2 configuration not exists");
            return new HashMap<String, JsonNode>();
        }
        String mdsTocRootCertFile = fido2Configuration.getMdsTocRootCertFile();
        String mdsTocFilesFolder = fido2Configuration.getMdsTocFilesFolder();
        if (StringHelper.isEmpty((String)mdsTocRootCertFile) || StringHelper.isEmpty((String)mdsTocFilesFolder)) {
            this.log.warn("Fido2 MDS properties should be set");
            return new HashMap<String, JsonNode>();
        }
        this.log.info("Populating TOC entries from {}", (Object)mdsTocFilesFolder);
        Path path = FileSystems.getDefault().getPath(mdsTocFilesFolder, new String[0]);
        DirectoryStream<Path> directoryStream = null;
        ArrayList<Map<String, JsonNode>> maps = new ArrayList<Map<String, JsonNode>>();
        try {
            directoryStream = Files.newDirectoryStream(path);
            for (Path filePath : directoryStream) {
                try {
                    maps.add(this.parseTOC(mdsTocRootCertFile, filePath));
                }
                catch (IOException e) {
                    this.log.warn("Can't access or open path: {}", (Object)filePath, (Object)e);
                }
                catch (ParseException e) {
                    this.log.warn("Can't parse path: {}", (Object)filePath, (Object)e);
                }
            }
        }
        catch (Exception e) {
            this.log.warn("Something wrong with path", (Throwable)e);
        }
        finally {
            if (directoryStream != null) {
                try {
                    directoryStream.close();
                }
                catch (IOException e) {
                    this.log.warn("Something wrong with directory stream");
                }
            }
        }
        return this.mergeAndResolveDuplicateEntries(maps);
    }

    private Map<String, JsonNode> parseTOC(String mdsTocRootCertFile, String mdsTocFileLocation) {
        try {
            return this.parseTOC(mdsTocRootCertFile, FileSystems.getDefault().getPath(mdsTocFileLocation, new String[0]));
        }
        catch (IOException e) {
            throw new Fido2RPRuntimeException("Unable to read TOC at " + mdsTocFileLocation, e);
        }
        catch (ParseException e) {
            throw new Fido2RPRuntimeException("Unable to parse TOC at " + mdsTocFileLocation, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Map<String, JsonNode> parseTOC(String mdsTocRootCertFile, Path path) throws IOException, ParseException {
        BufferedReader reader = null;
        try {
            reader = Files.newBufferedReader(path);
            JWSObject jwsObject = JWSObject.parse((String)reader.readLine());
            List<String> certificateChain = jwsObject.getHeader().getX509CertChain().stream().map(c -> this.base64Service.encodeToString(c.decode())).collect(Collectors.toList());
            JWSAlgorithm algorithm = jwsObject.getHeader().getAlgorithm();
            try {
                JWSVerifier verifier = this.resolveVerifier(algorithm, mdsTocRootCertFile, certificateChain);
                if (!jwsObject.verify(verifier)) {
                    this.log.warn("Unable to verify JWS object using algorithm {} for file {}", (Object)algorithm, (Object)path);
                    Map<String, JsonNode> map = Collections.emptyMap();
                    return map;
                }
            }
            catch (JOSEException e) {
                this.log.warn("Unable to verify JWS object using algorithm {} for file {} {} ", new Object[]{algorithm, path, e});
                Map<String, JsonNode> map = Collections.emptyMap();
                return map;
            }
            catch (Fido2RPRuntimeException e) {
                Map<String, JsonNode> map;
                block22: {
                    this.log.warn("Unable to verify JWS object using algorithm {} for file {} {}", new Object[]{algorithm, path, e});
                    map = Collections.emptyMap();
                    if (reader == null) break block22;
                    try {
                        reader.close();
                    }
                    catch (IOException e2) {
                        this.log.warn("Unable to close reader {}", (Object)path);
                    }
                }
                return map;
            }
            this.digester = this.resolveDigester(algorithm);
            String jwtPayload = jwsObject.getPayload().toString();
            JsonNode toc = this.dataMapperService.readTree(jwtPayload);
            this.log.info("Legal header {}", (Object)toc.get("legalHeader"));
            ArrayNode entries = (ArrayNode)toc.get("entries");
            int numberOfEntries = toc.get("no").asInt();
            this.log.info("Property 'no' value: {}. Number of entries: {}", (Object)numberOfEntries, (Object)entries.size());
            Iterator iter = entries.elements();
            HashMap<String, JsonNode> tocEntries = new HashMap<String, JsonNode>();
            while (iter.hasNext()) {
                JsonNode tocEntry = (JsonNode)iter.next();
                if (!tocEntry.hasNonNull("aaguid")) continue;
                String aaguid = tocEntry.get("aaguid").asText();
                this.log.info("Added TOC entry {} from {} with status {}", new Object[]{aaguid, path, tocEntry.get("statusReports").findValue("status")});
                tocEntries.put(aaguid, tocEntry);
            }
            HashMap<String, JsonNode> hashMap = tocEntries;
            return hashMap;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    this.log.warn("Unable to close reader {}", (Object)path);
                }
            }
        }
    }

    private JWSVerifier resolveVerifier(JWSAlgorithm algorithm, String mdsTocRootCertFile, List<String> certificateChain) {
        Path path = FileSystems.getDefault().getPath(mdsTocRootCertFile, new String[0]);
        List<X509Certificate> x509CertificateChain = this.cryptoUtils.getCertificates(certificateChain);
        ArrayList<X509Certificate> x509TrustedCertificates = new ArrayList<X509Certificate>();
        try {
            x509TrustedCertificates.add(this.cryptoUtils.getCertificate(Files.newInputStream(path, new OpenOption[0])));
        }
        catch (IOException e) {
            throw new Fido2RPRuntimeException("Unable to read the root cert " + path, e);
        }
        X509Certificate verifiedCert = this.certificateValidator.verifyAttestationCertificates(x509CertificateChain, x509TrustedCertificates);
        if (JWSAlgorithm.ES256.equals((Object)algorithm)) {
            try {
                ECDSAVerifier verifier = new ECDSAVerifier((ECPublicKey)verifiedCert.getPublicKey());
                return verifier;
            }
            catch (JOSEException e) {
                throw new Fido2RPRuntimeException("Unable to create verifier for algorithm " + algorithm, e);
            }
        }
        throw new Fido2RPRuntimeException("Don't know what to do with " + algorithm);
    }

    private MessageDigest resolveDigester(JWSAlgorithm algorithm) {
        if (JWSAlgorithm.ES256.equals((Object)algorithm)) {
            return DigestUtils.getSha256Digest();
        }
        throw new Fido2RPRuntimeException("Don't know what to do with " + algorithm);
    }

    private Map<String, JsonNode> mergeAndResolveDuplicateEntries(List<Map<String, JsonNode>> maps) {
        HashMap<String, JsonNode> allEntries = new HashMap<String, JsonNode>();
        Map[] a = new Map[maps.size()];
        maps.toArray(a);
        allEntries.putAll(Stream.of(a).flatMap(m -> m.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> {
            this.log.warn("Duplicate values {} {}", v1, v2);
            LocalDate dateV1 = this.getDate((JsonNode)v1);
            LocalDate dateV2 = this.getDate((JsonNode)v2);
            JsonNode result = dateV1.isAfter(dateV2) ? v1 : v2;
            this.log.warn("Selected value {} ", (Object)result);
            return result;
        })));
        return allEntries;
    }

    private LocalDate getDate(JsonNode n) {
        JsonNode dateNode = n.get("timeOfLastStatusChange");
        LocalDate date = dateNode != null ? LocalDate.parse(dateNode.asText(), DateTimeFormatter.ISO_DATE) : LocalDate.now();
        return date;
    }

    public JsonNode getAuthenticatorsMetadata(String aaguid) {
        return this.tocEntries.get(aaguid);
    }

    public MessageDigest getDigester() {
        return this.digester;
    }
}

