/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.fido2.service.mds;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Hex;
import org.gluu.oxauth.fido2.exception.Fido2RPRuntimeException;
import org.gluu.oxauth.fido2.service.Base64Service;
import org.gluu.oxauth.fido2.service.DataMapperService;
import org.gluu.oxauth.fido2.service.mds.AuthenticatorStatus;
import org.gluu.oxauth.fido2.service.mds.MdsTocService;
import org.gluu.oxauth.fido2.service.processors.impl.ResteasyClientFactory;
import org.gluu.oxauth.fido2.service.verifier.CommonVerifiers;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.slf4j.Logger;
import org.xdi.oxauth.model.configuration.AppConfiguration;

@ApplicationScoped
public class MdsService {
    @Inject
    private Logger log;
    @Inject
    private CommonVerifiers commonVerifiers;
    @Inject
    private MdsTocService mdsTocService;
    @Inject
    private DataMapperService dataMapperService;
    @Inject
    private Base64Service base64Service;
    @Inject
    private ResteasyClientFactory resteasyClientFactory;
    @Inject
    private AppConfiguration appConfiguration;

    public JsonNode fetchMetadata(byte[] aaguidBuffer) {
        URI metadataUrl;
        String aaguid = this.deconvert(aaguidBuffer);
        JsonNode tocEntry = this.mdsTocService.getAuthenticatorsMetadata(aaguid);
        if (tocEntry == null) {
            throw new Fido2RPRuntimeException("Authenticator not in TOC aaguid " + aaguid);
        }
        try {
            metadataUrl = new URI(tocEntry.get("url").asText());
            this.log.info("Authenticator AAGUI {} url metadataUrl {} ", (Object)aaguid, (Object)metadataUrl);
        }
        catch (URISyntaxException e) {
            throw new Fido2RPRuntimeException("Invalid URI in TOC aaguid " + aaguid);
        }
        this.verifyTocEntryStatus(aaguid, tocEntry);
        String metadataHash = this.commonVerifiers.verifyThatString(tocEntry, "hash");
        this.log.info("Reaching MDS at {}", (Object)metadataUrl.toString());
        ResteasyClient resteasyClient = this.resteasyClientFactory.buildResteasyClient();
        Response response = resteasyClient.target(metadataUrl).request().header("Content-Type", (Object)"application/json").get();
        String body = (String)response.readEntity(String.class);
        Response.StatusType status = response.getStatusInfo();
        this.log.info("Response from resource server {}", (Object)status);
        if (status.getFamily() == Response.Status.Family.SUCCESSFUL) {
            byte[] bodyBuffer;
            try {
                bodyBuffer = body.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new Fido2RPRuntimeException("Unable to verify metadata hash for aaguid " + this.deconvert(aaguidBuffer));
            }
            byte[] digest = this.mdsTocService.getDigester().digest(bodyBuffer);
            if (!Arrays.equals(digest, this.base64Service.urlDecode(metadataHash))) {
                throw new Fido2RPRuntimeException("Unable to verify metadata hash for aaguid " + this.deconvert(aaguidBuffer));
            }
            try {
                return this.dataMapperService.readTree(this.base64Service.urlDecode(body));
            }
            catch (IOException e) {
                this.log.warn("Can't parse payload from the server ");
                throw new Fido2RPRuntimeException("Unable to parse payload from server for aaguid " + this.deconvert(aaguidBuffer));
            }
        }
        throw new Fido2RPRuntimeException("Unable to retrieve metadata for aaguid " + this.deconvert(aaguidBuffer) + " status " + status);
    }

    private void verifyTocEntryStatus(String aaguid, JsonNode tocEntry) {
        JsonNode statusReports = tocEntry.get("statusReports");
        Iterator iter = statusReports.elements();
        while (iter.hasNext()) {
            JsonNode statusReport = (JsonNode)iter.next();
            AuthenticatorStatus authenticatorStatus = AuthenticatorStatus.valueOf(statusReport.get("status").asText());
            String authenticatorEffectiveDate = statusReport.get("effectiveDate").asText();
            this.log.info("Authenticator AAGUI {} status {} effective date {}", new Object[]{aaguid, authenticatorStatus, authenticatorEffectiveDate});
            this.verifyStatusAcceptable(aaguid, authenticatorStatus);
        }
    }

    private String deconvert(byte[] aaguidBuffer) {
        return Hex.encodeHexString((byte[])aaguidBuffer).replaceFirst("([0-9a-fA-F]{8})([0-9a-fA-F]{4})([0-9a-fA-F]{4})([0-9a-fA-F]{4})([0-9a-fA-F]+)", "$1-$2-$3-$4-$5");
    }

    private void verifyStatusAcceptable(String aaguid, AuthenticatorStatus status) {
        List<AuthenticatorStatus> undesiredAuthenticatorStatus = Arrays.asList(AuthenticatorStatus.USER_VERIFICATION_BYPASS, AuthenticatorStatus.ATTESTATION_KEY_COMPROMISE, AuthenticatorStatus.USER_KEY_REMOTE_COMPROMISE, AuthenticatorStatus.USER_KEY_PHYSICAL_COMPROMISE, AuthenticatorStatus.ATTESTATION_KEY_COMPROMISE);
        if (undesiredAuthenticatorStatus.contains((Object)status)) {
            throw new Fido2RPRuntimeException("Authenticator " + aaguid + "status undesirable " + (Object)((Object)status));
        }
    }
}

