/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.fido2.service;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.fasterxml.jackson.dataformat.cbor.CBORParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.slf4j.Logger;

@ApplicationScoped
public class DataMapperService {
    @Inject
    private Logger log;
    private ObjectMapper objectMapper;
    private CBORFactory cborFactory;
    private ObjectMapper cborObjectMapper;

    @PostConstruct
    public void init() {
        this.objectMapper = new ObjectMapper();
        this.cborFactory = new CBORFactory();
        this.cborObjectMapper = new ObjectMapper((JsonFactory)this.cborFactory);
    }

    public JsonNode readTree(byte[] content) throws IOException {
        return this.objectMapper.readTree(content);
    }

    public JsonNode readTree(String content) throws IOException {
        return this.objectMapper.readTree(content);
    }

    public JsonNode readTree(BufferedReader reader) throws IOException {
        return this.objectMapper.readTree((Reader)reader);
    }

    public ObjectNode createObjectNode() {
        return this.objectMapper.createObjectNode();
    }

    public JsonNode cborReadTree(byte[] content) throws IOException {
        return this.cborObjectMapper.readTree(content);
    }

    public CBORParser cborCreateParser(byte[] data) throws IOException {
        return this.cborFactory.createParser(data);
    }

    public <T> T convertValue(Object fromValue, Class<T> toValueType) {
        return (T)this.objectMapper.convertValue(fromValue, toValueType);
    }
}

