/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.fido2.service;

import java.io.File;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.gluu.oxauth.fido2.exception.Fido2RPRuntimeException;
import org.gluu.oxauth.fido2.service.Base64Service;
import org.slf4j.Logger;

@ApplicationScoped
public class CertificateValidator {
    @Inject
    private Logger log;
    @Inject
    private Base64Service base64Service;

    public void saveCertificate(X509Certificate certificate) throws IOException {
        FileUtils.writeStringToFile((File)new File("c:/tmp/cert-" + certificate.getSerialNumber() + ".crt"), (String)certificate.toString());
    }

    public void checkForTrustedCertsInAttestation(List<X509Certificate> attestationCerts, List<X509Certificate> trustChainCertificates) {
        List trustedSignatures = trustChainCertificates.stream().map(cert -> this.base64Service.encodeToString(cert.getSignature())).collect(Collectors.toList());
        List duplicateSignatures = attestationCerts.stream().map(cert -> this.base64Service.encodeToString(cert.getSignature())).filter(sig -> trustedSignatures.contains(sig)).collect(Collectors.toList());
        if (!duplicateSignatures.isEmpty()) {
            throw new Fido2RPRuntimeException("Root certificate in the attestation ");
        }
    }

    public X509Certificate verifyAttestationCertificates(List<X509Certificate> certs, List<X509Certificate> trustChainCertificates) {
        try {
            this.checkForTrustedCertsInAttestation(certs, trustChainCertificates);
            Set<TrustAnchor> trustAnchors = trustChainCertificates.parallelStream().map(f -> new TrustAnchor((X509Certificate)f, null)).collect(Collectors.toSet());
            if (trustAnchors.isEmpty()) {
                this.log.warn("Empty list of trust managers");
                return certs.get(0);
            }
            PKIXParameters params = new PKIXParameters(trustAnchors);
            CertPathValidator cpv = CertPathValidator.getInstance("PKIX");
            PKIXRevocationChecker rc = (PKIXRevocationChecker)cpv.getRevocationChecker();
            rc.setOptions(EnumSet.of(PKIXRevocationChecker.Option.SOFT_FAIL, PKIXRevocationChecker.Option.PREFER_CRLS));
            params.addCertPathChecker(rc);
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            CertPath certPath = certFactory.generateCertPath(certs);
            X509Certificate cert = this.verifyPath(cpv, certPath, params);
            if (cert != null) {
                return cert;
            }
            params = new PKIXParameters(trustAnchors);
            cpv = CertPathValidator.getInstance("PKIX");
            rc = (PKIXRevocationChecker)cpv.getRevocationChecker();
            rc.setOptions(Collections.emptySet());
            params.setRevocationEnabled(false);
            params.addCertPathChecker(null);
            return this.verifyPath(cpv, certPath, params);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | CertificateException e) {
            this.log.warn("Cert verification problem {}", (Object)e.getMessage(), (Object)e);
            throw new Fido2RPRuntimeException("Problem with certificate");
        }
    }

    private X509Certificate verifyPath(CertPathValidator cpv, CertPath certPath, PKIXParameters params) {
        try {
            cpv.validate(certPath, params);
            return (X509Certificate)certPath.getCertificates().get(0);
        }
        catch (CertPathValidatorException ex) {
            if (ex.getReason() == CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS) {
                this.log.info("Cert not validated against the root {}", (Object)ex.getMessage());
                return null;
            }
            this.log.warn("Cert not validated against the root {}", (Object)ex.getMessage());
            throw new Fido2RPRuntimeException("Problem with certificate " + ex.getMessage());
        }
        catch (InvalidAlgorithmParameterException e) {
            this.log.warn("Cert verification problem {}", (Object)e.getMessage(), (Object)e);
            throw new Fido2RPRuntimeException("Problem with certificate");
        }
    }

    public boolean isSelfSigned(X509Certificate cert) {
        return this.isSelfSigned(cert, cert.getPublicKey());
    }

    public boolean isSelfSigned(X509Certificate cert, PublicKey key) {
        try {
            cert.verify(key);
            return cert.getIssuerDN().equals(cert.getSubjectDN());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e) {
            this.log.warn("Probably not self signed cert. Cert verification problem {}", (Object)e.getMessage());
            return false;
        }
    }
}

