/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.fido2.service;

import java.util.Base64;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.slf4j.Logger;

@ApplicationScoped
public class Base64Service {
    @Inject
    private Logger log;
    private Base64.Encoder base64Encoder;
    private Base64.Decoder base64Decoder;
    private Base64.Encoder base64UrlEncoder;
    private Base64.Decoder base64UrlDecoder;

    @PostConstruct
    public void init() {
        this.base64Encoder = Base64.getEncoder().withoutPadding();
        this.base64Decoder = Base64.getDecoder();
        this.base64UrlEncoder = Base64.getUrlEncoder().withoutPadding();
        this.base64UrlDecoder = Base64.getUrlDecoder();
    }

    public String encodeToString(byte[] src) {
        return this.base64Encoder.encodeToString(src);
    }

    public byte[] decode(byte[] src) {
        return this.base64Decoder.decode(src);
    }

    public byte[] decode(String src) {
        return this.base64Decoder.decode(src);
    }

    public String urlEncodeToString(byte[] src) {
        return this.base64UrlEncoder.encodeToString(src);
    }

    public String urlEncodeToStringWithoutPadding(byte[] src) {
        return this.base64UrlEncoder.withoutPadding().encodeToString(src);
    }

    public byte[] urlDecode(byte[] src) {
        return this.base64UrlDecoder.decode(src);
    }

    public byte[] urlDecode(String src) {
        return this.base64UrlDecoder.decode(src);
    }
}

