/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.fido2.service;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.dataformat.cbor.CBORParser;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.codec.binary.Hex;
import org.gluu.oxauth.fido2.exception.Fido2RPRuntimeException;
import org.gluu.oxauth.fido2.model.auth.AuthData;
import org.gluu.oxauth.fido2.service.Base64Service;
import org.gluu.oxauth.fido2.service.DataMapperService;
import org.gluu.oxauth.fido2.service.verifier.CommonVerifiers;
import org.slf4j.Logger;

@ApplicationScoped
public class AuthenticatorDataParser {
    @Inject
    private Logger log;
    @Inject
    private DataMapperService dataMapperService;
    @Inject
    private Base64Service base64Service;
    @Inject
    private CommonVerifiers commonVerifiers;

    public AuthData parseAttestationData(String incomingAuthData) {
        return this.parseAuthData(incomingAuthData, true);
    }

    public AuthData parseAssertionData(String incomingAuthData) {
        return this.parseAuthData(incomingAuthData, false);
    }

    private AuthData parseAuthData(String incomingAuthData, boolean isAttestation) {
        AuthData authData = new AuthData();
        byte[] buffer = isAttestation ? this.base64Service.decode(incomingAuthData.getBytes()) : this.base64Service.urlDecode(incomingAuthData.getBytes());
        authData.setAuthDataDecoded(buffer);
        int offset = 0;
        byte[] rpIdHashBuffer = Arrays.copyOfRange(buffer, offset, offset += 32);
        this.log.info("RPIDHASH hex {}", (Object)Hex.encodeHexString((byte[])rpIdHashBuffer));
        byte[] flagsBuffer = Arrays.copyOfRange(buffer, offset++, offset);
        boolean hasAtFlag = this.commonVerifiers.verifyAtFlag(flagsBuffer);
        this.log.info("FLAGS hex {}", (Object)Hex.encodeHexString((byte[])flagsBuffer));
        byte[] counterBuffer = Arrays.copyOfRange(buffer, offset, offset += 4);
        this.log.info("COUNTERS hex {}", (Object)Hex.encodeHexString((byte[])counterBuffer));
        authData.setRpIdHash(rpIdHashBuffer).setFlags(flagsBuffer).setCounters(counterBuffer);
        byte[] attestationBuffer = Arrays.copyOfRange(buffer, offset, buffer.length);
        this.commonVerifiers.verifyAttestationBuffer(hasAtFlag, attestationBuffer);
        if (hasAtFlag) {
            byte[] aaguidBuffer = Arrays.copyOfRange(buffer, offset, offset += 16);
            this.log.info("AAGUID hex {}", (Object)Hex.encodeHexString((byte[])aaguidBuffer));
            byte[] credIDLenBuffer = Arrays.copyOfRange(buffer, offset, offset += 2);
            this.log.info("CredIDLen hex {}", (Object)Hex.encodeHexString((byte[])credIDLenBuffer));
            short size = ByteBuffer.wrap(credIDLenBuffer).asShortBuffer().get();
            this.log.info("size {}", (Object)size);
            byte[] credIDBuffer = Arrays.copyOfRange(buffer, offset, offset += size);
            this.log.info("credID hex {}", (Object)Hex.encodeHexString((byte[])credIDBuffer));
            byte[] cosePublicKeyBuffer = Arrays.copyOfRange(buffer, offset, buffer.length);
            this.log.info("cosePublicKey hex {}", (Object)Hex.encodeHexString((byte[])cosePublicKeyBuffer));
            long keySize = 0L;
            CBORParser parser = null;
            try {
                parser = this.dataMapperService.cborCreateParser(cosePublicKeyBuffer);
                while (!parser.isClosed()) {
                    JsonToken t = parser.nextToken();
                    JsonLocation tocloc = parser.getTokenLocation();
                    if (!t.isStructEnd()) continue;
                    keySize = tocloc.getByteOffset();
                    break;
                }
            }
            catch (IOException e) {
                throw new Fido2RPRuntimeException(e.getMessage());
            }
            finally {
                if (parser != null) {
                    try {
                        parser.close();
                    }
                    catch (IOException e) {
                        this.log.info("exception when closing a parser {}", (Object)e.getMessage());
                    }
                }
            }
            offset = (int)((long)offset + keySize);
            int keyType = -100;
            try {
                JsonNode key = this.dataMapperService.cborReadTree(cosePublicKeyBuffer);
                keyType = key.get("3").asInt();
                this.log.info("cosePublicKey {}", (Object)key);
            }
            catch (IOException e) {
                throw new Fido2RPRuntimeException("Unable to parse public key CBOR");
            }
            authData.setAaguid(aaguidBuffer).setCredId(credIDBuffer).setCOSEPublicKey(cosePublicKeyBuffer).setKeyType(keyType);
            byte[] leftovers = Arrays.copyOfRange(buffer, offset, buffer.length);
            this.commonVerifiers.verifyNoLeftovers(leftovers);
        }
        authData.setAttestationBuffer(buffer);
        return authData;
    }

    public int parseCounter(byte[] counter) {
        int cnt = ByteBuffer.wrap(counter).asIntBuffer().get();
        return cnt;
    }
}

