/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.fido2.persist;

import com.unboundid.ldap.sdk.Filter;
import com.unboundid.util.StaticUtils;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import java.util.UUID;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gluu.oxauth.fido2.exception.Fido2RPRuntimeException;
import org.gluu.oxauth.fido2.model.entry.Fido2RegistrationData;
import org.gluu.oxauth.fido2.model.entry.Fido2RegistrationEntry;
import org.gluu.oxauth.fido2.model.entry.Fido2RegistrationStatus;
import org.gluu.site.ldap.persistence.BatchOperation;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.slf4j.Logger;
import org.xdi.ldap.model.SearchScope;
import org.xdi.ldap.model.SimpleBranch;
import org.xdi.oxauth.model.common.User;
import org.xdi.oxauth.model.config.StaticConfiguration;
import org.xdi.oxauth.model.configuration.AppConfiguration;
import org.xdi.oxauth.service.UserService;
import org.xdi.util.StringHelper;

@ApplicationScoped
public class RegistrationPersistenceService {
    @Inject
    private Logger log;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private UserService userService;
    @Inject
    private LdapEntryManager ldapEntryManager;

    public Optional<Fido2RegistrationEntry> findByPublicKeyId(String publicKeyId) {
        Filter publicKeyIdFilter;
        String baseDn = this.getBaseDnForFido2RegistrationEntries(null);
        List fido2RegistrationnEntries = this.ldapEntryManager.findEntries(baseDn, Fido2RegistrationEntry.class, null, publicKeyIdFilter = Filter.createEqualityFilter((String)"oxPublicKeyId", (String)publicKeyId));
        if (fido2RegistrationnEntries.size() > 0) {
            return Optional.of(fido2RegistrationnEntries.get(0));
        }
        return Optional.empty();
    }

    public List<Fido2RegistrationEntry> findAllByUsername(String username) {
        String userInum = this.userService.getUserInum(username);
        if (userInum == null) {
            return Collections.emptyList();
        }
        String baseDn = this.getBaseDnForFido2RegistrationEntries(userInum);
        List fido2RegistrationnEntries = this.ldapEntryManager.findEntries(baseDn, Fido2RegistrationEntry.class, null);
        return fido2RegistrationnEntries;
    }

    public List<Fido2RegistrationEntry> findAllByChallenge(String challenge) {
        String baseDn = this.getBaseDnForFido2RegistrationEntries(null);
        Filter codeChallengFilter = Filter.createEqualityFilter((String)"oxCodeChallenge", (String)challenge);
        Filter codeChallengHashCodeFilter = Filter.createEqualityFilter((String)"oxCodeChallengeHash", (String)String.valueOf(this.getChallengeHashCode(challenge)));
        Filter filter = Filter.createANDFilter((Filter[])new Filter[]{codeChallengFilter, codeChallengHashCodeFilter});
        List fido2RegistrationnEntries = this.ldapEntryManager.findEntries(baseDn, Fido2RegistrationEntry.class, null, filter);
        return fido2RegistrationnEntries;
    }

    public void save(Fido2RegistrationData registrationData) {
        String userName = registrationData.getUsername();
        User user = this.userService.getUser(userName, new String[]{"inum"});
        if (user == null) {
            if (this.appConfiguration.getFido2Configuration().isUserAutoEnrollment()) {
                user = this.userService.addDefaultUser(userName);
            } else {
                throw new Fido2RPRuntimeException("Auto user enrollment was disabled. User not exists!");
            }
        }
        String userInum = this.userService.getUserInum(user);
        this.prepareBranch(userInum);
        Date now = new GregorianCalendar(TimeZone.getTimeZone("UTC")).getTime();
        String id = UUID.randomUUID().toString();
        String challenge = registrationData.getChallenge();
        String dn = this.getDnForRegistrationEntry(userInum, id);
        Fido2RegistrationEntry registrationEntry = new Fido2RegistrationEntry(dn, id, now, userInum, null, registrationData, challenge);
        registrationEntry.setRegistrationStatus(registrationData.getStatus());
        registrationEntry.setChallangeHash(String.valueOf(this.getChallengeHashCode(challenge)));
        registrationData.setCreatedDate(now);
        registrationData.setCreatedBy(userName);
        this.ldapEntryManager.persist((Object)registrationEntry);
    }

    public void update(Fido2RegistrationEntry registrationEntry) {
        Date now = new GregorianCalendar(TimeZone.getTimeZone("UTC")).getTime();
        Fido2RegistrationData registrationData = registrationEntry.getRegistrationData();
        registrationData.setUpdatedDate(now);
        registrationData.setUpdatedBy(registrationData.getUsername());
        registrationEntry.setPublicKeyId(registrationData.getPublicKeyId());
        registrationEntry.setRegistrationStatus(registrationData.getStatus());
        this.ldapEntryManager.merge((Object)registrationEntry);
    }

    public void addBranch(String baseDn) {
        SimpleBranch branch = new SimpleBranch();
        branch.setOrganizationalUnitName("fido2_register");
        branch.setDn(baseDn);
        this.ldapEntryManager.persist((Object)branch);
    }

    public boolean containsBranch(String baseDn) {
        return this.ldapEntryManager.contains(SimpleBranch.class, baseDn);
    }

    public void prepareBranch(String userInum) {
        String baseDn = this.getBaseDnForFido2RegistrationEntries(userInum);
        if (!this.containsBranch(baseDn)) {
            this.addBranch(baseDn);
        }
    }

    public String getDnForRegistrationEntry(String userInum, String oxId) {
        String baseDn = this.getBaseDnForFido2RegistrationEntries(userInum);
        if (StringHelper.isEmpty((String)oxId)) {
            return baseDn;
        }
        return String.format("oxId=%s,%s", oxId, baseDn);
    }

    public String getBaseDnForFido2RegistrationEntries(String userInum) {
        String userBaseDn = this.getDnForUser(userInum);
        if (StringHelper.isEmpty((String)userInum)) {
            return userBaseDn;
        }
        return String.format("ou=fido2_register,%s", userBaseDn);
    }

    public String getDnForUser(String userInum) {
        String peopleDn = this.staticConfiguration.getBaseDn().getPeople();
        if (StringHelper.isEmpty((String)userInum)) {
            return peopleDn;
        }
        return String.format("inum=%s,%s", userInum, peopleDn);
    }

    public void cleanup(Date now, int batchSize) {
        int unfinishedRequestExpiration = this.appConfiguration.getFido2Configuration().getUnfinishedRequestExpiration();
        unfinishedRequestExpiration = unfinishedRequestExpiration == 0 ? 120 : unfinishedRequestExpiration;
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        ((Calendar)calendar).add(13, -unfinishedRequestExpiration);
        final Date unfinishedRequestExpirationDate = calendar.getTime();
        BatchOperation<Fido2RegistrationEntry> cleanerBatchService = new BatchOperation<Fido2RegistrationEntry>(this.ldapEntryManager){

            protected List<Fido2RegistrationEntry> getChunkOrNull(int chunkSize) {
                return RegistrationPersistenceService.this.ldapEntryManager.findEntries(RegistrationPersistenceService.this.getDnForUser(null), Fido2RegistrationEntry.class, this.getFilter(), SearchScope.SUB, new String[]{"oxCodeChallenge", "creationDate"}, (BatchOperation)this, 0, chunkSize, chunkSize);
            }

            protected void performAction(List<Fido2RegistrationEntry> entries) {
                for (Fido2RegistrationEntry p : entries) {
                    RegistrationPersistenceService.this.log.debug("Removing Fido2 registration entry: {}, Creation date: {}", (Object)p.getChallange(), (Object)p.getCreationDate());
                    try {
                        RegistrationPersistenceService.this.ldapEntryManager.remove((Object)p);
                    }
                    catch (Exception e) {
                        RegistrationPersistenceService.this.log.error("Failed to remove entry", (Throwable)e);
                    }
                }
            }

            private Filter getFilter() {
                Filter authenticationStatusFilter = Filter.createNOTFilter((Filter)Filter.createEqualityFilter((String)"oxStatus", (String)Fido2RegistrationStatus.registered.getValue()));
                Filter exirationDateFilter = Filter.createLessOrEqualFilter((String)"creationDate", (String)StaticUtils.encodeGeneralizedTime((Date)unfinishedRequestExpirationDate));
                Filter unfinishedRequestFilter = Filter.createANDFilter((Filter[])new Filter[]{authenticationStatusFilter, exirationDateFilter});
                return unfinishedRequestFilter;
            }
        };
        cleanerBatchService.iterateAllByChunks(batchSize);
        BatchOperation<SimpleBranch> cleanerBranchService = new BatchOperation<SimpleBranch>(this.ldapEntryManager){

            protected List<SimpleBranch> getChunkOrNull(int chunkSize) {
                return RegistrationPersistenceService.this.ldapEntryManager.findEntries(RegistrationPersistenceService.this.getDnForUser(null), SimpleBranch.class, this.getFilter(), SearchScope.SUB, new String[]{"ou"}, (BatchOperation)this, 0, chunkSize, chunkSize);
            }

            protected void performAction(List<SimpleBranch> objects) {
                for (SimpleBranch p : objects) {
                    try {
                        RegistrationPersistenceService.this.ldapEntryManager.remove((Object)p);
                    }
                    catch (Exception e) {
                        RegistrationPersistenceService.this.log.error("Failed to remove entry", (Throwable)e);
                    }
                }
            }

            private Filter getFilter() {
                return Filter.createANDFilter((Filter[])new Filter[]{Filter.createEqualityFilter((String)"ou", (String)"fido2_register"), Filter.createORFilter((Filter[])new Filter[]{Filter.createEqualityFilter((String)"numsubordinates", (String)"0"), Filter.createEqualityFilter((String)"hasSubordinates", (String)"FALSE")})});
            }
        };
        cleanerBranchService.iterateAllByChunks(batchSize);
    }

    public int getChallengeHashCode(String challenge) {
        int hash = 0;
        byte[] challengeBytes = challenge.getBytes();
        for (int j = 0; j < challengeBytes.length; ++j) {
            hash += challengeBytes[j] * j;
        }
        return hash;
    }
}

