/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.fido2.persist;

import com.unboundid.ldap.sdk.Filter;
import com.unboundid.util.StaticUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gluu.oxauth.fido2.exception.Fido2RPRuntimeException;
import org.gluu.oxauth.fido2.model.entry.Fido2AuthenticationData;
import org.gluu.oxauth.fido2.model.entry.Fido2AuthenticationEntry;
import org.gluu.oxauth.fido2.model.entry.Fido2AuthenticationStatus;
import org.gluu.site.ldap.persistence.BatchOperation;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.slf4j.Logger;
import org.xdi.ldap.model.SearchScope;
import org.xdi.ldap.model.SimpleBranch;
import org.xdi.oxauth.model.common.User;
import org.xdi.oxauth.model.config.StaticConfiguration;
import org.xdi.oxauth.model.configuration.AppConfiguration;
import org.xdi.oxauth.service.UserService;
import org.xdi.util.StringHelper;

@ApplicationScoped
public class AuthenticationPersistenceService {
    @Inject
    private Logger log;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private UserService userService;
    @Inject
    private LdapEntryManager ldapEntryManager;

    public List<Fido2AuthenticationEntry> findByChallenge(String challenge) {
        String baseDn = this.getBaseDnForFido2AuthenticationEntries(null);
        Filter codeChallengFilter = Filter.createEqualityFilter((String)"oxCodeChallenge", (String)challenge);
        List fido2AuthenticationEntries = this.ldapEntryManager.findEntries(baseDn, Fido2AuthenticationEntry.class, null, codeChallengFilter);
        return fido2AuthenticationEntries;
    }

    public void save(Fido2AuthenticationData authenticationData) {
        String userName = authenticationData.getUsername();
        User user = this.userService.getUser(userName, new String[]{"inum"});
        if (user == null) {
            if (this.appConfiguration.getFido2Configuration().isUserAutoEnrollment()) {
                user = this.userService.addDefaultUser(userName);
            } else {
                throw new Fido2RPRuntimeException("Auto user enrollment was disabled. User not exists!");
            }
        }
        String userInum = this.userService.getUserInum(user);
        this.prepareBranch(userInum);
        Date now = new GregorianCalendar(TimeZone.getTimeZone("UTC")).getTime();
        String id = UUID.randomUUID().toString();
        String dn = this.getDnForAuthenticationEntry(userInum, id);
        Fido2AuthenticationEntry authenticationEntity = new Fido2AuthenticationEntry(dn, authenticationData.getId(), now, null, userInum, authenticationData);
        authenticationEntity.setAuthenticationStatus(authenticationData.getStatus());
        authenticationData.setCreatedDate(now);
        authenticationData.setCreatedBy(userName);
        this.ldapEntryManager.persist((Object)authenticationEntity);
    }

    public void update(Fido2AuthenticationEntry authenticationEntity) {
        Date now = new GregorianCalendar(TimeZone.getTimeZone("UTC")).getTime();
        Fido2AuthenticationData authenticationData = authenticationEntity.getAuthenticationData();
        authenticationData.setUpdatedDate(now);
        authenticationData.setUpdatedBy(authenticationData.getUsername());
        authenticationEntity.setAuthenticationStatus(authenticationData.getStatus());
        this.ldapEntryManager.merge((Object)authenticationEntity);
        System.err.println("Updated: " + authenticationEntity.getDn());
    }

    public void addBranch(String baseDn) {
        SimpleBranch branch = new SimpleBranch();
        branch.setOrganizationalUnitName("fido2_auth");
        branch.setDn(baseDn);
        this.ldapEntryManager.persist((Object)branch);
    }

    public boolean containsBranch(String baseDn) {
        return this.ldapEntryManager.contains(SimpleBranch.class, baseDn);
    }

    public void prepareBranch(String userInum) {
        String baseDn = this.getBaseDnForFido2AuthenticationEntries(userInum);
        if (!this.containsBranch(baseDn)) {
            this.addBranch(baseDn);
        }
    }

    public String getDnForAuthenticationEntry(String userInum, String oxId) {
        String baseDn = this.getBaseDnForFido2AuthenticationEntries(userInum);
        if (StringHelper.isEmpty((String)oxId)) {
            return baseDn;
        }
        return String.format("oxId=%s,%s", oxId, baseDn);
    }

    public String getBaseDnForFido2AuthenticationEntries(String userInum) {
        String userBaseDn = this.getDnForUser(userInum);
        if (StringHelper.isEmpty((String)userInum)) {
            return userBaseDn;
        }
        return String.format("ou=fido2_auth,%s", userBaseDn);
    }

    public String getDnForUser(String userInum) {
        String peopleDn = this.staticConfiguration.getBaseDn().getPeople();
        if (StringHelper.isEmpty((String)userInum)) {
            return peopleDn;
        }
        return String.format("inum=%s,%s", userInum, peopleDn);
    }

    public void cleanup(Date now, int batchSize) {
        int unfinishedRequestExpiration = this.appConfiguration.getFido2Configuration().getUnfinishedRequestExpiration();
        unfinishedRequestExpiration = unfinishedRequestExpiration == 0 ? 120 : unfinishedRequestExpiration;
        int authenticationHistoryExpiration = this.appConfiguration.getFido2Configuration().getAuthenticationHistoryExpiration();
        authenticationHistoryExpiration = authenticationHistoryExpiration == 0 ? 1296000 : authenticationHistoryExpiration;
        GregorianCalendar calendar1 = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        ((Calendar)calendar1).add(13, -unfinishedRequestExpiration);
        final Date unfinishedRequestExpirationDate = calendar1.getTime();
        GregorianCalendar calendar2 = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        ((Calendar)calendar2).add(13, -authenticationHistoryExpiration);
        final Date authenticationHistoryExpirationDate = calendar2.getTime();
        BatchOperation<Fido2AuthenticationEntry> cleanerBatchService = new BatchOperation<Fido2AuthenticationEntry>(this.ldapEntryManager){

            protected List<Fido2AuthenticationEntry> getChunkOrNull(int chunkSize) {
                return AuthenticationPersistenceService.this.ldapEntryManager.findEntries(AuthenticationPersistenceService.this.getDnForUser(null), Fido2AuthenticationEntry.class, this.getFilter(), SearchScope.SUB, new String[]{"oxCodeChallenge", "creationDate"}, (BatchOperation)this, 0, chunkSize, chunkSize);
            }

            protected void performAction(List<Fido2AuthenticationEntry> entries) {
                for (Fido2AuthenticationEntry p : entries) {
                    try {
                        AuthenticationPersistenceService.this.log.debug("Removing Fido2 authentication entry: {}, Creation date: {}", (Object)p.getChallange(), (Object)p.getCreationDate());
                        AuthenticationPersistenceService.this.ldapEntryManager.remove((Object)p);
                    }
                    catch (Exception e) {
                        AuthenticationPersistenceService.this.log.error("Failed to remove entry", (Throwable)e);
                    }
                }
            }

            private Filter getFilter() {
                Filter authenticationStatusFilter1 = Filter.createNOTFilter((Filter)Filter.createEqualityFilter((String)"oxStatus", (String)Fido2AuthenticationStatus.authenticated.getValue()));
                Filter exirationDateFilter1 = Filter.createLessOrEqualFilter((String)"creationDate", (String)StaticUtils.encodeGeneralizedTime((Date)unfinishedRequestExpirationDate));
                Filter unfinishedRequestFilter = Filter.createANDFilter((Filter[])new Filter[]{authenticationStatusFilter1, exirationDateFilter1});
                Filter authenticationStatusFilter2 = Filter.createEqualityFilter((String)"oxStatus", (String)Fido2AuthenticationStatus.authenticated.getValue());
                Filter exirationDateFilter2 = Filter.createLessOrEqualFilter((String)"creationDate", (String)StaticUtils.encodeGeneralizedTime((Date)authenticationHistoryExpirationDate));
                Filter authenticationHistoryFilter = Filter.createANDFilter((Filter[])new Filter[]{authenticationStatusFilter2, exirationDateFilter2});
                return Filter.createORFilter((Filter[])new Filter[]{unfinishedRequestFilter, authenticationHistoryFilter});
            }
        };
        cleanerBatchService.iterateAllByChunks(batchSize);
        BatchOperation<SimpleBranch> cleanerBranchService = new BatchOperation<SimpleBranch>(this.ldapEntryManager){

            protected List<SimpleBranch> getChunkOrNull(int chunkSize) {
                return AuthenticationPersistenceService.this.ldapEntryManager.findEntries(AuthenticationPersistenceService.this.getDnForUser(null), SimpleBranch.class, this.getFilter(), SearchScope.SUB, new String[]{"ou"}, (BatchOperation)this, 0, chunkSize, chunkSize);
            }

            protected void performAction(List<SimpleBranch> objects) {
                for (SimpleBranch p : objects) {
                    try {
                        AuthenticationPersistenceService.this.ldapEntryManager.remove((Object)p);
                    }
                    catch (Exception e) {
                        AuthenticationPersistenceService.this.log.error("Failed to remove entry", (Throwable)e);
                    }
                }
            }

            private Filter getFilter() {
                return Filter.createANDFilter((Filter[])new Filter[]{Filter.createEqualityFilter((String)"ou", (String)"fido2_auth"), Filter.createORFilter((Filter[])new Filter[]{Filter.createEqualityFilter((String)"numsubordinates", (String)"0"), Filter.createEqualityFilter((String)"hasSubordinates", (String)"FALSE")})});
            }
        };
        cleanerBranchService.iterateAllByChunks(batchSize);
    }
}

