/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.fido2.model.entry;

import java.util.HashMap;
import java.util.Map;
import org.gluu.site.ldap.persistence.annotation.LdapEnum;

public enum Fido2AuthenticationStatus implements LdapEnum
{
    pending("pending", "Pending"),
    authenticated("authenticated", "Authenticated");

    private String value;
    private String displayName;
    private static Map<String, Fido2AuthenticationStatus> mapByValues;

    private Fido2AuthenticationStatus(String value, String displayName) {
        this.value = value;
        this.displayName = displayName;
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static Fido2AuthenticationStatus getByValue(String value) {
        return mapByValues.get(value);
    }

    public Enum<? extends LdapEnum> resolveByValue(String value) {
        return Fido2AuthenticationStatus.getByValue(value);
    }

    public String toString() {
        return this.value;
    }

    static {
        mapByValues = new HashMap<String, Fido2AuthenticationStatus>();
        for (Fido2AuthenticationStatus enumType : Fido2AuthenticationStatus.values()) {
            mapByValues.put(enumType.getValue(), enumType);
        }
    }
}

