/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.fido2.google.safetynet;

import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.json.webtoken.JsonWebSignature;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.SSLException;
import javax.net.ssl.X509TrustManager;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.gluu.oxauth.fido2.google.safetynet.AttestationStatement;

public class OfflineVerify {
    private static final DefaultHostnameVerifier HOSTNAME_VERIFIER = new DefaultHostnameVerifier();

    public static AttestationStatement parseAndVerify(String signedAttestationStatment) {
        return OfflineVerify.parseAndVerify(signedAttestationStatment, null);
    }

    public static AttestationStatement parseAndVerify(String signedAttestationStatment, X509TrustManager tm) {
        X509Certificate cert;
        JsonWebSignature jws;
        try {
            jws = JsonWebSignature.parser((JsonFactory)JacksonFactory.getDefaultInstance()).setPayloadClass(AttestationStatement.class).parse(signedAttestationStatment);
        }
        catch (IOException e) {
            System.err.println("Failure: " + signedAttestationStatment + " is not valid JWS format.");
            return null;
        }
        try {
            cert = tm != null ? jws.verifySignature(tm) : jws.verifySignature();
            if (cert == null) {
                System.err.println("Failure: Signature verification failed.");
                return null;
            }
        }
        catch (GeneralSecurityException e) {
            System.err.println("Failure: Error during cryptographic verification of the JWS signature.");
            return null;
        }
        if (!OfflineVerify.verifyHostname("attest.android.com", cert)) {
            System.err.println("Failure: Certificate isn't issued for the hostname attest.android.com.");
            return null;
        }
        AttestationStatement stmt = (AttestationStatement)jws.getPayload();
        return stmt;
    }

    private static boolean verifyHostname(String hostname, X509Certificate leafCert) {
        try {
            HOSTNAME_VERIFIER.verify(hostname, leafCert);
            return true;
        }
        catch (SSLException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static void process(String signedAttestationStatement) {
        AttestationStatement stmt = OfflineVerify.parseAndVerify(signedAttestationStatement);
        if (stmt == null) {
            System.err.println("Failure: Failed to parse and verify the attestation statement.");
            return;
        }
        System.out.println("Successfully verified the attestation statement. The content is:");
        System.out.println("Nonce: " + Arrays.toString(stmt.getNonce()));
        System.out.println("Timestamp: " + stmt.getTimestampMs() + " ms");
        System.out.println("APK package name: " + stmt.getApkPackageName());
        System.out.println("APK digest SHA256: " + Arrays.toString(stmt.getApkDigestSha256()));
        System.out.println("APK certificate digest SHA256: " + Arrays.deepToString((Object[])stmt.getApkCertificateDigestSha256()));
        System.out.println("CTS profile match: " + stmt.isCtsProfileMatch());
        System.out.println("Has basic integrity: " + stmt.hasBasicIntegrity());
        System.out.println("\n** This sample only shows how to verify the authenticity of an attestation response. Next, you must check that the server response matches the request by comparing the nonce, package name, timestamp and digest.");
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: OfflineVerify <signed attestation statement>");
            return;
        }
        OfflineVerify.process(args[0]);
    }
}

