/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.fido2.ctap;

import java.util.HashMap;
import java.util.Map;

public enum CoseRSAAlgorithm {
    RS256(-257),
    RS65535(-65535),
    RS384(-258),
    RS512(-259),
    RS1(-262),
    PS512(-39),
    PS384(-38),
    PS256(-37);

    private static final Map<Integer, CoseRSAAlgorithm> ALGORITHM_MAPPINGS;
    private final int numericValue;

    private CoseRSAAlgorithm(int value) {
        this.numericValue = value;
    }

    public static CoseRSAAlgorithm fromNumericValue(int value) {
        return ALGORITHM_MAPPINGS.get(value);
    }

    int getNumericValue() {
        return this.numericValue;
    }

    static {
        ALGORITHM_MAPPINGS = new HashMap<Integer, CoseRSAAlgorithm>();
        ALGORITHM_MAPPINGS.put(-65535, RS65535);
        ALGORITHM_MAPPINGS.put(-257, RS256);
        ALGORITHM_MAPPINGS.put(-258, RS384);
        ALGORITHM_MAPPINGS.put(-259, RS512);
        ALGORITHM_MAPPINGS.put(-262, RS1);
        ALGORITHM_MAPPINGS.put(-39, PS512);
        ALGORITHM_MAPPINGS.put(-38, PS384);
        ALGORITHM_MAPPINGS.put(-37, PS256);
    }
}

