/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.fido2.ctap;

import java.util.HashMap;
import java.util.Map;

public enum CoseEC2Algorithm {
    ED256(-260),
    ED512(-261),
    ES256(-7),
    ES384(-36),
    ES512(-37),
    ECDH_ES_HKDF_256(-25);

    private static final Map<Integer, CoseEC2Algorithm> ALGORITHM_MAPPINGS;
    private final int numericValue;

    private CoseEC2Algorithm(int value) {
        this.numericValue = value;
    }

    public static CoseEC2Algorithm fromNumericValue(int value) {
        return ALGORITHM_MAPPINGS.get(value);
    }

    int getNumericValue() {
        return this.numericValue;
    }

    static {
        ALGORITHM_MAPPINGS = new HashMap<Integer, CoseEC2Algorithm>();
        ALGORITHM_MAPPINGS.put(-260, ED256);
        ALGORITHM_MAPPINGS.put(-261, ED512);
        ALGORITHM_MAPPINGS.put(-7, ES256);
        ALGORITHM_MAPPINGS.put(-36, ES384);
        ALGORITHM_MAPPINGS.put(-37, ES512);
        ALGORITHM_MAPPINGS.put(-25, ECDH_ES_HKDF_256);
    }
}

