/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.fido2.cryptoutils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.bouncycastle.jcajce.provider.asymmetric.x509.CertificateFactory;
import org.gluu.oxauth.fido2.exception.Fido2RPRuntimeException;
import org.gluu.oxauth.fido2.service.Base64Service;
import org.slf4j.Logger;

@Deprecated
@ApplicationScoped
public class CryptoUtilsBouncyCastle {
    @Inject
    private Logger log;
    @Inject
    private Base64Service base64Service;

    public X509Certificate getCertificate(String x5c) {
        try {
            return (X509Certificate)new CertificateFactory().engineGenerateCertificate((InputStream)new ByteArrayInputStream(this.base64Service.decode(x5c)));
        }
        catch (CertificateException e) {
            throw new Fido2RPRuntimeException(e.getMessage());
        }
    }

    public List<X509Certificate> getCertificates(ArrayList<String> certificatePath) {
        return certificatePath.parallelStream().map(f -> this.getCertificate((String)f)).filter(c -> {
            try {
                c.checkValidity();
                PublicKey key = c.getPublicKey();
                return true;
            }
            catch (CertificateException e) {
                this.log.warn("Certificate not valid {}", (Object)c.getIssuerDN().getName());
                throw new Fido2RPRuntimeException("Certificate not valid ");
            }
        }).collect(Collectors.toList());
    }
}

