/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.fido2.cryptoutils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gluu.oxauth.fido2.exception.Fido2RPRuntimeException;
import org.gluu.oxauth.fido2.service.Base64Service;
import org.slf4j.Logger;

@ApplicationScoped
public class CryptoUtils {
    @Inject
    private Logger log;
    @Inject
    private Base64Service base64Service;

    public X509Certificate getCertificate(String x509certificate) {
        return this.getCertificate(new ByteArrayInputStream(this.base64Service.decode(x509certificate)));
    }

    public X509Certificate getCertificate(InputStream is) {
        try {
            return (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(is);
        }
        catch (CertificateException e) {
            throw new Fido2RPRuntimeException(e.getMessage());
        }
    }

    public List<X509Certificate> getCertificates(List<String> certificatePath) {
        CertificateFactory cf;
        try {
            cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new Fido2RPRuntimeException(e.getMessage());
        }
        return certificatePath.parallelStream().map(x509certificate -> {
            try {
                return (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(this.base64Service.decode((String)x509certificate)));
            }
            catch (CertificateException e) {
                throw new Fido2RPRuntimeException(e.getMessage());
            }
        }).filter(c -> {
            try {
                c.checkValidity();
                return true;
            }
            catch (CertificateException e) {
                this.log.warn("Certificate not valid {}", (Object)c.getIssuerDN().getName());
                throw new Fido2RPRuntimeException("Certificate not valid ");
            }
        }).collect(Collectors.toList());
    }

    public List<X509Certificate> getCertificates(ArrayList<String> certificatePath) {
        return certificatePath.parallelStream().map(f -> this.getCertificate((String)f)).filter(c -> {
            try {
                c.checkValidity();
                PublicKey key = c.getPublicKey();
                return true;
            }
            catch (CertificateException e) {
                this.log.warn("Certificate not valid {}", (Object)c.getIssuerDN().getName());
                throw new Fido2RPRuntimeException("Certificate not valid ");
            }
        }).collect(Collectors.toList());
    }
}

