/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.fido2.cryptoutils;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.codec.binary.Hex;
import org.gluu.oxauth.fido2.ctap.CoseEC2Algorithm;
import org.gluu.oxauth.fido2.ctap.CoseKeyType;
import org.gluu.oxauth.fido2.ctap.CoseRSAAlgorithm;
import org.gluu.oxauth.fido2.exception.Fido2RPRuntimeException;
import org.gluu.oxauth.fido2.service.Base64Service;
import org.gluu.oxauth.fido2.service.DataMapperService;
import org.slf4j.Logger;

@ApplicationScoped
public class CoseService {
    private static final byte UNCOMPRESSED_POINT_INDICATOR = 4;
    @Inject
    private Logger log;
    @Inject
    private Base64Service base64Service;
    @Inject
    private DataMapperService dataMapperService;

    private static String convertCoseCurveToSunCurveName(int curve) {
        switch (curve) {
            case 1: {
                return "secp256r1";
            }
        }
        throw new Fido2RPRuntimeException("Unsupported curve");
    }

    public int getCodeCurve(JsonNode uncompressedECPointNode) {
        return uncompressedECPointNode.get("-1").asInt();
    }

    public PublicKey createUncompressedPointFromCOSEPublicKey(JsonNode uncompressedECPointNode) {
        int keyToUse = uncompressedECPointNode.get("1").asInt();
        int algorithmToUse = uncompressedECPointNode.get("3").asInt();
        CoseKeyType keyType = CoseKeyType.fromNumericValue(keyToUse);
        switch (keyType) {
            case RSA: {
                CoseRSAAlgorithm coseRSAAlgorithm = CoseRSAAlgorithm.fromNumericValue(algorithmToUse);
                switch (coseRSAAlgorithm) {
                    case RS65535: 
                    case RS256: {
                        byte[] rsaKey_n = this.base64Service.decode(uncompressedECPointNode.get("-1").asText());
                        byte[] rsaKey_e = this.base64Service.decode(uncompressedECPointNode.get("-2").asText());
                        return this.convertUncompressedPointToRSAKey(rsaKey_n, rsaKey_e);
                    }
                }
                throw new Fido2RPRuntimeException("Don't know what to do with this key" + (Object)((Object)keyType));
            }
            case EC2: {
                CoseEC2Algorithm coseEC2Algorithm = CoseEC2Algorithm.fromNumericValue(algorithmToUse);
                switch (coseEC2Algorithm) {
                    case ES256: {
                        int curve = uncompressedECPointNode.get("-1").asInt();
                        byte[] x = this.base64Service.decode(uncompressedECPointNode.get("-2").asText());
                        byte[] y = this.base64Service.decode(uncompressedECPointNode.get("-3").asText());
                        byte[] buffer = ByteBuffer.allocate(1 + x.length + y.length).put((byte)4).put(x).put(y).array();
                        return this.convertUncompressedPointToECKey(buffer, curve);
                    }
                }
                throw new Fido2RPRuntimeException("Don't know what to do with this key" + (Object)((Object)keyType) + " and algorithm " + (Object)((Object)coseEC2Algorithm));
            }
            case OKP: {
                throw new Fido2RPRuntimeException("Don't know what to do with this key" + (Object)((Object)keyType));
            }
        }
        throw new Fido2RPRuntimeException("Don't know what to do with this key" + (Object)((Object)keyType));
    }

    private PublicKey convertUncompressedPointToRSAKey(byte[] rsaKey_n, byte[] rsaKey_e) {
        Object parameters = null;
        try {
            BigInteger n = new BigInteger(1, rsaKey_n);
            BigInteger e = new BigInteger(1, rsaKey_e);
            RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(n, e);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePublic(publicKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            this.log.error("Problem here ", (Throwable)e);
            throw new Fido2RPRuntimeException(e.getMessage());
        }
    }

    public ECPublicKey convertUncompressedPointToECKey(byte[] uncompressedPoint, int curve) {
        AlgorithmParameters parameters = null;
        try {
            parameters = AlgorithmParameters.getInstance("EC");
            parameters.init(new ECGenParameterSpec(CoseService.convertCoseCurveToSunCurveName(curve)));
            ECParameterSpec params = parameters.getParameterSpec(ECParameterSpec.class);
            int offset = 0;
            if (uncompressedPoint[offset++] != 4) {
                throw new IllegalArgumentException("Invalid uncompressedPoint encoding, no uncompressed point indicator");
            }
            int keySizeBytes = (params.getOrder().bitLength() + 8 - 1) / 8;
            if (uncompressedPoint.length != 1 + 2 * keySizeBytes) {
                throw new IllegalArgumentException("Invalid uncompressedPoint encoding, not the correct size");
            }
            BigInteger x = new BigInteger(1, Arrays.copyOfRange(uncompressedPoint, offset, offset + keySizeBytes));
            BigInteger y = new BigInteger(1, Arrays.copyOfRange(uncompressedPoint, offset += keySizeBytes, offset + keySizeBytes));
            ECPoint w = new ECPoint(x, y);
            ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(w, params);
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            return (ECPublicKey)keyFactory.generatePublic(ecPublicKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException | InvalidParameterSpecException e) {
            throw new Fido2RPRuntimeException(e.getMessage());
        }
    }

    public PublicKey getPublicKeyFromUncompressedECPoint(byte[] uncompressedECPointCOSEPubKey) {
        JsonNode uncompressedECPointNode = null;
        try {
            uncompressedECPointNode = this.dataMapperService.cborReadTree(uncompressedECPointCOSEPubKey);
        }
        catch (IOException e) {
            throw new Fido2RPRuntimeException("Unable to parse the structure ");
        }
        this.log.debug("Uncompressed ECpoint node {}", (Object)uncompressedECPointNode.toString());
        PublicKey publicKey = this.createUncompressedPointFromCOSEPublicKey(uncompressedECPointNode);
        this.log.debug("EC Public key hex {}", (Object)Hex.encodeHexString((byte[])publicKey.getEncoded()));
        return publicKey;
    }
}

