/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.fido2.cryptoutils;

import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import javax.enterprise.context.ApplicationScoped;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;

@ApplicationScoped
public class AndroidKeyUtils {
    public static final String KEY_DESCRIPTION_OID = "1.3.6.1.4.1.11129.2.1.17";
    public static final int ATTESTATION_VERSION_INDEX = 0;
    public static final int ATTESTATION_SECURITY_LEVEL_INDEX = 1;
    public static final int KEYMASTER_SECURITY_LEVEL_INDEX = 3;
    public static final int ATTESTATION_CHALLENGE_INDEX = 4;
    public static final int SW_ENFORCED_INDEX = 6;
    public static final int TEE_ENFORCED_INDEX = 7;
    public static final int KM_TAG_PURPOSE = 1;
    public static final int KM_TAG_ALGORITHM = 2;
    public static final int KM_TAG_KEY_SIZE = 3;
    public static final int KM_TAG_USER_AUTH_TYPE = 504;
    public static final int KM_TAG_AUTH_TIMEOUT = 505;
    public static final int KM_TAG_ORIGIN = 702;
    public static final int KM_TAG_ROLLBACK_RESISTANT = 703;
    public static final int KM_PURPOSE_SIGN = 2;
    public static final int KM_ALGORITHM_EC = 3;
    public static final int HW_AUTH_PASSWORD = 1;
    public static final int HW_AUTH_FINGERPRINT = 2;
    public static final int KM_ORIGIN_GENERATED = 0;
    public static final int KM_SECURITY_LEVEL_SOFTWARE = 0;
    public static final int KM_SECURITY_LEVEL_TRUSTED_ENVIRONMENT = 1;
    public static final int EXPECTED_ATTESTATION_VERSION = 1;

    public static int getIntegerFromAsn1(ASN1Encodable asn1Value) throws Exception {
        if (asn1Value instanceof ASN1Integer) {
            return AndroidKeyUtils.bigIntegerToInt(((ASN1Integer)asn1Value).getValue());
        }
        if (asn1Value instanceof ASN1Enumerated) {
            return AndroidKeyUtils.bigIntegerToInt(((ASN1Enumerated)asn1Value).getValue());
        }
        throw new Exception("Integer value expected; found " + asn1Value.getClass().getName() + " instead.");
    }

    public static int bigIntegerToInt(BigInteger bigInt) throws Exception {
        if (bigInt.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0 || bigInt.compareTo(BigInteger.ZERO) < 0) {
            throw new Exception("INTEGER out of bounds");
        }
        return bigInt.intValue();
    }

    public ASN1Sequence extractAttestationSequence(X509Certificate attestationCert) throws Exception, IOException {
        ASN1Sequence decodedSequence;
        byte[] attestationExtensionBytes = attestationCert.getExtensionValue(KEY_DESCRIPTION_OID);
        if (attestationExtensionBytes == null || attestationExtensionBytes.length == 0) {
            throw new Exception("Couldn't find the keystore attestation extension data.");
        }
        try (ASN1InputStream asn1InputStream = new ASN1InputStream(attestationExtensionBytes);){
            byte[] derSequenceBytes = ((ASN1OctetString)asn1InputStream.readObject()).getOctets();
            try (ASN1InputStream seqInputStream = new ASN1InputStream(derSequenceBytes);){
                decodedSequence = (ASN1Sequence)seqInputStream.readObject();
            }
        }
        return decodedSequence;
    }
}

