/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.fido2.certification;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gluu.oxauth.fido2.certification.CertificateHolder;
import org.gluu.oxauth.fido2.service.Base64Service;
import org.slf4j.Logger;

@ApplicationScoped
public class KeyStoreCreator {
    @Inject
    private Logger log;
    @Inject
    private Base64Service base64Service;

    public KeyStore createKeyStore(List<CertificateHolder> certificates) {
        byte[] password = new byte[200];
        new SecureRandom().nextBytes(password);
        try {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null, this.base64Service.encodeToString(password).toCharArray());
            certificates.stream().forEach(ch -> {
                try {
                    ks.setCertificateEntry(ch.getAlias(), ch.getCert());
                }
                catch (KeyStoreException e) {
                    this.log.warn("Can't load certificate {} {}", (Object)ch.getAlias(), (Object)e.getMessage());
                }
            });
            return ks;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    public KeyStore createKeyStore(String aaguid, List<X509Certificate> certificates) {
        byte[] password = new byte[200];
        new SecureRandom().nextBytes(password);
        try {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null, this.base64Service.encodeToString(password).toCharArray());
            AtomicInteger counter = new AtomicInteger(0);
            certificates.stream().forEach(ch -> {
                String alias = aaguid + "-" + counter.incrementAndGet();
                try {
                    ks.setCertificateEntry(alias, (Certificate)ch);
                }
                catch (KeyStoreException e) {
                    this.log.warn("Can't load certificate {} {}", (Object)alias, (Object)e.getMessage());
                }
            });
            return ks;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }
}

