/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.fido2.certification;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.gluu.oxauth.fido2.service.DataMapperService;
import org.slf4j.Logger;
import org.xdi.oxauth.model.configuration.AppConfiguration;
import org.xdi.oxauth.model.configuration.Fido2Configuration;
import org.xdi.service.cdi.event.ApplicationInitialized;
import org.xdi.util.StringHelper;

@ApplicationScoped
public class DirectoryBasedMetadataLoader {
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private DataMapperService dataMapperService;
    private Map<String, JsonNode> authenticatorsMetadata;

    @PostConstruct
    public void create() {
        this.authenticatorsMetadata = Collections.synchronizedMap(new HashMap());
    }

    public void init(@Observes @ApplicationInitialized(value=ApplicationScoped.class) Object init) {
        Fido2Configuration fido2Configuration = this.appConfiguration.getFido2Configuration();
        if (fido2Configuration == null) {
            return;
        }
        String certificationServerMetadataFolder = this.appConfiguration.getFido2Configuration().getCertificationServerMetadataFolder();
        this.log.info("Populating metadata from {}", (Object)certificationServerMetadataFolder);
        this.authenticatorsMetadata.putAll(this.getAAGUIDMapOfMetadata());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, JsonNode> getAAGUIDMapOfMetadata() {
        Map<String, JsonNode> nodes = Collections.synchronizedMap(new HashMap());
        String certificationServerMetadataFolder = this.appConfiguration.getFido2Configuration().getCertificationServerMetadataFolder();
        if (StringHelper.isEmpty((String)certificationServerMetadataFolder)) {
            this.log.debug("Property certificationServerMetadataFolder is empty");
            return nodes;
        }
        Path path = FileSystems.getDefault().getPath(certificationServerMetadataFolder, new String[0]);
        DirectoryStream<Path> directoryStream = null;
        try {
            directoryStream = Files.newDirectoryStream(path);
            for (Path filePath : directoryStream) {
                try {
                    this.log.info("Reading file {}", (Object)filePath);
                    BufferedReader reader = Files.newBufferedReader(filePath);
                    JsonNode jsonNode = this.dataMapperService.readTree(reader);
                    if (jsonNode.hasNonNull("aaguid")) {
                        String aaguid = jsonNode.get("aaguid").asText();
                        String convertedAaguid = aaguid.replaceAll("-", "");
                        this.log.info("AAGUID conversion old {} new {}", (Object)aaguid, (Object)convertedAaguid);
                        nodes.put(convertedAaguid, jsonNode);
                        continue;
                    }
                    this.log.info("No aaguid for file path {}", (Object)filePath);
                }
                catch (IOException e) {
                    this.log.warn("Can't process {}", (Object)filePath, (Object)e);
                }
            }
        }
        catch (IOException e) {
            this.log.warn("Something wrong with path ", (Throwable)e);
        }
        finally {
            if (directoryStream != null) {
                try {
                    directoryStream.close();
                }
                catch (IOException e) {
                    this.log.warn("Something wrong with directory stream", (Throwable)e);
                }
            }
        }
        return nodes;
    }

    public void registerAuthenticatorsMetadata(String aaguid, JsonNode metadata) {
        this.authenticatorsMetadata.put(aaguid, metadata);
    }

    public JsonNode getAuthenticatorsMetadata(String aaguid) {
        return this.authenticatorsMetadata.get(aaguid);
    }
}

