/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.fido2.certification;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.binary.Hex;
import org.gluu.oxauth.fido2.certification.DirectoryBasedMetadataLoader;
import org.gluu.oxauth.fido2.certification.KeyStoreCreator;
import org.gluu.oxauth.fido2.cryptoutils.CryptoUtils;
import org.gluu.oxauth.fido2.model.auth.AuthData;
import org.gluu.oxauth.fido2.service.mds.MdsService;
import org.gluu.oxauth.fido2.service.verifier.CommonVerifiers;
import org.slf4j.Logger;

@ApplicationScoped
public class CertificationKeyStoreUtils {
    @Inject
    private Logger log;
    @Inject
    private KeyStoreCreator keyStoreCreator;
    @Inject
    private CryptoUtils cryptoUtils;
    @Inject
    private CommonVerifiers commonVerifiers;
    @Inject
    private MdsService mdsService;
    @Inject
    private DirectoryBasedMetadataLoader directoryBasedMetadataLoader;

    private List<X509Certificate> getCertificates(JsonNode metadataNode) {
        if (metadataNode == null || !metadataNode.has("attestationRootCertificates")) {
            return Collections.emptyList();
        }
        ArrayNode node = (ArrayNode)metadataNode.get("attestationRootCertificates");
        Iterator iter = node.elements();
        ArrayList<String> x509certificates = new ArrayList<String>();
        while (iter.hasNext()) {
            JsonNode certNode = (JsonNode)iter.next();
            x509certificates.add(certNode.asText());
        }
        return this.cryptoUtils.getCertificates((List<String>)x509certificates);
    }

    public List<X509Certificate> getCertificates(AuthData authData) {
        String aaguid = Hex.encodeHexString((byte[])authData.getAaguid());
        JsonNode metadataForAuthenticator = this.directoryBasedMetadataLoader.getAuthenticatorsMetadata(aaguid);
        if (metadataForAuthenticator == null) {
            this.log.info("No metadata for authenticator {}. Attempting to contact MDS", (Object)aaguid);
            JsonNode metadata = this.mdsService.fetchMetadata(authData.getAaguid());
            this.commonVerifiers.verifyThatMetadataIsValid(metadata);
            this.directoryBasedMetadataLoader.registerAuthenticatorsMetadata(aaguid, metadata);
            metadataForAuthenticator = metadata;
        }
        return this.getCertificates(metadataForAuthenticator);
    }

    public KeyStore getCertificationKeyStore(String aaguid, List<X509Certificate> certificates) {
        return this.keyStoreCreator.createKeyStore(aaguid, certificates);
    }

    public X509TrustManager populateTrustManager(AuthData authData) {
        String aaguid = Hex.encodeHexString((byte[])authData.getAaguid());
        List<X509Certificate> trustedCertificates = this.getCertificates(authData);
        KeyStore keyStore = this.getCertificationKeyStore(aaguid, trustedCertificates);
        TrustManagerFactory trustManagerFactory = null;
        try {
            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            TrustManager[] tms = trustManagerFactory.getTrustManagers();
            return (X509TrustManager)tms[0];
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            this.log.error("Unrecoverable problem with the platform", (Throwable)e);
            System.exit(1);
            return null;
        }
    }
}

