/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import com.unboundid.ldap.sdk.Filter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.slf4j.Logger;
import org.xdi.ldap.model.CustomAttribute;
import org.xdi.ldap.model.GluuStatus;
import org.xdi.oxauth.model.common.User;
import org.xdi.oxauth.model.config.StaticConfiguration;
import org.xdi.oxauth.model.configuration.AppConfiguration;
import org.xdi.oxauth.model.util.Util;
import org.xdi.oxauth.service.InumService;
import org.xdi.util.ArrayHelper;
import org.xdi.util.StringHelper;

@ApplicationScoped
public class UserService {
    public static final String[] USER_OBJECT_CLASSES = new String[]{"gluuPerson"};
    @Inject
    private Logger log;
    @Inject
    private LdapEntryManager ldapEntryManager;
    @Inject
    private InumService inumService;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private AppConfiguration appConfiguration;

    @Nullable
    public User getUserByDn(String dn, String ... returnAttributes) {
        if (Util.isNullOrEmpty((String)dn)) {
            return null;
        }
        return (User)((Object)this.ldapEntryManager.find(User.class, (Object)dn, returnAttributes));
    }

    public User getUserByInum(String inum, String ... returnAttributes) {
        if (StringHelper.isEmpty((String)inum)) {
            return null;
        }
        String userDn = this.getDnForUser(inum);
        User user = this.getUserByDn(userDn, returnAttributes);
        if (user == null) {
            return null;
        }
        return user;
    }

    public User getUser(String userId, String ... returnAttributes) {
        this.log.debug("Getting user information from LDAP: userId = {}", (Object)userId);
        if (StringHelper.isEmpty((String)userId)) {
            return null;
        }
        Filter userUidFilter = Filter.createEqualityFilter((String)"uid", (String)userId);
        List entries = this.ldapEntryManager.findEntries(this.staticConfiguration.getBaseDn().getPeople(), User.class, returnAttributes, userUidFilter);
        this.log.debug("Found {} entries for user id = {}", (Object)entries.size(), (Object)userId);
        if (entries.size() > 0) {
            return (User)((Object)entries.get(0));
        }
        return null;
    }

    public String getUserInum(User user) {
        if (user == null) {
            return null;
        }
        String inum = user.getAttribute("inum");
        return inum;
    }

    public String getUserInum(String userId) {
        User user = this.getUser(userId, "inum");
        return this.getUserInum(user);
    }

    public String getUserNameByInum(String inum) {
        if (StringHelper.isEmpty((String)inum)) {
            return null;
        }
        String userDn = this.getDnForUser(inum);
        User user = this.getUserByDn(userDn, "uid");
        if (user == null) {
            return null;
        }
        return user.getUserId();
    }

    public User updateUser(User user) {
        return (User)((Object)this.ldapEntryManager.merge((Object)user));
    }

    public User addDefaultUser(String uid) {
        String peopleBaseDN = this.staticConfiguration.getBaseDn().getPeople();
        String inum = this.inumService.generatePeopleInum();
        User user = new User();
        user.setDn("inum=" + inum + "," + peopleBaseDN);
        user.setCustomAttributes(Arrays.asList(new CustomAttribute("inum", inum), new CustomAttribute("gluuStatus", GluuStatus.ACTIVE.getValue()), new CustomAttribute("displayName", "User " + uid + " added via oxAuth custom plugin")));
        user.setUserId(uid);
        List personCustomObjectClassList = this.appConfiguration.getPersonCustomObjectClassList();
        if (personCustomObjectClassList != null && !personCustomObjectClassList.isEmpty()) {
            user.setCustomObjectClasses(personCustomObjectClassList.toArray(new String[personCustomObjectClassList.size()]));
        }
        this.ldapEntryManager.persist((Object)user);
        return this.getUser(uid, new String[0]);
    }

    public User addUser(User user, boolean active) {
        String peopleBaseDN = this.staticConfiguration.getBaseDn().getPeople();
        String inum = this.inumService.generatePeopleInum();
        user.setDn("inum=" + inum + "," + peopleBaseDN);
        user.setAttribute("inum", inum);
        GluuStatus status = active ? GluuStatus.ACTIVE : GluuStatus.REGISTER;
        user.setAttribute("gluuStatus", status.getValue());
        List personCustomObjectClassList = this.appConfiguration.getPersonCustomObjectClassList();
        if (personCustomObjectClassList != null && !personCustomObjectClassList.isEmpty()) {
            HashSet<Object> allObjectClasses = new HashSet<Object>();
            allObjectClasses.addAll(personCustomObjectClassList);
            Object[] currentObjectClasses = user.getCustomObjectClasses();
            if (ArrayHelper.isNotEmpty((Object[])currentObjectClasses)) {
                allObjectClasses.addAll(Arrays.asList(currentObjectClasses));
            }
            user.setCustomObjectClasses(allObjectClasses.toArray(new String[allObjectClasses.size()]));
        }
        this.ldapEntryManager.persist((Object)user);
        return this.getUserByDn(user.getDn(), new String[0]);
    }

    public User getUserByAttribute(String attributeName, String attributeValue) {
        this.log.debug("Getting user information from LDAP: attributeName = '{}', attributeValue = '{}'", (Object)attributeName, (Object)attributeValue);
        User user = new User();
        user.setDn(this.staticConfiguration.getBaseDn().getPeople());
        ArrayList<CustomAttribute> customAttributes = new ArrayList<CustomAttribute>();
        customAttributes.add(new CustomAttribute(attributeName, attributeValue));
        user.setCustomAttributes(customAttributes);
        List entries = this.ldapEntryManager.findEntries((Object)user);
        this.log.debug("Found '{}' entries", (Object)entries.size());
        if (entries.size() > 0) {
            return (User)((Object)entries.get(0));
        }
        return null;
    }

    public List<User> getUsersBySample(User user, int limit) {
        this.log.debug("Getting user by sample");
        List entries = this.ldapEntryManager.findEntries((Object)user, limit, limit);
        this.log.debug("Found '{}' entries", (Object)entries.size());
        return entries;
    }

    public User addUserAttributeByUserInum(String userInum, String attributeName, String attributeValue) {
        this.log.debug("Add user attribute by user inum  to LDAP: attributeName = '{}', attributeValue = '{}'", (Object)attributeName, (Object)attributeValue);
        User user = this.getUserByInum(userInum, new String[0]);
        if (user == null) {
            return null;
        }
        boolean result = this.addUserAttribute(user, attributeName, attributeValue);
        if (!result) {
            this.addUserAttribute(user, attributeName, attributeValue);
        }
        return this.updateUser(user);
    }

    public User addUserAttribute(String userId, String attributeName, String attributeValue) {
        this.log.debug("Add user attribute to LDAP: attributeName = '{}', attributeValue = '{}'", (Object)attributeName, (Object)attributeValue);
        User user = this.getUser(userId, new String[0]);
        if (user == null) {
            return null;
        }
        boolean result = this.addUserAttribute(user, attributeName, attributeValue);
        if (!result) {
            return null;
        }
        return this.updateUser(user);
    }

    public boolean addUserAttribute(User user, String attributeName, String attributeValue) {
        CustomAttribute customAttribute = this.getCustomAttribute(user, attributeName);
        if (customAttribute == null) {
            customAttribute = new CustomAttribute(attributeName, attributeValue);
            user.getCustomAttributes().add(customAttribute);
        } else {
            List currentAttributeValues = customAttribute.getValues();
            ArrayList<String> newAttributeValues = new ArrayList<String>();
            newAttributeValues.addAll(currentAttributeValues);
            if (newAttributeValues.contains(attributeValue)) {
                return false;
            }
            newAttributeValues.add(attributeValue);
            customAttribute.setValues(newAttributeValues);
        }
        return true;
    }

    public User removeUserAttribute(String userId, String attributeName, String attributeValue) {
        List currentAttributeValues;
        this.log.debug("Remove user attribute from LDAP: attributeName = '{}', attributeValue = '{}'", (Object)attributeName, (Object)attributeValue);
        User user = this.getUser(userId, new String[0]);
        if (user == null) {
            return null;
        }
        CustomAttribute customAttribute = this.getCustomAttribute(user, attributeName);
        if (customAttribute != null && (currentAttributeValues = customAttribute.getValues()).contains(attributeValue)) {
            ArrayList newAttributeValues = new ArrayList();
            newAttributeValues.addAll(currentAttributeValues);
            if (!currentAttributeValues.contains(attributeValue)) {
                return null;
            }
            newAttributeValues.remove(attributeValue);
            customAttribute.setValues(newAttributeValues);
        }
        return this.updateUser(user);
    }

    public User replaceUserAttribute(String userId, String attributeName, String oldAttributeValue, String newAttributeValue) {
        this.log.debug("Replace user attribute in LDAP: attributeName = '{}', oldAttributeValue = '{}', newAttributeValue = '{}'", new Object[]{attributeName, oldAttributeValue, newAttributeValue});
        User user = this.getUser(userId, new String[0]);
        if (user == null) {
            return null;
        }
        CustomAttribute customAttribute = this.getCustomAttribute(user, attributeName);
        if (customAttribute != null) {
            List currentAttributeValues = customAttribute.getValues();
            ArrayList<String> newAttributeValues = new ArrayList<String>();
            newAttributeValues.addAll(currentAttributeValues);
            if (currentAttributeValues.contains(oldAttributeValue)) {
                newAttributeValues.remove(oldAttributeValue);
            }
            if (!newAttributeValues.contains(newAttributeValue)) {
                newAttributeValues.add(newAttributeValue);
            }
            customAttribute.setValues(newAttributeValues);
        }
        return this.updateUser(user);
    }

    public CustomAttribute getCustomAttribute(User user, String attributeName) {
        for (CustomAttribute customAttribute : user.getCustomAttributes()) {
            if (!StringHelper.equalsIgnoreCase((String)attributeName, (String)customAttribute.getName())) continue;
            return customAttribute;
        }
        return null;
    }

    public void setCustomAttribute(User user, String attributeName, String attributeValue) {
        CustomAttribute customAttribute = this.getCustomAttribute(user, attributeName);
        if (customAttribute == null) {
            customAttribute = new CustomAttribute(attributeName);
            user.getCustomAttributes().add(customAttribute);
        }
        customAttribute.setValue(attributeValue);
    }

    public List<User> getUsersWithPersistentJwts() {
        String baseDN = this.staticConfiguration.getBaseDn().getPeople();
        Filter filter = Filter.createPresenceFilter((String)"oxAuthPersistentJWT");
        return this.ldapEntryManager.findEntries(baseDN, User.class, filter);
    }

    public String getDnForUser(String inum) {
        String peopleDn = this.staticConfiguration.getBaseDn().getPeople();
        if (StringHelper.isEmpty((String)inum)) {
            return peopleDn;
        }
        return String.format("inum=%s,%s", inum, peopleDn);
    }

    public String getUserInumByDn(String dn) {
        if (StringHelper.isEmpty((String)dn)) {
            return null;
        }
        String peopleDn = this.staticConfiguration.getBaseDn().getPeople();
        if (!dn.toLowerCase().endsWith(peopleDn.toLowerCase())) {
            return null;
        }
        String firstDnPart = dn.substring(0, dn.length() - peopleDn.length());
        String[] dnParts = firstDnPart.split(",");
        if (dnParts.length == 0) {
            return null;
        }
        String userInumPart = dnParts[dnParts.length - 1];
        String[] userInumParts = userInumPart.split("=");
        if (userInumParts.length == 2 && StringHelper.equalsIgnoreCase((String)userInumParts[0], (String)"inum")) {
            return userInumParts[1];
        }
        return null;
    }

    public String encodeGeneralizedTime(Date date) {
        return this.ldapEntryManager.encodeGeneralizedTime(date);
    }

    public Date decodeGeneralizedTime(String date) {
        return this.ldapEntryManager.decodeGeneralizedTime(date);
    }
}

