/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.xdi.oxauth.model.common.IdType;
import org.xdi.oxauth.model.configuration.AppConfiguration;
import org.xdi.oxauth.model.util.Pair;
import org.xdi.oxauth.service.api.IdGenerator;

@ApplicationScoped
public class InumService {
    @Inject
    private Logger log;
    @Inject
    @Any
    private IdGenerator idGenService;
    @Inject
    private AppConfiguration appConfiguration;

    public String generateClientInum() {
        return this.generateClientInum(this.appConfiguration.getOrganizationInum());
    }

    public String generateClientInum(String p_organizationInum) {
        return this.idGenService.generateId(IdType.CLIENTS, p_organizationInum);
    }

    public String generatePeopleInum() {
        return this.idGenService.generateId(IdType.PEOPLE, this.appConfiguration.getOrganizationInum());
    }

    public String generateInum() {
        return this.generateClientInum();
    }

    public Pair<String, String> generateNewDN(String baseDn) {
        String inum = this.generateInum();
        StringBuilder dnSb = new StringBuilder("inum=");
        dnSb.append(inum).append(",").append(baseDn);
        String dn = dnSb.toString();
        this.log.trace("Generated dn: {}", (Object)dn);
        return new Pair((Object)inum, (Object)dn);
    }
}

