/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.common;

import java.util.List;
import org.codehaus.jettison.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xdi.ldap.model.CustomAttribute;
import org.xdi.oxauth.model.exception.InvalidClaimException;
import org.xdi.util.StringHelper;

public class SimpleUser
extends org.xdi.ldap.model.SimpleUser {
    private static final Logger log = LoggerFactory.getLogger(SimpleUser.class);
    private static final long serialVersionUID = -2634191420188575733L;

    public Object getAttribute(String userAttribute, boolean optional) throws InvalidClaimException {
        JSONArray attribute = null;
        for (CustomAttribute customAttribute : this.customAttributes) {
            if (!customAttribute.getName().equals(userAttribute)) continue;
            List values = customAttribute.getValues();
            if (values == null) break;
            if (values.size() == 1) {
                attribute = (JSONArray)values.get(0);
                break;
            }
            JSONArray array = new JSONArray();
            for (String v : values) {
                array.put((Object)v);
            }
            attribute = array;
            break;
        }
        log.trace("User's attribute, name - {}, value - {}", (Object)userAttribute, attribute);
        if (attribute != null) {
            return attribute;
        }
        if (optional) {
            return attribute;
        }
        throw new InvalidClaimException("The claim " + userAttribute + " was not found.");
    }

    public List<String> getAttributeValues(String ldapAttribute) {
        List attributes = null;
        if (ldapAttribute != null && !ldapAttribute.isEmpty()) {
            for (CustomAttribute customAttribute : this.customAttributes) {
                if (!StringHelper.equalsIgnoreCase((String)ldapAttribute, (String)customAttribute.getName())) continue;
                attributes = customAttribute.getValues();
                break;
            }
        }
        return attributes;
    }
}

