/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.util;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.status.StatusLogger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.xdi.oxauth.model.crypto.OxAuthCryptoProvider;
import org.xdi.oxauth.model.crypto.OxElevenCryptoProvider;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.jwk.JSONWebKey;
import org.xdi.oxauth.model.jwk.JSONWebKeySet;
import org.xdi.oxauth.model.jwk.KeyType;
import org.xdi.oxauth.model.jwk.Use;
import org.xdi.oxauth.model.util.SecurityProviderUtility;
import org.xdi.oxauth.model.util.StringUtils;

public class KeyGenerator {
    private static final String SIGNING_KEYS = "sig_keys";
    private static final String ENCRYPTION_KEYS = "enc_keys";
    private static final String KEY_STORE_FILE = "keystore";
    private static final String KEY_STORE_PASSWORD = "keypasswd";
    private static final String DN_NAME = "dnname";
    private static final String OXELEVEN_ACCESS_TOKEN = "at";
    private static final String OXELEVEN_GENERATE_KEY_ENDPOINT = "ox11";
    private static final String EXPIRATION = "expiration";
    private static final String HELP = "h";
    private static final Logger log;

    public static void main(String[] args) throws Exception {
        new Cli(args).parse();
    }

    static {
        StatusLogger.getLogger().setLevel(Level.OFF);
        log = Logger.getLogger(KeyGenerator.class);
    }

    public static class Cli {
        private String[] args = null;
        private Options options = new Options();

        public Cli(String[] args) {
            this.args = args;
            Option signingKeysOption = new Option(KeyGenerator.SIGNING_KEYS, true, "Signature keys to generate. (RS256 RS384 RS512 ES256 ES384 ES512).");
            signingKeysOption.setArgs(-2);
            Option encryptionKeysOption = new Option(KeyGenerator.ENCRYPTION_KEYS, true, "Encryption keys to generate. (RS256 RS384 RS512 ES256 ES384 ES512).");
            encryptionKeysOption.setArgs(-2);
            this.options.addOption(signingKeysOption);
            this.options.addOption(encryptionKeysOption);
            this.options.addOption(KeyGenerator.KEY_STORE_FILE, true, "Key Store file.");
            this.options.addOption(KeyGenerator.KEY_STORE_PASSWORD, true, "Key Store password.");
            this.options.addOption(KeyGenerator.DN_NAME, true, "DN of certificate issuer.");
            this.options.addOption(KeyGenerator.OXELEVEN_ACCESS_TOKEN, true, "oxEleven Access Token");
            this.options.addOption(KeyGenerator.OXELEVEN_GENERATE_KEY_ENDPOINT, true, "oxEleven Generate Key Endpoint.");
            this.options.addOption(KeyGenerator.EXPIRATION, true, "Expiration in days.");
            this.options.addOption(KeyGenerator.HELP, false, "Show help.");
        }

        public void parse() {
            BasicParser parser = new BasicParser();
            CommandLine cmd = null;
            try {
                cmd = parser.parse(this.options, this.args);
                if (cmd.hasOption(KeyGenerator.HELP)) {
                    this.help();
                }
                if ((cmd.hasOption(KeyGenerator.SIGNING_KEYS) || cmd.hasOption(KeyGenerator.ENCRYPTION_KEYS)) && cmd.hasOption(KeyGenerator.OXELEVEN_ACCESS_TOKEN) && cmd.hasOption(KeyGenerator.OXELEVEN_GENERATE_KEY_ENDPOINT) && cmd.hasOption(KeyGenerator.EXPIRATION)) {
                    List encryptionAlgorithms;
                    String[] sigAlgorithms = cmd.getOptionValues(KeyGenerator.SIGNING_KEYS);
                    String[] encAlgorithms = cmd.getOptionValues(KeyGenerator.ENCRYPTION_KEYS);
                    String accessToken = cmd.getOptionValue(KeyGenerator.OXELEVEN_ACCESS_TOKEN);
                    String generateKeyEndpoint = cmd.getOptionValue(KeyGenerator.OXELEVEN_GENERATE_KEY_ENDPOINT);
                    int expiration = Integer.parseInt(cmd.getOptionValue(KeyGenerator.EXPIRATION));
                    List signatureAlgorithms = cmd.hasOption(KeyGenerator.SIGNING_KEYS) ? SignatureAlgorithm.fromString((String[])sigAlgorithms) : new ArrayList();
                    List list = encryptionAlgorithms = cmd.hasOption(KeyGenerator.ENCRYPTION_KEYS) ? SignatureAlgorithm.fromString((String[])encAlgorithms) : new ArrayList();
                    if (signatureAlgorithms.isEmpty() && encryptionAlgorithms.isEmpty()) {
                        this.help();
                    } else {
                        try {
                            JSONArray x5c;
                            JSONWebKey key;
                            JSONObject result;
                            JSONWebKeySet jwks = new JSONWebKeySet();
                            OxElevenCryptoProvider cryptoProvider = new OxElevenCryptoProvider(generateKeyEndpoint, null, null, null, accessToken);
                            GregorianCalendar calendar = new GregorianCalendar();
                            ((Calendar)calendar).add(5, expiration);
                            for (SignatureAlgorithm signatureAlgorithm : signatureAlgorithms) {
                                result = cryptoProvider.generateKey(signatureAlgorithm, Long.valueOf(calendar.getTimeInMillis()));
                                key = new JSONWebKey();
                                key.setKid(result.getString("kid"));
                                key.setUse(Use.SIGNATURE);
                                key.setAlg(signatureAlgorithm);
                                key.setKty(KeyType.fromString((String)signatureAlgorithm.getFamily().toString()));
                                key.setExp(Long.valueOf(result.optLong("exp")));
                                key.setCrv(signatureAlgorithm.getCurve());
                                key.setN(result.optString("n"));
                                key.setE(result.optString("e"));
                                key.setX(result.optString("x"));
                                key.setY(result.optString("y"));
                                x5c = result.optJSONArray("x5c");
                                key.setX5c(StringUtils.toList((JSONArray)x5c));
                                jwks.getKeys().add(key);
                            }
                            for (SignatureAlgorithm encryptionAlgorithm : encryptionAlgorithms) {
                                result = cryptoProvider.generateKey(encryptionAlgorithm, Long.valueOf(calendar.getTimeInMillis()));
                                key = new JSONWebKey();
                                key.setKid(result.getString("kid"));
                                key.setUse(Use.ENCRYPTION);
                                key.setAlg(encryptionAlgorithm);
                                key.setKty(KeyType.fromString((String)encryptionAlgorithm.getFamily().toString()));
                                key.setExp(Long.valueOf(result.optLong("exp")));
                                key.setCrv(encryptionAlgorithm.getCurve());
                                key.setN(result.optString("n"));
                                key.setE(result.optString("e"));
                                key.setX(result.optString("x"));
                                key.setY(result.optString("y"));
                                x5c = result.optJSONArray("x5c");
                                key.setX5c(StringUtils.toList((JSONArray)x5c));
                                jwks.getKeys().add(key);
                            }
                            System.out.println(jwks);
                        }
                        catch (Exception e) {
                            log.error((Object)"Failed to generate keys", (Throwable)e);
                            this.help();
                        }
                    }
                } else if ((cmd.hasOption(KeyGenerator.SIGNING_KEYS) || cmd.hasOption(KeyGenerator.ENCRYPTION_KEYS)) && cmd.hasOption(KeyGenerator.KEY_STORE_FILE) && cmd.hasOption(KeyGenerator.KEY_STORE_PASSWORD) && cmd.hasOption(KeyGenerator.DN_NAME) && cmd.hasOption(KeyGenerator.EXPIRATION)) {
                    List encryptionAlgorithms;
                    String[] sigAlgorithms = cmd.getOptionValues(KeyGenerator.SIGNING_KEYS);
                    String[] encAlgorithms = cmd.getOptionValues(KeyGenerator.ENCRYPTION_KEYS);
                    String keystore = cmd.getOptionValue(KeyGenerator.KEY_STORE_FILE);
                    String keypasswd = cmd.getOptionValue(KeyGenerator.KEY_STORE_PASSWORD);
                    String dnName = cmd.getOptionValue(KeyGenerator.DN_NAME);
                    int expiration = Integer.parseInt(cmd.getOptionValue(KeyGenerator.EXPIRATION));
                    List signatureAlgorithms = cmd.hasOption(KeyGenerator.SIGNING_KEYS) ? SignatureAlgorithm.fromString((String[])sigAlgorithms) : new ArrayList();
                    List list = encryptionAlgorithms = cmd.hasOption(KeyGenerator.ENCRYPTION_KEYS) ? SignatureAlgorithm.fromString((String[])encAlgorithms) : new ArrayList();
                    if (signatureAlgorithms.isEmpty() && encryptionAlgorithms.isEmpty()) {
                        this.help();
                    } else {
                        try {
                            JSONArray x5c;
                            JSONWebKey key;
                            JSONObject result;
                            SecurityProviderUtility.installBCProvider((boolean)true);
                            JSONWebKeySet jwks = new JSONWebKeySet();
                            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keystore, keypasswd, dnName);
                            GregorianCalendar calendar = new GregorianCalendar();
                            ((Calendar)calendar).add(5, expiration);
                            for (SignatureAlgorithm signatureAlgorithm : signatureAlgorithms) {
                                result = cryptoProvider.generateKey(signatureAlgorithm, Long.valueOf(calendar.getTimeInMillis()));
                                key = new JSONWebKey();
                                key.setKid(result.getString("kid"));
                                key.setUse(Use.SIGNATURE);
                                key.setAlg(signatureAlgorithm);
                                key.setKty(KeyType.fromString((String)signatureAlgorithm.getFamily().toString()));
                                key.setExp(Long.valueOf(result.optLong("exp")));
                                key.setCrv(signatureAlgorithm.getCurve());
                                key.setN(result.optString("n"));
                                key.setE(result.optString("e"));
                                key.setX(result.optString("x"));
                                key.setY(result.optString("y"));
                                x5c = result.optJSONArray("x5c");
                                key.setX5c(StringUtils.toList((JSONArray)x5c));
                                jwks.getKeys().add(key);
                            }
                            for (SignatureAlgorithm encryptionAlgorithm : encryptionAlgorithms) {
                                result = cryptoProvider.generateKey(encryptionAlgorithm, Long.valueOf(calendar.getTimeInMillis()));
                                key = new JSONWebKey();
                                key.setKid(result.getString("kid"));
                                key.setUse(Use.ENCRYPTION);
                                key.setAlg(encryptionAlgorithm);
                                key.setKty(KeyType.fromString((String)encryptionAlgorithm.getFamily().toString()));
                                key.setExp(Long.valueOf(result.optLong("exp")));
                                key.setCrv(encryptionAlgorithm.getCurve());
                                key.setN(result.optString("n"));
                                key.setE(result.optString("e"));
                                key.setX(result.optString("x"));
                                key.setY(result.optString("y"));
                                x5c = result.optJSONArray("x5c");
                                key.setX5c(StringUtils.toList((JSONArray)x5c));
                                jwks.getKeys().add(key);
                            }
                            System.out.println(jwks);
                        }
                        catch (Exception e) {
                            log.error((Object)"Failed to generate keys", (Throwable)e);
                            this.help();
                        }
                    }
                } else {
                    this.help();
                }
            }
            catch (ParseException e) {
                log.error((Object)"Failed to generate keys", (Throwable)e);
                this.help();
            }
        }

        private void help() {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("KeyGenerator -sig_keys alg ... -enc_keys alg ... -expiration n_days [-ox11 url] [-keystore path -keypasswd secret -dnname dn_name]", this.options);
            System.exit(0);
        }
    }
}

