/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client.model.authorize;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.model.authorize.Claim;
import org.xdi.oxauth.client.model.authorize.IdTokenMember;
import org.xdi.oxauth.client.model.authorize.UserInfoMember;
import org.xdi.oxauth.model.common.Display;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.crypto.AbstractCryptoProvider;
import org.xdi.oxauth.model.crypto.encryption.BlockEncryptionAlgorithm;
import org.xdi.oxauth.model.crypto.encryption.KeyEncryptionAlgorithm;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.exception.InvalidJwtException;
import org.xdi.oxauth.model.jwe.JweEncrypterImpl;
import org.xdi.oxauth.model.jwt.JwtHeader;
import org.xdi.oxauth.model.jwt.JwtType;
import org.xdi.oxauth.model.util.Base64Util;
import org.xdi.oxauth.model.util.Pair;

public class JwtAuthorizationRequest {
    private static final Logger LOG = Logger.getLogger(JwtAuthorizationRequest.class);
    private JwtType type;
    private SignatureAlgorithm signatureAlgorithm;
    private KeyEncryptionAlgorithm keyEncryptionAlgorithm;
    private BlockEncryptionAlgorithm blockEncryptionAlgorithm;
    private String keyId;
    private List<ResponseType> responseTypes;
    private String clientId;
    private List<String> scopes;
    private String redirectUri;
    private String state;
    private String nonce;
    private Display display;
    private List<Prompt> prompts;
    private Integer maxAge;
    private List<String> uiLocales;
    private List<String> claimsLocales;
    private String idTokenHint;
    private String loginHint;
    private List<String> acrValues;
    private String registration;
    private boolean requestUniqueId;
    private UserInfoMember userInfoMember;
    private IdTokenMember idTokenMember;
    private String sharedKey;
    private AbstractCryptoProvider cryptoProvider;

    public JwtAuthorizationRequest(AuthorizationRequest authorizationRequest, SignatureAlgorithm signatureAlgorithm, AbstractCryptoProvider cryptoProvider) {
        this(authorizationRequest, signatureAlgorithm, cryptoProvider, null, null, null);
    }

    public JwtAuthorizationRequest(AuthorizationRequest authorizationRequest, SignatureAlgorithm signatureAlgorithm, String sharedKey, AbstractCryptoProvider cryptoProvider) {
        this(authorizationRequest, signatureAlgorithm, cryptoProvider, null, null, sharedKey);
    }

    public JwtAuthorizationRequest(AuthorizationRequest authorizationRequest, KeyEncryptionAlgorithm keyEncryptionAlgorithm, BlockEncryptionAlgorithm blockEncryptionAlgorithm, AbstractCryptoProvider cryptoProvider) {
        this(authorizationRequest, null, cryptoProvider, keyEncryptionAlgorithm, blockEncryptionAlgorithm, null);
    }

    public JwtAuthorizationRequest(AuthorizationRequest authorizationRequest, KeyEncryptionAlgorithm keyEncryptionAlgorithm, BlockEncryptionAlgorithm blockEncryptionAlgorithm, String sharedKey) {
        this(authorizationRequest, null, null, keyEncryptionAlgorithm, blockEncryptionAlgorithm, sharedKey);
    }

    private JwtAuthorizationRequest(AuthorizationRequest authorizationRequest, SignatureAlgorithm signatureAlgorithm, AbstractCryptoProvider cryptoProvider, KeyEncryptionAlgorithm keyEncryptionAlgorithm, BlockEncryptionAlgorithm blockEncryptionAlgorithm, String sharedKey) {
        this.setAuthorizationRequestParams(authorizationRequest);
        this.type = JwtType.JWT;
        this.signatureAlgorithm = signatureAlgorithm;
        this.cryptoProvider = cryptoProvider;
        this.keyEncryptionAlgorithm = keyEncryptionAlgorithm;
        this.blockEncryptionAlgorithm = blockEncryptionAlgorithm;
        this.sharedKey = sharedKey;
        this.userInfoMember = new UserInfoMember();
        this.idTokenMember = new IdTokenMember();
    }

    private void setAuthorizationRequestParams(AuthorizationRequest authorizationRequest) {
        if (authorizationRequest != null) {
            this.responseTypes = authorizationRequest.getResponseTypes();
            this.clientId = authorizationRequest.getClientId();
            this.scopes = authorizationRequest.getScopes();
            this.redirectUri = authorizationRequest.getRedirectUri();
            this.state = authorizationRequest.getState();
            this.nonce = authorizationRequest.getNonce();
            this.display = authorizationRequest.getDisplay();
            this.prompts = authorizationRequest.getPrompts();
            this.maxAge = authorizationRequest.getMaxAge();
            this.uiLocales = authorizationRequest.getUiLocales();
            this.claimsLocales = authorizationRequest.getClaimsLocales();
            this.idTokenHint = authorizationRequest.getIdTokenHint();
            this.loginHint = authorizationRequest.getLoginHint();
            this.acrValues = authorizationRequest.getAcrValues();
            this.registration = authorizationRequest.getRegistration();
            this.requestUniqueId = authorizationRequest.isRequestSessionId();
        }
    }

    public JwtType getType() {
        return this.type;
    }

    public void setType(JwtType type) {
        this.type = type;
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void setAlgorithm(SignatureAlgorithm signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public KeyEncryptionAlgorithm getKeyEncryptionAlgorithm() {
        return this.keyEncryptionAlgorithm;
    }

    public void setKeyEncryptionAlgorithm(KeyEncryptionAlgorithm keyEncryptionAlgorithm) {
        this.keyEncryptionAlgorithm = keyEncryptionAlgorithm;
    }

    public BlockEncryptionAlgorithm getBlockEncryptionAlgorithm() {
        return this.blockEncryptionAlgorithm;
    }

    public void setBlockEncryptionAlgorithm(BlockEncryptionAlgorithm blockEncryptionAlgorithm) {
        this.blockEncryptionAlgorithm = blockEncryptionAlgorithm;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public boolean isRequestUniqueId() {
        return this.requestUniqueId;
    }

    public void setRequestUniqueId(boolean p_requestUniqueId) {
        this.requestUniqueId = p_requestUniqueId;
    }

    public List<ResponseType> getResponseTypes() {
        return this.responseTypes;
    }

    public void setResponseTypes(List<ResponseType> responseTypes) {
        this.responseTypes = responseTypes;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public Display getDisplay() {
        return this.display;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    public List<Prompt> getPrompts() {
        return this.prompts;
    }

    public void setPrompts(List<Prompt> prompts) {
        this.prompts = prompts;
    }

    public Integer getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
    }

    public List<String> getUiLocales() {
        return this.uiLocales;
    }

    public void setUiLocales(List<String> uiLocales) {
        this.uiLocales = uiLocales;
    }

    public List<String> getClaimsLocales() {
        return this.claimsLocales;
    }

    public void setClaimsLocales(List<String> claimsLocales) {
        this.claimsLocales = claimsLocales;
    }

    public String getIdTokenHint() {
        return this.idTokenHint;
    }

    public void setIdTokenHint(String idTokenHint) {
        this.idTokenHint = idTokenHint;
    }

    public String getLoginHint() {
        return this.loginHint;
    }

    public void setLoginHint(String loginHint) {
        this.loginHint = loginHint;
    }

    public List<String> getAcrValues() {
        return this.acrValues;
    }

    public void setAcrValues(List<String> acrValues) {
        this.acrValues = acrValues;
    }

    public String getRegistration() {
        return this.registration;
    }

    public void setRegistration(String registration) {
        this.registration = registration;
    }

    public UserInfoMember getUserInfoMember() {
        return this.userInfoMember;
    }

    public void setUserInfoMember(UserInfoMember userInfoMember) {
        this.userInfoMember = userInfoMember;
    }

    public IdTokenMember getIdTokenMember() {
        return this.idTokenMember;
    }

    public void setIdTokenMember(IdTokenMember idTokenMember) {
        this.idTokenMember = idTokenMember;
    }

    public void addUserInfoClaim(Claim claim) {
        this.userInfoMember.getClaims().add(claim);
    }

    public void addIdTokenClaim(Claim claim) {
        this.idTokenMember.getClaims().add(claim);
    }

    public String getEncodedJwt(JSONObject jwks) throws Exception {
        String encodedJwt = null;
        if (this.keyEncryptionAlgorithm != null && this.blockEncryptionAlgorithm != null) {
            JweEncrypterImpl jweEncrypter;
            if (this.cryptoProvider != null && jwks != null) {
                PublicKey publicKey = this.cryptoProvider.getPublicKey(this.keyId, jwks);
                jweEncrypter = new JweEncrypterImpl(this.keyEncryptionAlgorithm, this.blockEncryptionAlgorithm, publicKey);
            } else {
                jweEncrypter = new JweEncrypterImpl(this.keyEncryptionAlgorithm, this.blockEncryptionAlgorithm, this.sharedKey.getBytes("UTF-8"));
            }
            String header = this.headerToJSONObject().toString();
            String encodedHeader = Base64Util.base64urlencode((byte[])header.getBytes("UTF-8"));
            String claims = this.payloadToJSONObject().toString();
            String encodedClaims = Base64Util.base64urlencode((byte[])claims.getBytes("UTF-8"));
            byte[] contentMasterKey = new byte[this.blockEncryptionAlgorithm.getCmkLength() / 8];
            SecureRandom random = new SecureRandom();
            random.nextBytes(contentMasterKey);
            String encodedEncryptedKey = jweEncrypter.generateEncryptedKey(contentMasterKey);
            byte[] initializationVector = new byte[this.blockEncryptionAlgorithm.getInitVectorLength() / 8];
            random.nextBytes(initializationVector);
            String encodedInitializationVector = Base64Util.base64urlencode((byte[])initializationVector);
            String additionalAuthenticatedData = encodedHeader + "." + encodedEncryptedKey + "." + encodedInitializationVector;
            Pair result = jweEncrypter.generateCipherTextAndIntegrityValue(contentMasterKey, initializationVector, additionalAuthenticatedData.getBytes("UTF-8"), encodedClaims.getBytes("UTF-8"));
            String encodedCipherText = (String)result.getFirst();
            String encodedIntegrityValue = (String)result.getSecond();
            encodedJwt = encodedHeader + "." + encodedEncryptedKey + "." + encodedInitializationVector + "." + encodedCipherText + "." + encodedIntegrityValue;
        } else {
            if (this.cryptoProvider == null) {
                throw new Exception("The Crypto Provider cannot be null.");
            }
            JSONObject headerJsonObject = this.headerToJSONObject();
            JSONObject payloadJsonObject = this.payloadToJSONObject();
            String headerString = headerJsonObject.toString();
            String payloadString = payloadJsonObject.toString();
            String encodedHeader = Base64Util.base64urlencode((byte[])headerString.getBytes("UTF-8"));
            String encodedPayload = Base64Util.base64urlencode((byte[])payloadString.getBytes("UTF-8"));
            String signingInput = encodedHeader + "." + encodedPayload;
            String encodedSignature = this.cryptoProvider.sign(signingInput, this.keyId, this.sharedKey, this.signatureAlgorithm);
            encodedJwt = encodedHeader + "." + encodedPayload + "." + encodedSignature;
        }
        return encodedJwt;
    }

    public String getEncodedJwt() throws Exception {
        return this.getEncodedJwt(null);
    }

    public String getDecodedJwt() {
        String decodedJwt = null;
        try {
            decodedJwt = this.payloadToJSONObject().toString(4);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return decodedJwt;
    }

    protected JSONObject headerToJSONObject() throws InvalidJwtException {
        JwtHeader jwtHeader = new JwtHeader();
        jwtHeader.setType(this.type);
        if (this.keyEncryptionAlgorithm != null && this.blockEncryptionAlgorithm != null) {
            jwtHeader.setAlgorithm(this.keyEncryptionAlgorithm);
            jwtHeader.setEncryptionMethod(this.blockEncryptionAlgorithm);
        } else {
            jwtHeader.setAlgorithm(this.signatureAlgorithm);
        }
        jwtHeader.setKeyId(this.keyId);
        return jwtHeader.toJsonObject();
    }

    protected JSONObject payloadToJSONObject() throws JSONException {
        JSONObject obj = new JSONObject();
        try {
            if (this.responseTypes != null && !this.responseTypes.isEmpty()) {
                if (this.responseTypes.size() == 1) {
                    ResponseType responseType = this.responseTypes.get(0);
                    obj.put("response_type", (Object)responseType);
                } else {
                    JSONArray responseTypeJsonArray = new JSONArray();
                    for (ResponseType responseType : this.responseTypes) {
                        responseTypeJsonArray.put((Object)responseType);
                    }
                    obj.put("response_type", (Object)responseTypeJsonArray);
                }
            }
            if (StringUtils.isNotBlank((String)this.clientId)) {
                obj.put("client_id", (Object)this.clientId);
            }
            if (this.scopes != null && !this.scopes.isEmpty()) {
                if (this.scopes.size() == 1) {
                    String scope = this.scopes.get(0);
                    obj.put("scope", (Object)scope);
                } else {
                    JSONArray scopeJsonArray = new JSONArray();
                    for (String scope : this.scopes) {
                        scopeJsonArray.put((Object)scope);
                    }
                    obj.put("scope", (Object)scopeJsonArray);
                }
            }
            if (StringUtils.isNotBlank((String)this.redirectUri)) {
                obj.put("redirect_uri", (Object)URLEncoder.encode(this.redirectUri, "UTF-8"));
            }
            if (StringUtils.isNotBlank((String)this.state)) {
                obj.put("state", (Object)this.state);
            }
            if (StringUtils.isNotBlank((String)this.nonce)) {
                obj.put("nonce", (Object)this.nonce);
            }
            if (this.display != null) {
                obj.put("display", (Object)this.display);
            }
            if (this.prompts != null && !this.prompts.isEmpty()) {
                JSONArray promptJsonArray = new JSONArray();
                for (Prompt prompt : this.prompts) {
                    promptJsonArray.put((Object)prompt);
                }
                obj.put("prompt", (Object)promptJsonArray);
            }
            if (this.maxAge != null) {
                obj.put("max_age", (Object)this.maxAge);
            }
            if (this.uiLocales != null && !this.uiLocales.isEmpty()) {
                JSONArray uiLocalesJsonArray = new JSONArray(this.uiLocales);
                obj.put("ui_locales", (Object)uiLocalesJsonArray);
            }
            if (this.claimsLocales != null && !this.claimsLocales.isEmpty()) {
                JSONArray claimsLocalesJsonArray = new JSONArray(this.claimsLocales);
                obj.put("claims_locales", (Object)claimsLocalesJsonArray);
            }
            if (StringUtils.isNotBlank((String)this.idTokenHint)) {
                obj.put("id_token_hint", (Object)this.idTokenHint);
            }
            if (StringUtils.isNotBlank((String)this.loginHint)) {
                obj.put("login_hint", (Object)this.loginHint);
            }
            if (this.acrValues != null && !this.acrValues.isEmpty()) {
                JSONArray acrValuesJsonArray = new JSONArray(this.acrValues);
                obj.put("acr_values", this.acrValues);
            }
            if (StringUtils.isNotBlank((String)this.registration)) {
                obj.put("registration", (Object)this.registration);
            }
            if (this.userInfoMember != null || this.idTokenMember != null) {
                JSONObject claimsObj = new JSONObject();
                if (this.userInfoMember != null) {
                    claimsObj.put("userinfo", (Object)this.userInfoMember.toJSONObject());
                }
                if (this.idTokenMember != null) {
                    claimsObj.put("id_token", (Object)this.idTokenMember.toJSONObject());
                }
                obj.put("claims", (Object)claimsObj);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return obj;
    }
}

