/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client.model;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.PublicKey;
import java.security.SecureRandom;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.xdi.oxauth.model.crypto.AbstractCryptoProvider;
import org.xdi.oxauth.model.crypto.encryption.BlockEncryptionAlgorithm;
import org.xdi.oxauth.model.crypto.encryption.KeyEncryptionAlgorithm;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.exception.InvalidJwtException;
import org.xdi.oxauth.model.jwe.JweEncrypterImpl;
import org.xdi.oxauth.model.jwt.JwtHeader;
import org.xdi.oxauth.model.jwt.JwtType;
import org.xdi.oxauth.model.util.Base64Util;
import org.xdi.oxauth.model.util.Pair;

public class JwtState {
    private static final Logger LOG = Logger.getLogger(JwtState.class);
    private JwtType type = JwtType.JWT;
    private SignatureAlgorithm signatureAlgorithm;
    private KeyEncryptionAlgorithm keyEncryptionAlgorithm;
    private BlockEncryptionAlgorithm blockEncryptionAlgorithm;
    private String keyId;
    private String rfp;
    private String iat;
    private String exp;
    private String iss;
    private String aud;
    private String targetLinkUri;
    private String as;
    private String jti;
    private String atHash;
    private String cHash;
    private JSONObject additionalClaims;
    private String sharedKey;
    private AbstractCryptoProvider cryptoProvider;

    public JwtState(SignatureAlgorithm signatureAlgorithm, AbstractCryptoProvider cryptoProvider) {
        this(signatureAlgorithm, cryptoProvider, null, null, null);
    }

    public JwtState(SignatureAlgorithm signatureAlgorithm, String sharedKey, AbstractCryptoProvider cryptoProvider) {
        this(signatureAlgorithm, cryptoProvider, null, null, sharedKey);
    }

    public JwtState(KeyEncryptionAlgorithm keyEncryptionAlgorithm, BlockEncryptionAlgorithm blockEncryptionAlgorithm, AbstractCryptoProvider cryptoProvider) {
        this(null, cryptoProvider, keyEncryptionAlgorithm, blockEncryptionAlgorithm, null);
    }

    public JwtState(KeyEncryptionAlgorithm keyEncryptionAlgorithm, BlockEncryptionAlgorithm blockEncryptionAlgorithm, String sharedKey) {
        this(null, null, keyEncryptionAlgorithm, blockEncryptionAlgorithm, sharedKey);
    }

    private JwtState(SignatureAlgorithm signatureAlgorithm, AbstractCryptoProvider cryptoProvider, KeyEncryptionAlgorithm keyEncryptionAlgorithm, BlockEncryptionAlgorithm blockEncryptionAlgorithm, String sharedKey) {
        this.signatureAlgorithm = signatureAlgorithm;
        this.cryptoProvider = cryptoProvider;
        this.keyEncryptionAlgorithm = keyEncryptionAlgorithm;
        this.blockEncryptionAlgorithm = blockEncryptionAlgorithm;
        this.sharedKey = sharedKey;
    }

    public JwtType getType() {
        return this.type;
    }

    public void setType(JwtType type) {
        this.type = type;
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void setSignatureAlgorithm(SignatureAlgorithm signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public KeyEncryptionAlgorithm getKeyEncryptionAlgorithm() {
        return this.keyEncryptionAlgorithm;
    }

    public void setKeyEncryptionAlgorithm(KeyEncryptionAlgorithm keyEncryptionAlgorithm) {
        this.keyEncryptionAlgorithm = keyEncryptionAlgorithm;
    }

    public BlockEncryptionAlgorithm getBlockEncryptionAlgorithm() {
        return this.blockEncryptionAlgorithm;
    }

    public void setBlockEncryptionAlgorithm(BlockEncryptionAlgorithm blockEncryptionAlgorithm) {
        this.blockEncryptionAlgorithm = blockEncryptionAlgorithm;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public String getRfp() {
        return this.rfp;
    }

    public void setRfp(String rfp) {
        this.rfp = rfp;
    }

    public String getIat() {
        return this.iat;
    }

    public void setIat(String iat) {
        this.iat = iat;
    }

    public String getExp() {
        return this.exp;
    }

    public void setExp(String exp) {
        this.exp = exp;
    }

    public String getIss() {
        return this.iss;
    }

    public void setIss(String iss) {
        this.iss = iss;
    }

    public String getAud() {
        return this.aud;
    }

    public void setAud(String aud) {
        this.aud = aud;
    }

    public String getTargetLinkUri() {
        return this.targetLinkUri;
    }

    public void setTargetLinkUri(String targetLinkUri) {
        this.targetLinkUri = targetLinkUri;
    }

    public String getAs() {
        return this.as;
    }

    public void setAs(String as) {
        this.as = as;
    }

    public String getJti() {
        return this.jti;
    }

    public void setJti(String jti) {
        this.jti = jti;
    }

    public String getAtHash() {
        return this.atHash;
    }

    public void setAtHash(String atHash) {
        this.atHash = atHash;
    }

    public String getcHash() {
        return this.cHash;
    }

    public void setcHash(String cHash) {
        this.cHash = cHash;
    }

    public JSONObject getAdditionalClaims() {
        return this.additionalClaims;
    }

    public void setAdditionalClaims(JSONObject additionalClaims) {
        this.additionalClaims = additionalClaims;
    }

    public String getEncodedJwt(JSONObject jwks) throws Exception {
        String encodedJwt = null;
        if (this.keyEncryptionAlgorithm != null && this.blockEncryptionAlgorithm != null) {
            JweEncrypterImpl jweEncrypter;
            if (this.cryptoProvider != null && jwks != null) {
                PublicKey publicKey = this.cryptoProvider.getPublicKey(this.keyId, jwks);
                jweEncrypter = new JweEncrypterImpl(this.keyEncryptionAlgorithm, this.blockEncryptionAlgorithm, publicKey);
            } else {
                jweEncrypter = new JweEncrypterImpl(this.keyEncryptionAlgorithm, this.blockEncryptionAlgorithm, this.sharedKey.getBytes("UTF-8"));
            }
            String header = this.headerToJSONObject().toString();
            String encodedHeader = Base64Util.base64urlencode((byte[])header.getBytes("UTF-8"));
            String claims = this.payloadToJSONObject().toString();
            String encodedClaims = Base64Util.base64urlencode((byte[])claims.getBytes("UTF-8"));
            byte[] contentMasterKey = new byte[this.blockEncryptionAlgorithm.getCmkLength() / 8];
            SecureRandom random = new SecureRandom();
            random.nextBytes(contentMasterKey);
            String encodedEncryptedKey = jweEncrypter.generateEncryptedKey(contentMasterKey);
            byte[] initializationVector = new byte[this.blockEncryptionAlgorithm.getInitVectorLength() / 8];
            random.nextBytes(initializationVector);
            String encodedInitializationVector = Base64Util.base64urlencode((byte[])initializationVector);
            String additionalAuthenticatedData = encodedHeader + "." + encodedEncryptedKey + "." + encodedInitializationVector;
            Pair result = jweEncrypter.generateCipherTextAndIntegrityValue(contentMasterKey, initializationVector, additionalAuthenticatedData.getBytes("UTF-8"), encodedClaims.getBytes("UTF-8"));
            String encodedCipherText = (String)result.getFirst();
            String encodedIntegrityValue = (String)result.getSecond();
            encodedJwt = encodedHeader + "." + encodedEncryptedKey + "." + encodedInitializationVector + "." + encodedCipherText + "." + encodedIntegrityValue;
        } else {
            if (this.cryptoProvider == null) {
                throw new Exception("The Crypto Provider cannot be null.");
            }
            JSONObject headerJsonObject = this.headerToJSONObject();
            JSONObject payloadJsonObject = this.payloadToJSONObject();
            String headerString = headerJsonObject.toString();
            String payloadString = payloadJsonObject.toString();
            String encodedHeader = Base64Util.base64urlencode((byte[])headerString.getBytes("UTF-8"));
            String encodedPayload = Base64Util.base64urlencode((byte[])payloadString.getBytes("UTF-8"));
            String signingInput = encodedHeader + "." + encodedPayload;
            String encodedSignature = this.cryptoProvider.sign(signingInput, this.keyId, this.sharedKey, this.signatureAlgorithm);
            encodedJwt = encodedHeader + "." + encodedPayload + "." + encodedSignature;
        }
        return encodedJwt;
    }

    public String getEncodedJwt() throws Exception {
        return this.getEncodedJwt(null);
    }

    protected JSONObject headerToJSONObject() throws InvalidJwtException {
        JwtHeader jwtHeader = new JwtHeader();
        jwtHeader.setType(this.type);
        if (this.keyEncryptionAlgorithm != null && this.blockEncryptionAlgorithm != null) {
            jwtHeader.setAlgorithm(this.keyEncryptionAlgorithm);
            jwtHeader.setEncryptionMethod(this.blockEncryptionAlgorithm);
        } else {
            jwtHeader.setAlgorithm(this.signatureAlgorithm);
        }
        jwtHeader.setKeyId(this.keyId);
        return jwtHeader.toJsonObject();
    }

    protected JSONObject payloadToJSONObject() throws JSONException {
        JSONObject obj = new JSONObject();
        try {
            if (StringUtils.isNotBlank((String)this.rfp)) {
                obj.put("rfp", (Object)this.rfp);
            }
            if (StringUtils.isNotBlank((String)this.keyId)) {
                obj.put("kid", (Object)this.keyId);
            }
            if (StringUtils.isNotBlank((String)this.iat)) {
                obj.put("iat", (Object)this.iat);
            }
            if (StringUtils.isNotBlank((String)this.exp)) {
                obj.put("exp", (Object)this.exp);
            }
            if (StringUtils.isNotBlank((String)this.iss)) {
                obj.put("iss", (Object)this.iss);
            }
            if (StringUtils.isNotBlank((String)this.aud)) {
                obj.put("aud", (Object)this.aud);
            }
            if (StringUtils.isNotBlank((String)this.targetLinkUri)) {
                obj.put("target_link_uri", (Object)URLEncoder.encode(this.targetLinkUri, "UTF-8"));
            }
            if (StringUtils.isNotBlank((String)this.as)) {
                obj.put("as", (Object)this.as);
            }
            if (StringUtils.isNotBlank((String)this.jti)) {
                obj.put("jti", (Object)this.jti);
            }
            if (StringUtils.isNotBlank((String)this.atHash)) {
                obj.put("at_hash", (Object)this.atHash);
            }
            if (StringUtils.isNotBlank((String)this.cHash)) {
                obj.put("c_hash", (Object)this.cHash);
            }
            if (this.additionalClaims != null) {
                obj.put("additional_claims", (Object)this.additionalClaims);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return obj;
    }
}

