/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs.uma;

import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.ClientResponseFailure;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.uma.UmaClientFactory;
import org.xdi.oxauth.client.uma.UmaPermissionService;
import org.xdi.oxauth.model.uma.PermissionTicket;
import org.xdi.oxauth.model.uma.UmaMetadata;
import org.xdi.oxauth.model.uma.UmaPermission;
import org.xdi.oxauth.model.uma.UmaPermissionList;
import org.xdi.oxauth.model.uma.UmaTestUtil;
import org.xdi.oxauth.ws.rs.uma.RegisterResourceFlowHttpTest;

public class UmaRegisterPermissionFlowHttpTest
extends BaseTest {
    protected UmaMetadata metadata;
    protected RegisterResourceFlowHttpTest registerResourceTest;
    protected String ticket;
    protected UmaPermissionService permissionService;

    public UmaRegisterPermissionFlowHttpTest() {
    }

    public UmaRegisterPermissionFlowHttpTest(UmaMetadata metadataConfiguration) {
        this.metadata = metadataConfiguration;
    }

    @BeforeClass
    @Parameters(value={"umaMetaDataUrl", "umaPatClientId", "umaPatClientSecret"})
    public void init(String umaMetaDataUrl, String umaPatClientId, String umaPatClientSecret) throws Exception {
        if (this.metadata == null) {
            this.metadata = UmaClientFactory.instance().createMetadataService(umaMetaDataUrl, UmaRegisterPermissionFlowHttpTest.clientExecutor(true)).getMetadata();
            UmaTestUtil.assert_((UmaMetadata)this.metadata);
        }
        this.registerResourceTest = new RegisterResourceFlowHttpTest(this.metadata);
        this.registerResourceTest.setAuthorizationEndpoint(this.authorizationEndpoint);
        this.registerResourceTest.setTokenEndpoint(this.tokenEndpoint);
        this.registerResourceTest.init(umaMetaDataUrl, umaPatClientId, umaPatClientSecret);
        this.registerResourceTest.addResource();
    }

    @AfterClass
    public void clean() throws Exception {
        this.registerResourceTest.deleteResource();
    }

    public UmaPermissionService getPermissionService() throws Exception {
        if (this.permissionService == null) {
            this.permissionService = UmaClientFactory.instance().createPermissionService(this.metadata, UmaRegisterPermissionFlowHttpTest.clientExecutor(true));
        }
        return this.permissionService;
    }

    @Test
    public void testRegisterPermission() throws Exception {
        this.showTitle("testRegisterPermission");
        this.registerResourcePermission(this.registerResourceTest.resourceId, Arrays.asList("http://photoz.example.com/dev/scopes/view"));
    }

    public String registerResourcePermission(String resourceId, List<String> scopes) throws Exception {
        UmaPermission permission = new UmaPermission();
        permission.setResourceId(resourceId);
        permission.setScopes(scopes);
        PermissionTicket ticket = this.getPermissionService().registerPermission("Bearer " + this.registerResourceTest.pat.getAccessToken(), UmaPermissionList.instance((UmaPermission[])new UmaPermission[]{permission}));
        UmaTestUtil.assert_((PermissionTicket)ticket);
        this.ticket = ticket.getTicket();
        return ticket.getTicket();
    }

    @Test
    public void testRegisterPermissionForInvalidResource() throws Exception {
        this.showTitle("testRegisterPermissionForInvalidResource");
        UmaPermission permission = new UmaPermission();
        permission.setResourceId(this.registerResourceTest.resourceId + "1");
        permission.setScopes(Arrays.asList("http://photoz.example.com/dev/scopes/view", "http://photoz.example.com/dev/scopes/all"));
        PermissionTicket ticket = null;
        try {
            ticket = this.getPermissionService().registerPermission("Bearer " + this.registerResourceTest.pat.getAccessToken(), UmaPermissionList.instance((UmaPermission[])new UmaPermission[]{permission}));
        }
        catch (ClientResponseFailure ex) {
            System.err.println(ex.getResponse().getEntity(String.class));
            Assert.assertTrue((ex.getResponse().getStatus() != Response.Status.CREATED.getStatusCode() && ex.getResponse().getStatus() != Response.Status.OK.getStatusCode() ? 1 : 0) != 0, (String)"Unexpected response status");
        }
        Assert.assertNull(ticket, (String)"Resource permission is not null");
    }
}

