/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs.uma;

import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientResponseFailure;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.uma.UmaClientFactory;
import org.xdi.oxauth.client.uma.UmaResourceService;
import org.xdi.oxauth.client.uma.wrapper.UmaClient;
import org.xdi.oxauth.model.uma.UmaMetadata;
import org.xdi.oxauth.model.uma.UmaResource;
import org.xdi.oxauth.model.uma.UmaResourceResponse;
import org.xdi.oxauth.model.uma.UmaResourceWithId;
import org.xdi.oxauth.model.uma.UmaTestUtil;
import org.xdi.oxauth.model.uma.wrapper.Token;

public class RegisterResourceFlowHttpTest
extends BaseTest {
    private static final String START_SCOPE_EXPRESSION = "{\"rule\": {\"and\": [{\"or\": [{\"var\": 0},{\"var\": 1}]},{\"var\": 2}]},  \"data\": [\"http://photoz.example.com/dev/actions/all\",\"http://photoz.example.com/dev/actions/add\",\"http://photoz.example.com/dev/actions/internalClient\"]}";
    private static final String MODIFY_SCOPE_EXPRESSION = "{\"rule\": {\"or\": [{\"or\": [{\"var\": 0},{\"var\": 1}]},{\"var\": 2}]},  \"data\": [\"http://photoz.example.com/dev/actions/all\",\"http://photoz.example.com/dev/actions/add\",\"http://photoz.example.com/dev/actions/internalClient\"]}";
    protected UmaMetadata metadata;
    protected Token pat;
    protected String resourceId;
    protected String resourceIdWithScopeExpression;
    protected UmaResourceService resourceService;

    public RegisterResourceFlowHttpTest() {
    }

    public RegisterResourceFlowHttpTest(UmaMetadata metadataConfiguration) {
        this.metadata = metadataConfiguration;
    }

    @BeforeClass
    @Parameters(value={"umaMetaDataUrl", "umaPatClientId", "umaPatClientSecret"})
    public void init(String umaMetaDataUrl, String umaPatClientId, String umaPatClientSecret) throws Exception {
        if (this.metadata == null) {
            this.metadata = UmaClientFactory.instance().createMetadataService(umaMetaDataUrl, RegisterResourceFlowHttpTest.clientExecutor(true)).getMetadata();
            UmaTestUtil.assert_((UmaMetadata)this.metadata);
        }
        this.pat = UmaClient.requestPat((String)this.tokenEndpoint, (String)umaPatClientId, (String)umaPatClientSecret, (ClientExecutor)RegisterResourceFlowHttpTest.clientExecutor(true), (String[])new String[0]);
        UmaTestUtil.assert_((Token)this.pat);
    }

    public UmaResourceService getResourceService() throws Exception {
        if (this.resourceService == null) {
            this.resourceService = UmaClientFactory.instance().createResourceService(this.metadata, RegisterResourceFlowHttpTest.clientExecutor(true));
        }
        return this.resourceService;
    }

    @Test
    public void addResource() throws Exception {
        this.showTitle("addResource");
        this.registerResource(Arrays.asList("http://photoz.example.com/dev/scopes/view", "http://photoz.example.com/dev/scopes/all"));
        this.registerResourceWithScopeExpression(START_SCOPE_EXPRESSION);
    }

    public String registerResource(List<String> scopes) throws Exception {
        try {
            UmaResource resource = new UmaResource();
            resource.setName("Photo Album");
            resource.setIconUri("http://www.example.com/icons/flower.png");
            resource.setScopes(scopes);
            resource.setType("myType");
            UmaResourceResponse resourceStatus = this.getResourceService().addResource("Bearer " + this.pat.getAccessToken(), resource);
            UmaTestUtil.assert_((UmaResourceResponse)resourceStatus);
            this.resourceId = resourceStatus.getId();
            return this.resourceId;
        }
        catch (ClientResponseFailure ex) {
            System.err.println(ex.getResponse().getEntity(String.class));
            throw ex;
        }
    }

    public String registerResourceWithScopeExpression(String scopeExpression) throws Exception {
        try {
            UmaResource resource = new UmaResource();
            resource.setName("Photo Album");
            resource.setIconUri("http://www.example.com/icons/flower.png");
            resource.setScopeExpression(scopeExpression);
            resource.setType("myType");
            UmaResourceResponse resourceStatus = this.getResourceService().addResource("Bearer " + this.pat.getAccessToken(), resource);
            UmaTestUtil.assert_((UmaResourceResponse)resourceStatus);
            this.resourceIdWithScopeExpression = resourceStatus.getId();
            return this.resourceIdWithScopeExpression;
        }
        catch (ClientResponseFailure ex) {
            System.err.println(ex.getResponse().getEntity(String.class));
            throw ex;
        }
    }

    @Test(dependsOnMethods={"addResource"})
    public void modifyResource() throws Exception {
        UmaResource resource;
        this.showTitle("modifyResource");
        UmaResourceResponse resourceStatus = null;
        try {
            resource = new UmaResource();
            resource.setName("Photo Album 2");
            resource.setIconUri("http://www.example.com/icons/flower.png");
            resource.setScopes(Arrays.asList("http://photoz.example.com/dev/scopes/view", "http://photoz.example.com/dev/scopes/all"));
            resource.setType("myType");
            resourceStatus = this.getResourceService().updateResource("Bearer " + this.pat.getAccessToken(), this.resourceId, resource);
        }
        catch (ClientResponseFailure ex) {
            System.err.println(ex.getResponse().getEntity(String.class));
            throw ex;
        }
        try {
            resource = new UmaResource();
            resource.setName("Photo Album 2");
            resource.setIconUri("http://www.example.com/icons/flower.png");
            resource.setScopeExpression(MODIFY_SCOPE_EXPRESSION);
            resource.setType("myType");
            resourceStatus = this.getResourceService().updateResource("Bearer " + this.pat.getAccessToken(), this.resourceIdWithScopeExpression, resource);
        }
        catch (ClientResponseFailure ex) {
            System.err.println(ex.getResponse().getEntity(String.class));
            throw ex;
        }
        Assert.assertNotNull((Object)resourceStatus, (String)"Resource status is null");
        Assert.assertNotNull((Object)this.resourceId, (String)"Resource description id is null");
    }

    @Test(dependsOnMethods={"modifyResource"})
    public void modifyNotExistingResource() throws Exception {
        this.showTitle("modifyNotExistingResource");
        try {
            UmaResource resource = new UmaResource();
            resource.setName("Photo Album 3");
            resource.setIconUri("http://www.example.com/icons/flower.png");
            resource.setScopes(Arrays.asList("http://photoz.example.com/dev/scopes/view", "http://photoz.example.com/dev/scopes/all"));
            this.getResourceService().updateResource("Bearer " + this.pat.getAccessToken(), "fake_resource_id", resource);
        }
        catch (ClientResponseFailure ex) {
            System.err.println(ex.getResponse().getEntity(String.class));
            int status = ex.getResponse().getStatus();
            Assert.assertTrue((status != Response.Status.OK.getStatusCode() ? 1 : 0) != 0, (String)"Unexpected response status");
        }
    }

    @Test(dependsOnMethods={"modifyResource"})
    public void testModifyResourceWithInvalidPat() throws Exception {
        this.showTitle("testModifyResourceWithInvalidPat");
        UmaResourceResponse resourceStatus = null;
        try {
            UmaResource resource = new UmaResource();
            resource.setName("Photo Album 4");
            resource.setIconUri("http://www.example.com/icons/flower.png");
            resource.setScopes(Arrays.asList("http://photoz.example.com/dev/scopes/view", "http://photoz.example.com/dev/scopes/all"));
            resourceStatus = this.getResourceService().updateResource("Bearer " + this.pat.getAccessToken() + "_invalid", this.resourceId + "_invalid", resource);
        }
        catch (ClientResponseFailure ex) {
            System.err.println(ex.getResponse().getEntity(String.class));
            Assert.assertEquals((int)ex.getResponse().getStatus(), (int)Response.Status.UNAUTHORIZED.getStatusCode(), (String)"Unexpected response status");
        }
        Assert.assertNull(resourceStatus, (String)"Resource status is not null");
    }

    @Test(dependsOnMethods={"modifyResource"})
    public void getOneResource() throws Exception {
        this.showTitle("getOneResource");
        try {
            UmaResourceWithId resource = this.getResourceService().getResource("Bearer " + this.pat.getAccessToken(), this.resourceId);
            Assert.assertEquals((String)resource.getType(), (String)"myType");
            UmaResourceWithId resourceWithExpression = this.getResourceService().getResource("Bearer " + this.pat.getAccessToken(), this.resourceIdWithScopeExpression);
            Assert.assertEquals((String)resourceWithExpression.getScopeExpression(), (String)MODIFY_SCOPE_EXPRESSION);
        }
        catch (ClientResponseFailure ex) {
            System.err.println(ex.getResponse().getEntity(String.class));
            throw ex;
        }
    }

    @Test(dependsOnMethods={"getOneResource"})
    public void getResources() throws Exception {
        this.showTitle("getResources");
        List resources = null;
        try {
            resources = this.getResourceService().getResourceList("Bearer " + this.pat.getAccessToken(), "");
        }
        catch (ClientResponseFailure ex) {
            System.err.println(ex.getResponse().getEntity(String.class));
            throw ex;
        }
        Assert.assertNotNull((Object)resources, (String)"Resources is null");
        Assert.assertTrue((boolean)resources.contains(this.resourceId), (String)"Resource list doesn't contain added resource");
    }

    @Test(dependsOnMethods={"getResources"})
    public void deleteResource() throws Exception {
        this.showTitle("testDeleteResource");
        try {
            this.getResourceService().deleteResource("Bearer " + this.pat.getAccessToken(), this.resourceId);
        }
        catch (ClientResponseFailure ex) {
            System.err.println(ex.getResponse().getEntity(String.class));
            throw ex;
        }
    }
}

