/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs.uma;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientResponseFailure;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.AuthorizeClient;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.BaseRequest;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.client.TokenClient;
import org.xdi.oxauth.client.TokenRequest;
import org.xdi.oxauth.client.TokenResponse;
import org.xdi.oxauth.client.uma.UmaClientFactory;
import org.xdi.oxauth.client.uma.UmaRptIntrospectionService;
import org.xdi.oxauth.client.uma.UmaTokenService;
import org.xdi.oxauth.client.uma.wrapper.UmaClient;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.jwt.Jwt;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.uma.UmaMetadata;
import org.xdi.oxauth.model.uma.UmaNeedInfoResponse;
import org.xdi.oxauth.model.uma.UmaTestUtil;
import org.xdi.oxauth.model.uma.wrapper.Token;
import org.xdi.oxauth.model.util.Util;
import org.xdi.oxauth.ws.rs.uma.RegisterResourceFlowHttpTest;
import org.xdi.oxauth.ws.rs.uma.UmaRegisterPermissionFlowHttpTest;

public class ClientAuthenticationByAccessTokenHttpTest
extends BaseTest {
    public static final String REDIRECT_URI = "https://client.example.com/cb3";
    protected UmaMetadata metadata;
    protected RegisterResourceFlowHttpTest registerResourceTest;
    protected UmaRegisterPermissionFlowHttpTest permissionFlowTest;
    protected UmaRptIntrospectionService rptStatusService;
    protected UmaTokenService tokenService;
    protected Token pat;
    protected UmaNeedInfoResponse needInfo;
    protected String clientId;
    protected String clientSecret;
    protected String userAccessToken;

    @BeforeClass
    @Parameters(value={"umaMetaDataUrl", "umaPatClientId", "umaPatClientSecret"})
    public void init(String umaMetaDataUrl, String umaPatClientId, String umaPatClientSecret) throws Exception {
        this.metadata = UmaClientFactory.instance().createMetadataService(umaMetaDataUrl, ClientAuthenticationByAccessTokenHttpTest.clientExecutor(true)).getMetadata();
        UmaTestUtil.assert_((UmaMetadata)this.metadata);
        this.pat = UmaClient.requestPat((String)this.tokenEndpoint, (String)umaPatClientId, (String)umaPatClientSecret, (ClientExecutor)ClientAuthenticationByAccessTokenHttpTest.clientExecutor(true), (String[])new String[0]);
        UmaTestUtil.assert_((Token)this.pat);
        this.registerResourceTest = new RegisterResourceFlowHttpTest(this.metadata);
        this.registerResourceTest.pat = this.pat;
        this.permissionFlowTest = new UmaRegisterPermissionFlowHttpTest(this.metadata);
        this.permissionFlowTest.registerResourceTest = this.registerResourceTest;
        this.rptStatusService = UmaClientFactory.instance().createRptStatusService(this.metadata, ClientAuthenticationByAccessTokenHttpTest.clientExecutor(true));
        this.tokenService = UmaClientFactory.instance().createTokenService(this.metadata, ClientAuthenticationByAccessTokenHttpTest.clientExecutor(true));
    }

    @Test
    public void requestClientRegistrationWithCustomAttributes() throws Exception {
        this.showTitle("requestClientRegistrationWithCustomAttributes");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE, ResponseType.TOKEN, ResponseType.ID_TOKEN);
        List<GrantType> grantTypes = Arrays.asList(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", Collections.singletonList(REDIRECT_URI));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setGrantTypes(grantTypes);
        registerRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setExecutor(ClientAuthenticationByAccessTokenHttpTest.clientExecutor(true));
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse response = registerClient.exec();
        ClientAuthenticationByAccessTokenHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getClientId());
        Assert.assertNotNull((Object)response.getClientSecret());
        Assert.assertNotNull((Object)response.getRegistrationAccessToken());
        Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
        this.clientId = response.getClientId();
        this.clientSecret = response.getClientSecret();
    }

    @Parameters(value={"userId", "userSecret"})
    @Test(dependsOnMethods={"requestClientRegistrationWithCustomAttributes"})
    public void requestAccessTokenCustomClientAuth1(String userId, String userSecret) throws Exception {
        this.showTitle("requestAccessTokenCustomClientAuth1");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        String nonce = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, this.clientId, scopes, REDIRECT_URI, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setExecutor(ClientAuthenticationByAccessTokenHttpTest.clientExecutor(true));
        authorizeClient.setRequest((BaseRequest)authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        ClientAuthenticationByAccessTokenHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The code is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        String authorizationCode = authorizationResponse.getCode();
        String idToken = authorizationResponse.getIdToken();
        Jwt jwt = Jwt.parse((String)idToken);
        Assert.assertNotNull((Object)jwt.getHeader().getClaimAsString("typ"));
        Assert.assertNotNull((Object)jwt.getHeader().getClaimAsString("alg"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("iss"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("aud"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("exp"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("iat"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("sub"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("c_hash"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("auth_time"));
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(REDIRECT_URI);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        tokenRequest.setAuthUsername(this.clientId);
        tokenRequest.setAuthPassword(this.clientSecret);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setExecutor(ClientAuthenticationByAccessTokenHttpTest.clientExecutor(true));
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        ClientAuthenticationByAccessTokenHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)tokenResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken(), (String)"The refresh token is null");
        this.userAccessToken = tokenResponse.getAccessToken();
    }

    @Test(dependsOnMethods={"requestAccessTokenCustomClientAuth1"})
    public void registerResource() throws Exception {
        this.showTitle("registerResource");
        this.registerResourceTest.addResource();
    }

    @Test(dependsOnMethods={"registerResource"})
    public void rsRegisterPermissions() throws Exception {
        this.showTitle("rsRegisterPermissions");
        this.permissionFlowTest.testRegisterPermission();
    }

    @Test(dependsOnMethods={"rsRegisterPermissions"})
    public void requestRptAndGetNeedsInfo() throws Exception {
        this.showTitle("requestRptAndGetNeedsInfo");
        try {
            this.tokenService.requestRpt("AccessToken " + this.userAccessToken, GrantType.OXAUTH_UMA_TICKET.getValue(), this.permissionFlowTest.ticket, null, null, null, null, null);
        }
        catch (ClientResponseFailure ex) {
            String entity = (String)ex.getResponse().getEntity(String.class);
            System.out.println(entity);
            Assert.assertEquals((int)ex.getResponse().getStatus(), (int)Response.Status.FORBIDDEN.getStatusCode(), (String)"Unexpected response status");
            this.needInfo = (UmaNeedInfoResponse)Util.createJsonMapper().readValue(entity, UmaNeedInfoResponse.class);
            UmaTestUtil.assert_((UmaNeedInfoResponse)this.needInfo);
            return;
        }
        throw new AssertionError((Object)"need_info error was not returned");
    }
}

