/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs.uma;

import java.io.UnsupportedEncodingException;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientResponseFailure;
import org.openqa.selenium.By;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.uma.UmaClientFactory;
import org.xdi.oxauth.client.uma.UmaRptIntrospectionService;
import org.xdi.oxauth.client.uma.UmaTokenService;
import org.xdi.oxauth.client.uma.wrapper.UmaClient;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.uma.RptIntrospectionResponse;
import org.xdi.oxauth.model.uma.UmaMetadata;
import org.xdi.oxauth.model.uma.UmaNeedInfoResponse;
import org.xdi.oxauth.model.uma.UmaTestUtil;
import org.xdi.oxauth.model.uma.UmaTokenResponse;
import org.xdi.oxauth.model.uma.wrapper.Token;
import org.xdi.oxauth.model.util.Util;
import org.xdi.oxauth.ws.rs.uma.RegisterResourceFlowHttpTest;
import org.xdi.oxauth.ws.rs.uma.UmaRegisterPermissionFlowHttpTest;

public class AccessProtectedResourceFlowHttpTest
extends BaseTest {
    protected UmaMetadata metadata;
    protected RegisterResourceFlowHttpTest registerResourceTest;
    protected UmaRegisterPermissionFlowHttpTest permissionFlowTest;
    protected UmaRptIntrospectionService rptStatusService;
    protected UmaTokenService tokenService;
    protected Token pat;
    protected String rpt;
    protected UmaNeedInfoResponse needInfo;
    protected String claimsGatheringTicket;

    @BeforeClass
    @Parameters(value={"umaMetaDataUrl", "umaPatClientId", "umaPatClientSecret"})
    public void init(String umaMetaDataUrl, String umaPatClientId, String umaPatClientSecret) throws Exception {
        this.metadata = UmaClientFactory.instance().createMetadataService(umaMetaDataUrl, AccessProtectedResourceFlowHttpTest.clientExecutor(true)).getMetadata();
        UmaTestUtil.assert_((UmaMetadata)this.metadata);
        this.pat = UmaClient.requestPat((String)this.tokenEndpoint, (String)umaPatClientId, (String)umaPatClientSecret, (ClientExecutor)AccessProtectedResourceFlowHttpTest.clientExecutor(true), (String[])new String[0]);
        UmaTestUtil.assert_((Token)this.pat);
        this.registerResourceTest = new RegisterResourceFlowHttpTest(this.metadata);
        this.registerResourceTest.pat = this.pat;
        this.permissionFlowTest = new UmaRegisterPermissionFlowHttpTest(this.metadata);
        this.permissionFlowTest.registerResourceTest = this.registerResourceTest;
        this.rptStatusService = UmaClientFactory.instance().createRptStatusService(this.metadata, AccessProtectedResourceFlowHttpTest.clientExecutor(true));
        this.tokenService = UmaClientFactory.instance().createTokenService(this.metadata, AccessProtectedResourceFlowHttpTest.clientExecutor(true));
    }

    @Test
    public void registerResource() throws Exception {
        this.showTitle("registerResource");
        this.registerResourceTest.addResource();
    }

    @Test(dependsOnMethods={"registerResource"})
    public void rsRegisterPermissions() throws Exception {
        this.showTitle("rsRegisterPermissions");
        this.permissionFlowTest.testRegisterPermission();
    }

    @Test(dependsOnMethods={"rsRegisterPermissions"})
    @Parameters(value={"umaPatClientId", "umaPatClientSecret"})
    public void requestRptAndGetNeedsInfo(String umaPatClientId, String umaPatClientSecret) throws Exception {
        this.showTitle("requestRptAndGetNeedsInfo");
        try {
            this.tokenService.requestRpt("Basic " + AccessProtectedResourceFlowHttpTest.encodeCredentials(umaPatClientId, umaPatClientSecret), GrantType.OXAUTH_UMA_TICKET.getValue(), this.permissionFlowTest.ticket, null, null, null, null, null);
        }
        catch (ClientResponseFailure ex) {
            String entity = (String)ex.getResponse().getEntity(String.class);
            System.out.println(entity);
            Assert.assertEquals((int)ex.getResponse().getStatus(), (int)Response.Status.FORBIDDEN.getStatusCode(), (String)"Unexpected response status");
            this.needInfo = (UmaNeedInfoResponse)Util.createJsonMapper().readValue(entity, UmaNeedInfoResponse.class);
            UmaTestUtil.assert_((UmaNeedInfoResponse)this.needInfo);
            return;
        }
        throw new AssertionError((Object)"need_info error was not returned");
    }

    @Test(dependsOnMethods={"requestRptAndGetNeedsInfo"})
    @Parameters(value={"umaPatClientId"})
    public void claimsGathering(String umaPatClientId) throws Exception {
        String gatheringUrl = this.needInfo.buildClaimsGatheringUrl(umaPatClientId, this.metadata.getClaimsInteractionEndpoint());
        System.out.println(gatheringUrl);
        System.out.println();
        try {
            this.startSelenium();
            this.driver.navigate().to(gatheringUrl);
            System.out.println(this.driver.getCurrentUrl());
            this.driver.findElement(By.id((String)"loginForm:country")).sendKeys(new CharSequence[]{"US"});
            this.driver.findElement(By.id((String)"loginForm:gather")).click();
            Thread.sleep(1000L);
            System.out.println(this.driver.getCurrentUrl());
            this.driver.findElement(By.id((String)"loginForm:city")).sendKeys(new CharSequence[]{"NY"});
            this.driver.findElement(By.id((String)"loginForm:gather")).click();
            System.out.println(this.driver.getCurrentUrl());
            this.claimsGatheringTicket = StringUtils.substringAfter((String)this.driver.getCurrentUrl(), (String)"ticket=");
        }
        finally {
            this.stopSelenium();
        }
    }

    @Test(dependsOnMethods={"claimsGathering"})
    @Parameters(value={"umaPatClientId", "umaPatClientSecret"})
    public void successfulRptRequest(String umaPatClientId, String umaPatClientSecret) throws Exception {
        this.showTitle("successfulRptRequest");
        UmaTokenResponse response = this.tokenService.requestRpt("Basic " + AccessProtectedResourceFlowHttpTest.encodeCredentials(umaPatClientId, umaPatClientSecret), GrantType.OXAUTH_UMA_TICKET.getValue(), this.claimsGatheringTicket, null, null, null, null, null);
        UmaTestUtil.assert_((UmaTokenResponse)response);
        this.rpt = response.getAccessToken();
    }

    @Test(dependsOnMethods={"successfulRptRequest"})
    @Parameters
    public void rptStatus() throws Exception {
        this.showTitle("rptStatus");
        UmaTestUtil.assert_((RptIntrospectionResponse)this.rptStatusService.requestRptStatus("Bearer " + this.pat.getAccessToken(), this.rpt, ""));
    }

    public static String encodeCredentials(String username, String password) throws UnsupportedEncodingException {
        return Base64.encodeBase64String((byte[])Util.getBytes((String)(username + ":" + password)));
    }
}

