/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.codehaus.jettison.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.BaseRequest;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.client.TokenClient;
import org.xdi.oxauth.client.TokenRequest;
import org.xdi.oxauth.client.TokenResponse;
import org.xdi.oxauth.client.UserInfoClient;
import org.xdi.oxauth.client.UserInfoRequest;
import org.xdi.oxauth.client.UserInfoResponse;
import org.xdi.oxauth.client.model.authorize.Claim;
import org.xdi.oxauth.client.model.authorize.ClaimValue;
import org.xdi.oxauth.client.model.authorize.JwtAuthorizationRequest;
import org.xdi.oxauth.client.model.authorize.UserInfoMember;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.AuthorizationMethod;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.common.SubjectType;
import org.xdi.oxauth.model.crypto.AbstractCryptoProvider;
import org.xdi.oxauth.model.crypto.OxAuthCryptoProvider;
import org.xdi.oxauth.model.crypto.encryption.BlockEncryptionAlgorithm;
import org.xdi.oxauth.model.crypto.encryption.KeyEncryptionAlgorithm;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.util.StringUtils;

public class UserInfoRestWebServiceHttpTest
extends BaseTest {
    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void requestUserInfoImplicitFlow(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestUserInfoImplicitFlow");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        List<GrantType> grantTypes = Arrays.asList(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        RegisterResponse registerResponse = this.registerClient(redirectUris, responseTypes, grantTypes, sectorIdentifierUri);
        String clientId = registerResponse.getClientId();
        AuthorizationResponse response1 = this.requestAuthorization(userId, userSecret, redirectUri, responseTypes, clientId);
        String accessToken = response1.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        UserInfoResponse response2 = userInfoClient.execUserInfo(accessToken);
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)response2.getStatus(), (int)200, (String)("Unexpected response code: " + response2.getStatus()));
        Assert.assertNotNull((Object)response2.getClaim("sub"));
        Assert.assertNotNull((Object)response2.getClaim("name"));
        Assert.assertNotNull((Object)response2.getClaim("given_name"));
        Assert.assertNotNull((Object)response2.getClaim("family_name"));
        Assert.assertNotNull((Object)response2.getClaim("email"));
        Assert.assertNotNull((Object)response2.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)response2.getClaim("locale"));
        Assert.assertNotNull((Object)response2.getClaim("address"));
        Assert.assertNull((Object)response2.getClaim("org_name"));
        Assert.assertNull((Object)response2.getClaim("work_phone"));
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void requestUserInfoWithNotAllowedScopeImplicitFlow(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestUserInfoWithNotAllowedScopeImplicitFlow");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        List<GrantType> grantTypes = Arrays.asList(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        RegisterResponse registerResponse = this.registerClient(redirectUris, responseTypes, grantTypes, sectorIdentifierUri);
        String clientId = registerResponse.getClientId();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email", "mobile_phone");
        AuthorizationResponse response1 = this.requestAuthorization(userId, userSecret, redirectUri, responseTypes, clientId, scopes);
        String accessToken = response1.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        UserInfoResponse response2 = userInfoClient.execUserInfo(accessToken);
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)response2.getStatus(), (int)200, (String)("Unexpected response code: " + response2.getStatus()));
        Assert.assertNotNull((Object)response2.getClaim("sub"));
        Assert.assertNotNull((Object)response2.getClaim("name"));
        Assert.assertNotNull((Object)response2.getClaim("given_name"));
        Assert.assertNotNull((Object)response2.getClaim("family_name"));
        Assert.assertNotNull((Object)response2.getClaim("email"));
        Assert.assertNotNull((Object)response2.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)response2.getClaim("locale"));
        Assert.assertNotNull((Object)response2.getClaim("address"));
        Assert.assertNull((Object)response2.getClaim("phone_mobile_number"));
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void requestUserInfoDynamicScopesImplicitFlow(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestUserInfoDynamicScopesImplicitFlow");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        List<GrantType> grantTypes = Arrays.asList(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email", "org_name", "work_phone");
        RegisterResponse registerResponse = this.registerClient(redirectUris, responseTypes, grantTypes, sectorIdentifierUri);
        String clientId = registerResponse.getClientId();
        AuthorizationResponse response1 = this.requestAuthorization(userId, userSecret, redirectUri, responseTypes, clientId, scopes);
        String accessToken = response1.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        UserInfoResponse response2 = userInfoClient.execUserInfo(accessToken);
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)response2.getStatus(), (int)200, (String)("Unexpected response code: " + response2.getStatus()));
        Assert.assertNotNull((Object)response2.getClaim("sub"));
        Assert.assertNotNull((Object)response2.getClaim("name"));
        Assert.assertNotNull((Object)response2.getClaim("given_name"));
        Assert.assertNotNull((Object)response2.getClaim("family_name"));
        Assert.assertNotNull((Object)response2.getClaim("email"));
        Assert.assertNotNull((Object)response2.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)response2.getClaim("locale"));
        Assert.assertNotNull((Object)response2.getClaim("address"));
        Assert.assertNotNull((Object)response2.getClaim("org_name"));
        Assert.assertNotNull((Object)response2.getClaim("work_phone"));
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "sectorIdentifierUri"})
    @Test
    public void requestUserInfoPasswordFlow(String userId, String userSecret, String redirectUris, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestUserInfoPasswordFlow");
        ArrayList<ResponseType> responseTypes = new ArrayList<ResponseType>();
        List<GrantType> grantTypes = Arrays.asList(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        RegisterResponse registerResponse = this.registerClient(redirectUris, responseTypes, grantTypes, sectorIdentifierUri);
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String username = userId;
        String password = userSecret;
        String scope = "openid profile address email";
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        TokenResponse response1 = tokenClient.execResourceOwnerPasswordCredentialsGrant(username, password, scope, clientId, clientSecret);
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)response1.getStatus(), (int)200, (String)("Unexpected response code: " + response1.getStatus()));
        Assert.assertNotNull((Object)response1.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)response1.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)response1.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)response1.getRefreshToken(), (String)"The refresh token is null");
        Assert.assertNotNull((Object)response1.getScope(), (String)"The scope is null");
        String accessToken = response1.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        UserInfoResponse response2 = userInfoClient.execUserInfo(accessToken);
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)response2.getStatus(), (int)200, (String)("Unexpected response code: " + response2.getStatus()));
        Assert.assertNotNull((Object)response2.getClaim("sub"));
        Assert.assertNotNull((Object)response2.getClaim("name"));
        Assert.assertNotNull((Object)response2.getClaim("given_name"));
        Assert.assertNotNull((Object)response2.getClaim("family_name"));
        Assert.assertNotNull((Object)response2.getClaim("email"));
        Assert.assertNotNull((Object)response2.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)response2.getClaim("locale"));
        Assert.assertNull((Object)response2.getClaim("org_name"));
        Assert.assertNull((Object)response2.getClaim("work_phone"));
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "sectorIdentifierUri"})
    @Test
    public void requestUserInfoWithNotAllowedScopePasswordFlow(String userId, String userSecret, String redirectUris, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestUserInfoWithNotAllowedScopePasswordFlow");
        ArrayList<ResponseType> responseTypes = new ArrayList<ResponseType>();
        List<GrantType> grantTypes = Arrays.asList(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        RegisterResponse registerResponse = this.registerClient(redirectUris, responseTypes, grantTypes, sectorIdentifierUri);
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String username = userId;
        String password = userSecret;
        String scope = "openid profile address email mobile_phone";
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        TokenResponse response1 = tokenClient.execResourceOwnerPasswordCredentialsGrant(username, password, scope, clientId, clientSecret);
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)response1.getStatus(), (int)200, (String)("Unexpected response code: " + response1.getStatus()));
        Assert.assertNotNull((Object)response1.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)response1.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)response1.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)response1.getRefreshToken(), (String)"The refresh token is null");
        Assert.assertNotNull((Object)response1.getScope(), (String)"The scope is null");
        String accessToken = response1.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        UserInfoResponse response2 = userInfoClient.execUserInfo(accessToken);
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)response2.getStatus(), (int)200, (String)("Unexpected response code: " + response2.getStatus()));
        Assert.assertNotNull((Object)response2.getClaim("sub"));
        Assert.assertNotNull((Object)response2.getClaim("name"));
        Assert.assertNotNull((Object)response2.getClaim("given_name"));
        Assert.assertNotNull((Object)response2.getClaim("family_name"));
        Assert.assertNotNull((Object)response2.getClaim("email"));
        Assert.assertNotNull((Object)response2.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)response2.getClaim("locale"));
        Assert.assertNull((Object)response2.getClaim("phone_mobile_number"));
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "sectorIdentifierUri"})
    @Test
    public void requestUserInfoDynamicScopesPasswordFlow(String userId, String userSecret, String redirectUris, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestUserInfoDynamicScopesPasswordFlow");
        ArrayList<ResponseType> responseTypes = new ArrayList<ResponseType>();
        List<GrantType> grantTypes = Arrays.asList(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        RegisterResponse registerResponse = this.registerClient(redirectUris, responseTypes, grantTypes, sectorIdentifierUri);
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String username = userId;
        String password = userSecret;
        String scope = "openid profile address email org_name work_phone";
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        TokenResponse response1 = tokenClient.execResourceOwnerPasswordCredentialsGrant(username, password, scope, clientId, clientSecret);
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)response1.getStatus(), (int)200, (String)("Unexpected response code: " + response1.getStatus()));
        Assert.assertNotNull((Object)response1.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)response1.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)response1.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)response1.getRefreshToken(), (String)"The refresh token is null");
        Assert.assertNotNull((Object)response1.getScope(), (String)"The scope is null");
        String accessToken = response1.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        UserInfoResponse response2 = userInfoClient.execUserInfo(accessToken);
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)response2.getStatus(), (int)200, (String)("Unexpected response code: " + response2.getStatus()));
        Assert.assertNotNull((Object)response2.getClaim("sub"));
        Assert.assertNotNull((Object)response2.getClaim("name"));
        Assert.assertNotNull((Object)response2.getClaim("given_name"));
        Assert.assertNotNull((Object)response2.getClaim("family_name"));
        Assert.assertNotNull((Object)response2.getClaim("email"));
        Assert.assertNotNull((Object)response2.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)response2.getClaim("locale"));
        Assert.assertNotNull((Object)response2.getClaim("org_name"));
        Assert.assertNotNull((Object)response2.getClaim("work_phone"));
    }

    @Test
    public void requestUserInfoInvalidRequest() throws Exception {
        this.showTitle("requestUserInfoInvalidRequest");
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        UserInfoResponse response = userInfoClient.execUserInfo(null);
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)response.getStatus(), (int)400, (String)("Unexpected response code: " + response.getStatus()));
        Assert.assertNotNull((Object)response.getErrorType(), (String)"Unexpected result: errorType not found");
        Assert.assertNotNull((Object)response.getErrorDescription(), (String)"Unexpected result: errorDescription not found");
    }

    @Test
    public void requestUserInfoInvalidToken() throws Exception {
        this.showTitle("requestUserInfoInvalidToken");
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        UserInfoResponse response = userInfoClient.execUserInfo("INVALID_ACCESS_TOKEN");
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)response.getStatus(), (int)400, (String)("Unexpected response code: " + response.getStatus()));
        Assert.assertNotNull((Object)response.getErrorType(), (String)"Unexpected result: errorType not found");
        Assert.assertNotNull((Object)response.getErrorDescription(), (String)"Unexpected result: errorDescription not found");
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void requestUserInfoInsufficientScope(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestUserInfoInsufficientScope");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        List<GrantType> grantTypes = Arrays.asList(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        RegisterResponse registerResponse = this.registerClient(redirectUris, responseTypes, grantTypes, sectorIdentifierUri);
        String clientId = registerResponse.getClientId();
        List<String> scopes = Arrays.asList("picture");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)authorizationResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope must be null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The id token must be null");
        String accessToken = authorizationResponse.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        UserInfoResponse userInfoResponse = userInfoClient.execUserInfo(accessToken);
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)403, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getErrorType(), (String)"Unexpected result: errorType not found");
        Assert.assertNotNull((Object)userInfoResponse.getErrorDescription(), (String)"Unexpected result: errorDescription not found");
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void requestUserInfoAdditionalClaims(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestUserInfoAdditionalClaims");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
        List<GrantType> grantTypes = Arrays.asList(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        RegisterResponse registerResponse = this.registerClient(redirectUris, responseTypes, grantTypes, sectorIdentifierUri);
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.HS256, clientSecret, (AbstractCryptoProvider)cryptoProvider);
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("invalid", ClaimValue.createEssential((boolean)false)));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("iname", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("o", ClaimValue.createEssential((boolean)true)));
        String authJwt = jwtAuthorizationRequest.getEncodedJwt();
        authorizationRequest.setRequest(authJwt);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)authorizationResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope must be null");
        String accessToken = authorizationResponse.getAccessToken();
        UserInfoRequest userInfoRequest = new UserInfoRequest(accessToken);
        userInfoRequest.setAuthorizationMethod(AuthorizationMethod.AUTHORIZATION_REQUEST_HEADER_FIELD);
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        userInfoClient.setRequest((BaseRequest)userInfoRequest);
        UserInfoResponse userInfoResponse = userInfoClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("given_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("family_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("email"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("locale"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("iname"), (String)"Unexpected result: iname not found");
        Assert.assertNotNull((Object)userInfoResponse.getClaim("o"), (String)"Unexpected result: organization not found");
        UserInfoRequest userInfoRequest2 = new UserInfoRequest(accessToken);
        userInfoRequest2.setAuthorizationMethod(AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER);
        UserInfoClient userInfoClient2 = new UserInfoClient(this.userInfoEndpoint);
        userInfoClient2.setRequest((BaseRequest)userInfoRequest2);
        UserInfoResponse response3 = userInfoClient2.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient2);
        Assert.assertEquals((int)response3.getStatus(), (int)200, (String)("Unexpected response code: " + response3.getStatus()));
        Assert.assertNotNull((Object)response3.getClaim("sub"));
        Assert.assertNotNull((Object)response3.getClaim("name"));
        Assert.assertNotNull((Object)response3.getClaim("given_name"));
        Assert.assertNotNull((Object)response3.getClaim("family_name"));
        Assert.assertNotNull((Object)response3.getClaim("email"));
        Assert.assertNotNull((Object)response3.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)response3.getClaim("locale"));
        UserInfoRequest userInfoRequest3 = new UserInfoRequest(accessToken);
        userInfoRequest3.setAuthorizationMethod(AuthorizationMethod.URL_QUERY_PARAMETER);
        UserInfoClient userInfoClient3 = new UserInfoClient(this.userInfoEndpoint);
        userInfoClient3.setRequest((BaseRequest)userInfoRequest3);
        UserInfoResponse response4 = userInfoClient3.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient3);
        Assert.assertEquals((int)response4.getStatus(), (int)200, (String)("Unexpected response code: " + response4.getStatus()));
        Assert.assertNotNull((Object)response4.getClaim("sub"));
        Assert.assertNotNull((Object)response4.getClaim("name"));
        Assert.assertNotNull((Object)response4.getClaim("given_name"));
        Assert.assertNotNull((Object)response4.getClaim("family_name"));
        Assert.assertNotNull((Object)response4.getClaim("email"));
        Assert.assertNotNull((Object)response4.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)response4.getClaim("locale"));
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri", "clientJwksUri", "postLogoutRedirectUri"})
    @Test
    public void claimsRequestWithEssentialNameClaim(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri, String clientJwksUri, String postLogoutRedirectUri) throws Exception {
        this.showTitle("claimsRequestWithEssentialNameClaim");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<GrantType> grantTypes = Arrays.asList(GrantType.AUTHORIZATION_CODE);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setContacts(Arrays.asList("javier@gluu.org", "javier.rojas.blum@gmail.com"));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setGrantTypes(grantTypes);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setPostLogoutRedirectUris(Arrays.asList(postLogoutRedirectUri));
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        registerRequest.setSubjectType(SubjectType.PAIRWISE);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        List<String> scopes = Arrays.asList("openid");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        JSONObject claimsObj = new JSONObject();
        UserInfoMember userInfoMember = new UserInfoMember();
        userInfoMember.getClaims().add(new Claim("name", ClaimValue.createEssential((boolean)true)));
        claimsObj.put("userinfo", (Object)userInfoMember.toJSONObject());
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.setClaims(claimsObj);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation());
        Assert.assertNotNull((Object)authorizationResponse.getCode());
        Assert.assertNotNull((Object)authorizationResponse.getState());
        Assert.assertNotNull((Object)authorizationResponse.getScope());
        String authorizationCode = authorizationResponse.getCode();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)tokenResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken(), (String)"The refresh token is null");
        String accessToken = tokenResponse.getAccessToken();
        UserInfoRequest userInfoRequest = new UserInfoRequest(accessToken);
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        userInfoClient.setRequest((BaseRequest)userInfoRequest);
        UserInfoResponse userInfoResponse = userInfoClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "sectorIdentifierUri"})
    @Test
    public void requestUserInfoHS256(String redirectUris, String redirectUri, String userId, String userSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestUserInfoHS256");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setUserInfoSignedResponseAlg(SignatureAlgorithm.HS256);
        registerRequest.setSubjectType(SubjectType.PAIRWISE);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        AuthorizationResponse authorizationResponse = this.requestAuthorization(userId, userSecret, redirectUri, responseTypes, clientId);
        String accessToken = authorizationResponse.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        userInfoClient.setSharedKey(clientSecret);
        UserInfoResponse userInfoResponse = userInfoClient.execUserInfo(accessToken);
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("iss"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("aud"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("given_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("family_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("picture"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("email"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("locale"));
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "sectorIdentifierUri"})
    @Test
    public void requestUserInfoHS384(String redirectUris, String redirectUri, String userId, String userSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestUserInfoHS384");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setUserInfoSignedResponseAlg(SignatureAlgorithm.HS384);
        registerRequest.setSubjectType(SubjectType.PAIRWISE);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        AuthorizationResponse authorizationResponse = this.requestAuthorization(userId, userSecret, redirectUri, responseTypes, clientId);
        String accessToken = authorizationResponse.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        userInfoClient.setSharedKey(clientSecret);
        UserInfoResponse userInfoResponse = userInfoClient.execUserInfo(accessToken);
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("iss"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("aud"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("given_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("family_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("picture"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("email"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("locale"));
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "sectorIdentifierUri"})
    @Test
    public void requestUserInfoHS512(String redirectUris, String redirectUri, String userId, String userSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestUserInfoHS512");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setUserInfoSignedResponseAlg(SignatureAlgorithm.HS512);
        registerRequest.setSubjectType(SubjectType.PAIRWISE);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        AuthorizationResponse authorizationResponse = this.requestAuthorization(userId, userSecret, redirectUri, responseTypes, clientId);
        String accessToken = authorizationResponse.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        userInfoClient.setSharedKey(clientSecret);
        UserInfoResponse userInfoResponse = userInfoClient.execUserInfo(accessToken);
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("iss"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("aud"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("given_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("family_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("picture"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("email"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("locale"));
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "sectorIdentifierUri"})
    @Test
    public void requestUserInfoRS256(String redirectUris, String redirectUri, String userId, String userSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestUserInfoRS256");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setUserInfoSignedResponseAlg(SignatureAlgorithm.RS256);
        registerRequest.setSubjectType(SubjectType.PAIRWISE);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        AuthorizationResponse authorizationResponse = this.requestAuthorization(userId, userSecret, redirectUri, responseTypes, clientId);
        String accessToken = authorizationResponse.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        userInfoClient.setJwksUri(this.jwksUri);
        UserInfoResponse userInfoResponse = userInfoClient.execUserInfo(accessToken);
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("iss"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("aud"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("given_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("family_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("picture"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("email"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("locale"));
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "sectorIdentifierUri"})
    @Test
    public void requestUserInfoRS384(String redirectUris, String redirectUri, String userId, String userSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestUserInfoRS384");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setUserInfoSignedResponseAlg(SignatureAlgorithm.RS384);
        registerRequest.setSubjectType(SubjectType.PAIRWISE);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        AuthorizationResponse authorizationResponse = this.requestAuthorization(userId, userSecret, redirectUri, responseTypes, clientId);
        String accessToken = authorizationResponse.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        userInfoClient.setJwksUri(this.jwksUri);
        UserInfoResponse userInfoResponse = userInfoClient.execUserInfo(accessToken);
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("iss"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("aud"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("given_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("family_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("picture"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("email"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("locale"));
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "sectorIdentifierUri"})
    @Test
    public void requestUserInfoRS512(String redirectUris, String redirectUri, String userId, String userSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestUserInfoRS512");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setUserInfoSignedResponseAlg(SignatureAlgorithm.RS512);
        registerRequest.setSubjectType(SubjectType.PAIRWISE);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        AuthorizationResponse authorizationResponse = this.requestAuthorization(userId, userSecret, redirectUri, responseTypes, clientId);
        String accessToken = authorizationResponse.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        userInfoClient.setJwksUri(this.jwksUri);
        UserInfoResponse userInfoResponse = userInfoClient.execUserInfo(accessToken);
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("iss"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("aud"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("given_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("family_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("picture"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("email"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("locale"));
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "sectorIdentifierUri"})
    @Test
    public void requestUserInfoES256(String redirectUris, String redirectUri, String userId, String userSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestUserInfoES256");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setUserInfoSignedResponseAlg(SignatureAlgorithm.ES256);
        registerRequest.setSubjectType(SubjectType.PAIRWISE);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        AuthorizationResponse authorizationResponse = this.requestAuthorization(userId, userSecret, redirectUri, responseTypes, clientId);
        String accessToken = authorizationResponse.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        userInfoClient.setJwksUri(this.jwksUri);
        UserInfoResponse userInfoResponse = userInfoClient.execUserInfo(accessToken);
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("iss"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("aud"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("given_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("family_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("picture"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("email"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("locale"));
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "sectorIdentifierUri"})
    @Test
    public void requestUserInfoES384(String redirectUris, String redirectUri, String userId, String userSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestUserInfoES384");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setUserInfoSignedResponseAlg(SignatureAlgorithm.ES384);
        registerRequest.setSubjectType(SubjectType.PAIRWISE);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        AuthorizationResponse authorizationResponse = this.requestAuthorization(userId, userSecret, redirectUri, responseTypes, clientId);
        String accessToken = authorizationResponse.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        userInfoClient.setJwksUri(this.jwksUri);
        UserInfoResponse userInfoResponse = userInfoClient.execUserInfo(accessToken);
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("iss"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("aud"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("given_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("family_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("picture"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("email"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("locale"));
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "sectorIdentifierUri"})
    @Test
    public void requestUserInfoES512(String redirectUris, String redirectUri, String userId, String userSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestUserInfoES512");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setUserInfoSignedResponseAlg(SignatureAlgorithm.ES512);
        registerRequest.setSubjectType(SubjectType.PAIRWISE);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        AuthorizationResponse authorizationResponse = this.requestAuthorization(userId, userSecret, redirectUri, responseTypes, clientId);
        String accessToken = authorizationResponse.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        userInfoClient.setJwksUri(this.jwksUri);
        UserInfoResponse userInfoResponse = userInfoClient.execUserInfo(accessToken);
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("iss"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("aud"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("given_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("family_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("picture"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("email"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("locale"));
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "sectorIdentifierUri", "RS256_enc_keyId", "keyStoreFile", "keyStoreSecret"})
    @Test
    public void requestUserInfoAlgRSAOAEPEncA256GCM(String redirectUris, String redirectUri, String userId, String userSecret, String jwksUri, String sectorIdentifierUri, String keyId, String keyStoreFile, String keyStoreSecret) {
        try {
            this.showTitle("requestUserInfoAlgRSAOAEPEncA256GCM");
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setJwksUri(jwksUri);
            registerRequest.setResponseTypes(responseTypes);
            registerRequest.setUserInfoEncryptedResponseAlg(KeyEncryptionAlgorithm.RSA_OAEP);
            registerRequest.setUserInfoEncryptedResponseEnc(BlockEncryptionAlgorithm.A256GCM);
            registerRequest.setSubjectType(SubjectType.PAIRWISE);
            registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
            RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
            registerClient.setRequest((BaseRequest)registerRequest);
            RegisterResponse registerResponse = registerClient.exec();
            UserInfoRestWebServiceHttpTest.showClient((BaseClient)registerClient);
            Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
            Assert.assertNotNull((Object)registerResponse.getClientId());
            Assert.assertNotNull((Object)registerResponse.getClientSecret());
            Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
            Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
            String clientId = registerResponse.getClientId();
            AuthorizationResponse authorizationResponse = this.requestAuthorization(userId, userSecret, redirectUri, responseTypes, clientId);
            String accessToken = authorizationResponse.getAccessToken();
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, null);
            PrivateKey privateKey = cryptoProvider.getPrivateKey(keyId);
            UserInfoRequest userInfoRequest = new UserInfoRequest(accessToken);
            UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
            userInfoClient.setPrivateKey(privateKey);
            userInfoClient.setRequest((BaseRequest)userInfoRequest);
            UserInfoResponse userInfoResponse = userInfoClient.exec();
            UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
            Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("given_name"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("family_name"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("picture"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("email"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("zoneinfo"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("locale"));
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage(), (Throwable)ex);
        }
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "sectorIdentifierUri", "RS256_enc_keyId", "keyStoreFile", "keyStoreSecret"})
    @Test
    public void requestUserInfoAlgRSA15EncA128CBCPLUSHS256(String redirectUris, String redirectUri, String userId, String userSecret, String jwksUri, String sectorIdentifierUri, String keyId, String keyStoreFile, String keyStoreSecret) {
        try {
            this.showTitle("requestUserInfoAlgRSA15EncA128CBCPLUSHS256");
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setJwksUri(jwksUri);
            registerRequest.setResponseTypes(responseTypes);
            registerRequest.setUserInfoEncryptedResponseAlg(KeyEncryptionAlgorithm.RSA1_5);
            registerRequest.setUserInfoEncryptedResponseEnc(BlockEncryptionAlgorithm.A128CBC_PLUS_HS256);
            registerRequest.setSubjectType(SubjectType.PAIRWISE);
            registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
            RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
            registerClient.setRequest((BaseRequest)registerRequest);
            RegisterResponse registerResponse = registerClient.exec();
            UserInfoRestWebServiceHttpTest.showClient((BaseClient)registerClient);
            Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
            Assert.assertNotNull((Object)registerResponse.getClientId());
            Assert.assertNotNull((Object)registerResponse.getClientSecret());
            Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
            Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
            String clientId = registerResponse.getClientId();
            AuthorizationResponse authorizationResponse = this.requestAuthorization(userId, userSecret, redirectUri, responseTypes, clientId);
            String accessToken = authorizationResponse.getAccessToken();
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, null);
            PrivateKey privateKey = cryptoProvider.getPrivateKey(keyId);
            UserInfoRequest userInfoRequest = new UserInfoRequest(accessToken);
            UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
            userInfoClient.setPrivateKey(privateKey);
            userInfoClient.setRequest((BaseRequest)userInfoRequest);
            UserInfoResponse userInfoResponse = userInfoClient.exec();
            UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
            Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("given_name"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("family_name"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("picture"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("email"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("zoneinfo"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("locale"));
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage(), (Throwable)ex);
        }
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "sectorIdentifierUri", "RS256_enc_keyId", "keyStoreFile", "keyStoreSecret"})
    @Test
    public void requestUserInfoAlgRSA15EncA256CBCPLUSHS512(String redirectUris, String redirectUri, String userId, String userSecret, String jwksUri, String sectorIdentifierUri, String keyId, String keyStoreFile, String keyStoreSecret) {
        try {
            this.showTitle("requestUserInfoAlgRSA15EncA256CBCPLUSHS512");
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setJwksUri(jwksUri);
            registerRequest.setResponseTypes(responseTypes);
            registerRequest.setUserInfoEncryptedResponseAlg(KeyEncryptionAlgorithm.RSA1_5);
            registerRequest.setUserInfoEncryptedResponseEnc(BlockEncryptionAlgorithm.A256CBC_PLUS_HS512);
            registerRequest.setSubjectType(SubjectType.PAIRWISE);
            registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
            RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
            registerClient.setRequest((BaseRequest)registerRequest);
            RegisterResponse registerResponse = registerClient.exec();
            UserInfoRestWebServiceHttpTest.showClient((BaseClient)registerClient);
            Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
            Assert.assertNotNull((Object)registerResponse.getClientId());
            Assert.assertNotNull((Object)registerResponse.getClientSecret());
            Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
            Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
            String clientId = registerResponse.getClientId();
            AuthorizationResponse authorizationResponse = this.requestAuthorization(userId, userSecret, redirectUri, responseTypes, clientId);
            String accessToken = authorizationResponse.getAccessToken();
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, null);
            PrivateKey privateKey = cryptoProvider.getPrivateKey(keyId);
            UserInfoRequest userInfoRequest = new UserInfoRequest(accessToken);
            UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
            userInfoClient.setPrivateKey(privateKey);
            userInfoClient.setRequest((BaseRequest)userInfoRequest);
            UserInfoResponse userInfoResponse = userInfoClient.exec();
            UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
            Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("given_name"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("family_name"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("picture"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("email"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("zoneinfo"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("locale"));
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage(), (Throwable)ex);
        }
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "sectorIdentifierUri"})
    @Test
    public void requestUserInfoAlgA128KWEncA128GCM(String redirectUris, String redirectUri, String userId, String userSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestUserInfoAlgA128KWEncA128GCM");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setUserInfoEncryptedResponseAlg(KeyEncryptionAlgorithm.A128KW);
        registerRequest.setUserInfoEncryptedResponseEnc(BlockEncryptionAlgorithm.A128GCM);
        registerRequest.setSubjectType(SubjectType.PAIRWISE);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        AuthorizationResponse authorizationResponse = this.requestAuthorization(userId, userSecret, redirectUri, responseTypes, clientId);
        String accessToken = authorizationResponse.getAccessToken();
        UserInfoRequest userInfoRequest = new UserInfoRequest(accessToken);
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        userInfoClient.setSharedKey(clientSecret);
        userInfoClient.setRequest((BaseRequest)userInfoRequest);
        UserInfoResponse userInfoResponse = userInfoClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("given_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("family_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("picture"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("email"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("locale"));
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "sectorIdentifierUri"})
    @Test
    public void requestUserInfoAlgA256KWEncA256GCM(String redirectUris, String redirectUri, String userId, String userSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestUserInfoAlgA256KWEncA256GCM");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setUserInfoEncryptedResponseAlg(KeyEncryptionAlgorithm.A256KW);
        registerRequest.setUserInfoEncryptedResponseEnc(BlockEncryptionAlgorithm.A256GCM);
        registerRequest.setSubjectType(SubjectType.PAIRWISE);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        AuthorizationResponse authorizationResponse = this.requestAuthorization(userId, userSecret, redirectUri, responseTypes, clientId);
        String accessToken = authorizationResponse.getAccessToken();
        UserInfoRequest userInfoRequest = new UserInfoRequest(accessToken);
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        userInfoClient.setSharedKey(clientSecret);
        userInfoClient.setRequest((BaseRequest)userInfoRequest);
        UserInfoResponse userInfoResponse = userInfoClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("given_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("family_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("picture"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("email"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("locale"));
    }

    private RegisterResponse registerClient(String redirectUris, List<ResponseType> responseTypes, List<GrantType> grantTypes, String sectorIdentifierUri) {
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setGrantTypes(grantTypes);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        registerRequest.setSubjectType(SubjectType.PAIRWISE);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        return registerResponse;
    }

    private AuthorizationResponse requestAuthorization(String userId, String userSecret, String redirectUri, List<ResponseType> responseTypes, String clientId) {
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        return this.requestAuthorization(userId, userSecret, redirectUri, responseTypes, clientId, scopes);
    }

    private AuthorizationResponse requestAuthorization(String userId, String userSecret, String redirectUri, List<ResponseType> responseTypes, String clientId, List<String> scopes) {
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)authorizationResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope must be null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The id token must be null");
        return authorizationResponse;
    }
}

