/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.BaseRequest;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.client.TokenClient;
import org.xdi.oxauth.client.TokenRequest;
import org.xdi.oxauth.client.TokenResponse;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.AuthorizationMethod;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.crypto.AbstractCryptoProvider;
import org.xdi.oxauth.model.crypto.OxAuthCryptoProvider;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.util.StringUtils;

public class UserAuthenticationFilterHttpTest
extends BaseTest {
    @Parameters(value={"redirectUris", "userInum", "userEmail", "sectorIdentifierUri"})
    @Test
    public void requestAccessTokenCustomAuth1(String redirectUris, String userInum, String userEmail, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestAccessTokenCustomAuth1");
        List<GrantType> grantTypes = Arrays.asList(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        registerRequest.setGrantTypes(grantTypes);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        UserAuthenticationFilterHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        TokenRequest tokenRequest = new TokenRequest(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        tokenRequest.setScope("openid");
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.addCustomParameter("mail", userEmail);
        tokenRequest.addCustomParameter("inum", userInum);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse response1 = tokenClient.exec();
        UserAuthenticationFilterHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)response1.getStatus(), (int)200, (String)("Unexpected response code: " + response1.getStatus()));
        Assert.assertNotNull((Object)response1.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)response1.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)response1.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)response1.getRefreshToken(), (String)"The refresh token is null");
        Assert.assertNotNull((Object)response1.getScope(), (String)"The scope is null");
        Assert.assertNotNull((Object)response1.getIdToken(), (String)"The id token is null");
    }

    @Parameters(value={"redirectUris", "userId", "userSecret", "sectorIdentifierUri"})
    @Test
    public void requestAccessTokenCustomAuth2(String redirectUris, String userId, String userSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestAccessTokenCustomAuth2");
        List<GrantType> grantTypes = Arrays.asList(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        registerRequest.setGrantTypes(grantTypes);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        UserAuthenticationFilterHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        TokenRequest tokenRequest = new TokenRequest(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        tokenRequest.setScope("openid");
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.addCustomParameter("uid", userId);
        tokenRequest.addCustomParameter("pwd", userSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse response1 = tokenClient.exec();
        UserAuthenticationFilterHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)response1.getStatus(), (int)200, (String)("Unexpected response code: " + response1.getStatus()));
        Assert.assertNotNull((Object)response1.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)response1.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)response1.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)response1.getRefreshToken(), (String)"The refresh token is null");
        Assert.assertNotNull((Object)response1.getScope(), (String)"The scope is null");
        Assert.assertNotNull((Object)response1.getIdToken(), (String)"The id token is null");
    }

    @Parameters(value={"redirectUris", "userInum", "userEmail", "sectorIdentifierUri"})
    @Test
    public void requestAccessTokenCustomAuth3(String redirectUris, String userInum, String userEmail, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestAccessTokenCustomAuth3");
        List<GrantType> grantTypes = Arrays.asList(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        registerRequest.setGrantTypes(grantTypes);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        UserAuthenticationFilterHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        TokenRequest tokenRequest = new TokenRequest(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        tokenRequest.setScope("openid");
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.addCustomParameter("mail", userEmail);
        tokenRequest.addCustomParameter("inum", userInum);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse response1 = tokenClient.exec();
        UserAuthenticationFilterHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)response1.getStatus(), (int)200, (String)("Unexpected response code: " + response1.getStatus()));
        Assert.assertNotNull((Object)response1.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)response1.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)response1.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)response1.getRefreshToken(), (String)"The refresh token is null");
        Assert.assertNotNull((Object)response1.getScope(), (String)"The scope is null");
        Assert.assertNotNull((Object)response1.getIdToken(), (String)"The id token is null");
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "sectorIdentifierUri"})
    @Test
    public void requestAccessTokenCustomAuth4(String userId, String userSecret, String redirectUris, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestAccessTokenCustomAuth4");
        List<GrantType> grantTypes = Arrays.asList(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        registerRequest.setGrantTypes(grantTypes);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        UserAuthenticationFilterHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        TokenRequest tokenRequest = new TokenRequest(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        tokenRequest.setScope("openid");
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.addCustomParameter("uid", userId);
        tokenRequest.addCustomParameter("pwd", userSecret);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse response1 = tokenClient.exec();
        UserAuthenticationFilterHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)response1.getStatus(), (int)200, (String)("Unexpected response code: " + response1.getStatus()));
        Assert.assertNotNull((Object)response1.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)response1.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)response1.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)response1.getRefreshToken(), (String)"The refresh token is null");
        Assert.assertNotNull((Object)response1.getScope(), (String)"The scope is null");
        Assert.assertNotNull((Object)response1.getIdToken(), (String)"The id token is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userInum", "userEmail", "sectorIdentifierUri"})
    @Test
    public void requestAccessTokenCustomAuth5(String redirectUris, String redirectUri, String userInum, String userEmail, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestAccessTokenCustomAuth5");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        UserAuthenticationFilterHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        String nonce = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        authorizationRequest.addCustomParameter("mail", userEmail);
        authorizationRequest.addCustomParameter("inum", userInum);
        authorizationRequest.setAuthorizationMethod(AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER);
        AuthorizationResponse authorizationResponse = this.authorizationRequestAndGrantAccess(this.authorizationEndpoint, authorizationRequest);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        String authorizationCode = authorizationResponse.getCode();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        TokenClient tokenClient1 = new TokenClient(this.tokenEndpoint);
        tokenClient1.setRequest((BaseRequest)tokenRequest);
        TokenResponse response2 = tokenClient1.exec();
        UserAuthenticationFilterHttpTest.showClient((BaseClient)tokenClient1);
        Assert.assertEquals((int)response2.getStatus(), (int)200, (String)("Unexpected response code: " + response2.getStatus()));
        Assert.assertNotNull((Object)response2.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)response2.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)response2.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)response2.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)response2.getRefreshToken(), (String)"The refresh token is null");
    }
}

