/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.AuthorizeClient;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.BaseRequest;
import org.xdi.oxauth.client.JwkClient;
import org.xdi.oxauth.client.JwkResponse;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.client.TokenClient;
import org.xdi.oxauth.client.TokenRequest;
import org.xdi.oxauth.client.TokenResponse;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.crypto.OxAuthCryptoProvider;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.jwt.Jwt;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.util.JwtUtil;
import org.xdi.oxauth.model.util.StringUtils;

public class TokenSignaturesHttpTest
extends BaseTest {
    @Parameters(value={"redirectUris", "userId", "userSecret", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void requestAuthorizationIdTokenNone(String redirectUris, String userId, String userSecret, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestAuthorizationIdTokenNone");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setContacts(Arrays.asList("javier@gluu.org", "javier.rojas.blum@gmail.com"));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setIdTokenSignedResponseAlg(SignatureAlgorithm.NONE);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenSignaturesHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200);
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation());
        Assert.assertNotNull((Object)authorizationResponse.getCode());
        Assert.assertNotNull((Object)authorizationResponse.getState());
        Assert.assertNotNull((Object)authorizationResponse.getScope());
        Assert.assertNull((Object)authorizationResponse.getIdToken());
        String scope = authorizationResponse.getScope();
        String authorizationCode = authorizationResponse.getCode();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenSignaturesHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200);
        Assert.assertNotNull((Object)tokenResponse.getEntity());
        Assert.assertNotNull((Object)tokenResponse.getAccessToken());
        Assert.assertNotNull((Object)tokenResponse.getExpiresIn());
        Assert.assertNotNull((Object)tokenResponse.getTokenType());
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken());
        String idToken = tokenResponse.getIdToken();
        Jwt jwt = Jwt.parse((String)idToken);
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        boolean validJwt = cryptoProvider.verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), null, null, null, SignatureAlgorithm.NONE);
        Assert.assertTrue((boolean)validJwt);
    }

    @Parameters(value={"redirectUris", "userId", "userSecret", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void requestAuthorizationIdTokenHS256(String redirectUris, String userId, String userSecret, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestAuthorizationIdTokenHS256");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setContacts(Arrays.asList("javier@gluu.org", "javier.rojas.blum@gmail.com"));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setIdTokenSignedResponseAlg(SignatureAlgorithm.HS256);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenSignaturesHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest((BaseRequest)authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        TokenSignaturesHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        String idToken = authorizationResponse.getIdToken();
        Jwt jwt = Jwt.parse((String)idToken);
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        boolean validJwt = cryptoProvider.verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), null, null, clientSecret, SignatureAlgorithm.HS256);
        Assert.assertTrue((boolean)validJwt);
    }

    @Parameters(value={"redirectUris", "userId", "userSecret", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void requestAuthorizationIdTokenHS384(String redirectUris, String userId, String userSecret, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestAuthorizationIdTokenHS384");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setContacts(Arrays.asList("javier@gluu.org", "javier.rojas.blum@gmail.com"));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setIdTokenSignedResponseAlg(SignatureAlgorithm.HS384);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenSignaturesHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest((BaseRequest)authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        TokenSignaturesHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        String idToken = authorizationResponse.getIdToken();
        Jwt jwt = Jwt.parse((String)idToken);
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        boolean validJwt = cryptoProvider.verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), null, null, clientSecret, SignatureAlgorithm.HS384);
        Assert.assertTrue((boolean)validJwt);
    }

    @Parameters(value={"redirectUris", "userId", "userSecret", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void requestAuthorizationIdTokenHS512(String redirectUris, String userId, String userSecret, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestAuthorizationIdTokenHS512");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setContacts(Arrays.asList("javier@gluu.org", "javier.rojas.blum@gmail.com"));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setIdTokenSignedResponseAlg(SignatureAlgorithm.HS512);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenSignaturesHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest request = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        request.setState(state);
        request.setAuthUsername(userId);
        request.setAuthPassword(userSecret);
        request.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest((BaseRequest)request);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        TokenSignaturesHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        String idToken = authorizationResponse.getIdToken();
        Jwt jwt = Jwt.parse((String)idToken);
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        boolean validJwt = cryptoProvider.verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), null, null, clientSecret, SignatureAlgorithm.HS512);
        Assert.assertTrue((boolean)validJwt);
    }

    @Parameters(value={"redirectUris", "userId", "userSecret", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void requestAuthorizationIdTokenRS256(String redirectUris, String userId, String userSecret, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestAuthorizationIdTokenRS256");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setContacts(Arrays.asList("javier@gluu.org", "javier.rojas.blum@gmail.com"));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setIdTokenSignedResponseAlg(SignatureAlgorithm.RS256);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenSignaturesHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest((BaseRequest)authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        TokenSignaturesHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        String idToken = authorizationResponse.getIdToken();
        Jwt jwt = Jwt.parse((String)idToken);
        String keyId = jwt.getHeader().getClaimAsString("kid");
        JwkClient jwkClient = new JwkClient(this.jwksUri);
        JwkResponse jwkResponse = jwkClient.exec();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        boolean validJwt = cryptoProvider.verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), keyId, jwkResponse.getJwks().toJSONObject(), null, SignatureAlgorithm.RS256);
        Assert.assertTrue((boolean)validJwt);
    }

    @Parameters(value={"redirectUris", "userId", "userSecret", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void requestAuthorizationIdTokenRS384(String redirectUris, String userId, String userSecret, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestAuthorizationIdTokenRS384");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setContacts(Arrays.asList("javier@gluu.org", "javier.rojas.blum@gmail.com"));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setIdTokenSignedResponseAlg(SignatureAlgorithm.RS384);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenSignaturesHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest((BaseRequest)authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        TokenSignaturesHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        String idToken = authorizationResponse.getIdToken();
        Jwt jwt = Jwt.parse((String)idToken);
        String keyId = jwt.getHeader().getClaimAsString("kid");
        JwkClient jwkClient = new JwkClient(this.jwksUri);
        JwkResponse jwkResponse = jwkClient.exec();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        boolean validJwt = cryptoProvider.verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), keyId, jwkResponse.getJwks().toJSONObject(), null, SignatureAlgorithm.RS384);
        Assert.assertTrue((boolean)validJwt);
    }

    @Parameters(value={"redirectUris", "userId", "userSecret", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void requestAuthorizationIdTokenRS512(String redirectUris, String userId, String userSecret, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestAuthorizationIdTokenRS512");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setContacts(Arrays.asList("javier@gluu.org", "javier.rojas.blum@gmail.com"));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setIdTokenSignedResponseAlg(SignatureAlgorithm.RS512);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenSignaturesHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest((BaseRequest)authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        TokenSignaturesHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        String idToken = authorizationResponse.getIdToken();
        Jwt jwt = Jwt.parse((String)idToken);
        String keyId = jwt.getHeader().getClaimAsString("kid");
        JwkClient jwkClient = new JwkClient(this.jwksUri);
        JwkResponse jwkResponse = jwkClient.exec();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        boolean validJwt = cryptoProvider.verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), keyId, jwkResponse.getJwks().toJSONObject(), null, SignatureAlgorithm.RS512);
        Assert.assertTrue((boolean)validJwt);
    }

    @Parameters(value={"redirectUris", "userId", "userSecret", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void requestAuthorizationIdTokenES256(String redirectUris, String userId, String userSecret, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestAuthorizationIdTokenES256");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setContacts(Arrays.asList("javier@gluu.org", "javier.rojas.blum@gmail.com"));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setIdTokenSignedResponseAlg(SignatureAlgorithm.ES256);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenSignaturesHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        String idToken = authorizationResponse.getIdToken();
        Jwt jwt = Jwt.parse((String)idToken);
        String keyId = jwt.getHeader().getClaimAsString("kid");
        JwkClient jwkClient = new JwkClient(this.jwksUri);
        JwkResponse jwkResponse = jwkClient.exec();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        boolean validJwt = cryptoProvider.verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), keyId, jwkResponse.getJwks().toJSONObject(), null, SignatureAlgorithm.ES256);
        Assert.assertTrue((boolean)validJwt);
    }

    @Parameters(value={"redirectUris", "userId", "userSecret", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void requestAuthorizationIdTokenES384(String redirectUris, String userId, String userSecret, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestAuthorizationIdTokenES384");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setContacts(Arrays.asList("javier@gluu.org", "javier.rojas.blum@gmail.com"));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setIdTokenSignedResponseAlg(SignatureAlgorithm.ES384);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenSignaturesHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        String idToken = authorizationResponse.getIdToken();
        Jwt jwt = Jwt.parse((String)idToken);
        String keyId = jwt.getHeader().getClaimAsString("kid");
        JwkClient jwkClient = new JwkClient(this.jwksUri);
        JwkResponse jwkResponse = jwkClient.exec();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        boolean validJwt = cryptoProvider.verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), keyId, jwkResponse.getJwks().toJSONObject(), null, SignatureAlgorithm.ES384);
        Assert.assertTrue((boolean)validJwt);
    }

    @Parameters(value={"redirectUris", "userId", "userSecret", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void requestAuthorizationIdTokenES512(String redirectUris, String userId, String userSecret, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestAuthorizationIdTokenES512");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setContacts(Arrays.asList("javier@gluu.org", "javier.rojas.blum@gmail.com"));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setIdTokenSignedResponseAlg(SignatureAlgorithm.ES512);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenSignaturesHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        String idToken = authorizationResponse.getIdToken();
        Jwt jwt = Jwt.parse((String)idToken);
        String keyId = jwt.getHeader().getClaimAsString("kid");
        JwkClient jwkClient = new JwkClient(this.jwksUri);
        JwkResponse jwkResponse = jwkClient.exec();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        boolean validJwt = cryptoProvider.verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), keyId, jwkResponse.getJwks().toJSONObject(), null, SignatureAlgorithm.ES512);
        Assert.assertTrue((boolean)validJwt);
    }

    @Test
    public void printAlgorithmsAndProviders() {
        this.showTitle("printAlgorithmsAndProviders");
        JwtUtil.printAlgorithmsAndProviders();
    }

    @Test
    public void hs256() throws InvalidKeyException, NoSuchAlgorithmException {
        try {
            this.showTitle("hs256");
            String signingInput = "eyJhbGciOiJIUzI1NiJ9.eyJub25jZSI6ICI2Qm9HN1QwR0RUZ2wiLCAiaWRfdG9rZW4iOiB7Im1heF9hZ2UiOiA4NjQwMH0sICJzdGF0ZSI6ICJTVEFURTAiLCAicmVkaXJlY3RfdXJpIjogImh0dHBzOi8vbG9jYWxob3N0L2NhbGxiYWNrMSIsICJ1c2VyaW5mbyI6IHsiY2xhaW1zIjogeyJuYW1lIjogbnVsbH19LCAiY2xpZW50X2lkIjogIkAhMTExMSEwMDA4IUU2NTQuQjQ2MCIsICJzY29wZSI6IFsib3BlbmlkIl0sICJyZXNwb25zZV90eXBlIjogWyJjb2RlIl19";
            String secret = "071d68a5-9eb0-47fb-8608-f54a0d9c8ede";
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
            String encodedSignature = cryptoProvider.sign(signingInput, null, secret, SignatureAlgorithm.HS256);
            System.out.println("Encoded Signature: " + encodedSignature);
            Assert.assertEquals((String)encodedSignature, (String)"BQwm1HCz0cjHYbulWMumkhZgyb2dD93uScXmC6Fv8Ik");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Test
    public void hs384() throws InvalidKeyException, NoSuchAlgorithmException {
        try {
            this.showTitle("hs384");
            String signingInput = "eyJhbGciOiJIUzI1NiJ9.eyJub25jZSI6ICI2Qm9HN1QwR0RUZ2wiLCAiaWRfdG9rZW4iOiB7Im1heF9hZ2UiOiA4NjQwMH0sICJzdGF0ZSI6ICJTVEFURTAiLCAicmVkaXJlY3RfdXJpIjogImh0dHBzOi8vbG9jYWxob3N0L2NhbGxiYWNrMSIsICJ1c2VyaW5mbyI6IHsiY2xhaW1zIjogeyJuYW1lIjogbnVsbH19LCAiY2xpZW50X2lkIjogIkAhMTExMSEwMDA4IUU2NTQuQjQ2MCIsICJzY29wZSI6IFsib3BlbmlkIl0sICJyZXNwb25zZV90eXBlIjogWyJjb2RlIl19";
            String secret = "071d68a5-9eb0-47fb-8608-f54a0d9c8ede";
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
            String encodedSignature = cryptoProvider.sign(signingInput, null, secret, SignatureAlgorithm.HS384);
            System.out.println("Encoded Signature: " + encodedSignature);
            Assert.assertEquals((String)encodedSignature, (String)"pe7gU1XxroqizSzucuHOor36L-M9_XPZ7KZcR6JW6xQAa2fmTLSDCc02fNER9atB");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Test
    public void hs512() throws InvalidKeyException, NoSuchAlgorithmException {
        try {
            this.showTitle("hs512");
            String signingInput = "eyJhbGciOiJIUzI1NiJ9.eyJub25jZSI6ICI2Qm9HN1QwR0RUZ2wiLCAiaWRfdG9rZW4iOiB7Im1heF9hZ2UiOiA4NjQwMH0sICJzdGF0ZSI6ICJTVEFURTAiLCAicmVkaXJlY3RfdXJpIjogImh0dHBzOi8vbG9jYWxob3N0L2NhbGxiYWNrMSIsICJ1c2VyaW5mbyI6IHsiY2xhaW1zIjogeyJuYW1lIjogbnVsbH19LCAiY2xpZW50X2lkIjogIkAhMTExMSEwMDA4IUU2NTQuQjQ2MCIsICJzY29wZSI6IFsib3BlbmlkIl0sICJyZXNwb25zZV90eXBlIjogWyJjb2RlIl19";
            String secret = "071d68a5-9eb0-47fb-8608-f54a0d9c8ede";
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
            String encodedSignature = cryptoProvider.sign(signingInput, null, secret, SignatureAlgorithm.HS512);
            System.out.println("Encoded Signature: " + encodedSignature);
            Assert.assertEquals((String)encodedSignature, (String)"IZsXiRrRfP9eNFj6snm_MGEnrtfvX8vOF43Z-FuFkRj29y0WUaPR50IXRDI5uGatJvVdr_i7eJCJ4N_EwwrIhQ");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Parameters(value={"clientJwksUri", "RS256_keyId", "dnName", "keyStoreFile", "keyStoreSecret"})
    @Test
    public void testRS256(String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret) throws NoSuchProviderException, NoSuchAlgorithmException, SignatureException, InvalidKeyException, InvalidKeySpecException, IllegalBlockSizeException, IOException, NoSuchPaddingException, BadPaddingException {
        try {
            this.showTitle("Test RS256");
            JwkClient jwkClient = new JwkClient(clientJwksUri);
            JwkResponse jwkResponse = jwkClient.exec();
            String signingInput = "eyJhbGciOiJIUzI1NiJ9.eyJub25jZSI6ICI2Qm9HN1QwR0RUZ2wiLCAiaWRfdG9rZW4iOiB7Im1heF9hZ2UiOiA4NjQwMH0sICJzdGF0ZSI6ICJTVEFURTAiLCAicmVkaXJlY3RfdXJpIjogImh0dHBzOi8vbG9jYWxob3N0L2NhbGxiYWNrMSIsICJ1c2VyaW5mbyI6IHsiY2xhaW1zIjogeyJuYW1lIjogbnVsbH19LCAiY2xpZW50X2lkIjogIkAhMTExMSEwMDA4IUU2NTQuQjQ2MCIsICJzY29wZSI6IFsib3BlbmlkIl0sICJyZXNwb25zZV90eXBlIjogWyJjb2RlIl19";
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
            String encodedSignature = cryptoProvider.sign(signingInput, keyId, null, SignatureAlgorithm.RS256);
            System.out.println("Encoded Signature: " + encodedSignature);
            boolean signatureVerified = cryptoProvider.verifySignature(signingInput, encodedSignature, keyId, jwkResponse.getJwks().toJSONObject(), null, SignatureAlgorithm.RS256);
            Assert.assertTrue((boolean)signatureVerified, (String)"Invalid signature");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Parameters(value={"clientJwksUri", "RS384_keyId", "dnName", "keyStoreFile", "keyStoreSecret"})
    @Test
    public void testRS384(String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret) throws NoSuchProviderException, NoSuchAlgorithmException, SignatureException, InvalidKeyException, InvalidKeySpecException, IllegalBlockSizeException, IOException, NoSuchPaddingException, BadPaddingException {
        try {
            this.showTitle("Test RS384");
            JwkClient jwkClient = new JwkClient(clientJwksUri);
            JwkResponse jwkResponse = jwkClient.exec();
            String signingInput = "eyJhbGciOiJIUzI1NiJ9.eyJub25jZSI6ICI2Qm9HN1QwR0RUZ2wiLCAiaWRfdG9rZW4iOiB7Im1heF9hZ2UiOiA4NjQwMH0sICJzdGF0ZSI6ICJTVEFURTAiLCAicmVkaXJlY3RfdXJpIjogImh0dHBzOi8vbG9jYWxob3N0L2NhbGxiYWNrMSIsICJ1c2VyaW5mbyI6IHsiY2xhaW1zIjogeyJuYW1lIjogbnVsbH19LCAiY2xpZW50X2lkIjogIkAhMTExMSEwMDA4IUU2NTQuQjQ2MCIsICJzY29wZSI6IFsib3BlbmlkIl0sICJyZXNwb25zZV90eXBlIjogWyJjb2RlIl19";
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
            String encodedSignature = cryptoProvider.sign(signingInput, keyId, null, SignatureAlgorithm.RS384);
            System.out.println("Encoded Signature: " + encodedSignature);
            boolean signatureVerified = cryptoProvider.verifySignature(signingInput, encodedSignature, keyId, jwkResponse.getJwks().toJSONObject(), null, SignatureAlgorithm.RS384);
            Assert.assertTrue((boolean)signatureVerified, (String)"Invalid signature");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Parameters(value={"clientJwksUri", "RS512_keyId", "dnName", "keyStoreFile", "keyStoreSecret"})
    @Test
    public void testRS512(String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret) throws NoSuchProviderException, NoSuchAlgorithmException, SignatureException, InvalidKeyException, InvalidKeySpecException, IllegalBlockSizeException, IOException, NoSuchPaddingException, BadPaddingException {
        try {
            this.showTitle("Test RS512");
            JwkClient jwkClient = new JwkClient(clientJwksUri);
            JwkResponse jwkResponse = jwkClient.exec();
            String signingInput = "eyJhbGciOiJIUzI1NiJ9.eyJub25jZSI6ICI2Qm9HN1QwR0RUZ2wiLCAiaWRfdG9rZW4iOiB7Im1heF9hZ2UiOiA4NjQwMH0sICJzdGF0ZSI6ICJTVEFURTAiLCAicmVkaXJlY3RfdXJpIjogImh0dHBzOi8vbG9jYWxob3N0L2NhbGxiYWNrMSIsICJ1c2VyaW5mbyI6IHsiY2xhaW1zIjogeyJuYW1lIjogbnVsbH19LCAiY2xpZW50X2lkIjogIkAhMTExMSEwMDA4IUU2NTQuQjQ2MCIsICJzY29wZSI6IFsib3BlbmlkIl0sICJyZXNwb25zZV90eXBlIjogWyJjb2RlIl19";
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
            String encodedSignature = cryptoProvider.sign(signingInput, keyId, null, SignatureAlgorithm.RS512);
            System.out.println("Encoded Signature: " + encodedSignature);
            boolean signatureVerified = cryptoProvider.verifySignature(signingInput, encodedSignature, keyId, jwkResponse.getJwks().toJSONObject(), null, SignatureAlgorithm.RS512);
            Assert.assertTrue((boolean)signatureVerified, (String)"Invalid signature");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Parameters(value={"clientJwksUri", "ES256_keyId", "dnName", "keyStoreFile", "keyStoreSecret"})
    @Test
    public void testES256(String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, SignatureException, InvalidKeyException, InvalidKeySpecException, IllegalBlockSizeException, IOException, NoSuchPaddingException, BadPaddingException {
        try {
            this.showTitle("Test ES256");
            JwkClient jwkClient = new JwkClient(clientJwksUri);
            JwkResponse jwkResponse = jwkClient.exec();
            String signingInput = "eyJhbGciOiJIUzI1NiJ9.eyJub25jZSI6ICI2Qm9HN1QwR0RUZ2wiLCAiaWRfdG9rZW4iOiB7Im1heF9hZ2UiOiA4NjQwMH0sICJzdGF0ZSI6ICJTVEFURTAiLCAicmVkaXJlY3RfdXJpIjogImh0dHBzOi8vbG9jYWxob3N0L2NhbGxiYWNrMSIsICJ1c2VyaW5mbyI6IHsiY2xhaW1zIjogeyJuYW1lIjogbnVsbH19LCAiY2xpZW50X2lkIjogIkAhMTExMSEwMDA4IUU2NTQuQjQ2MCIsICJzY29wZSI6IFsib3BlbmlkIl0sICJyZXNwb25zZV90eXBlIjogWyJjb2RlIl19";
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
            String encodedSignature = cryptoProvider.sign(signingInput, keyId, null, SignatureAlgorithm.ES256);
            System.out.println("Encoded Signature: " + encodedSignature);
            boolean signatureVerified = cryptoProvider.verifySignature(signingInput, encodedSignature, keyId, jwkResponse.getJwks().toJSONObject(), null, SignatureAlgorithm.ES256);
            Assert.assertTrue((boolean)signatureVerified, (String)"Invalid signature");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Parameters(value={"clientJwksUri", "ES384_keyId", "dnName", "keyStoreFile", "keyStoreSecret"})
    @Test
    public void testES384(String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, SignatureException, InvalidKeyException, InvalidKeySpecException, IllegalBlockSizeException, IOException, NoSuchPaddingException, BadPaddingException {
        try {
            this.showTitle("Test ES384");
            JwkClient jwkClient = new JwkClient(clientJwksUri);
            JwkResponse jwkResponse = jwkClient.exec();
            String signingInput = "eyJhbGciOiJIUzI1NiJ9.eyJub25jZSI6ICI2Qm9HN1QwR0RUZ2wiLCAiaWRfdG9rZW4iOiB7Im1heF9hZ2UiOiA4NjQwMH0sICJzdGF0ZSI6ICJTVEFURTAiLCAicmVkaXJlY3RfdXJpIjogImh0dHBzOi8vbG9jYWxob3N0L2NhbGxiYWNrMSIsICJ1c2VyaW5mbyI6IHsiY2xhaW1zIjogeyJuYW1lIjogbnVsbH19LCAiY2xpZW50X2lkIjogIkAhMTExMSEwMDA4IUU2NTQuQjQ2MCIsICJzY29wZSI6IFsib3BlbmlkIl0sICJyZXNwb25zZV90eXBlIjogWyJjb2RlIl19";
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
            String encodedSignature = cryptoProvider.sign(signingInput, keyId, null, SignatureAlgorithm.ES384);
            System.out.println("Encoded Signature: " + encodedSignature);
            boolean signatureVerified = cryptoProvider.verifySignature(signingInput, encodedSignature, keyId, jwkResponse.getJwks().toJSONObject(), null, SignatureAlgorithm.ES384);
            Assert.assertTrue((boolean)signatureVerified, (String)"Invalid signature");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Parameters(value={"clientJwksUri", "ES512_keyId", "dnName", "keyStoreFile", "keyStoreSecret"})
    @Test
    public void testES512(String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, SignatureException, InvalidKeyException, InvalidKeySpecException, IllegalBlockSizeException, IOException, NoSuchPaddingException, BadPaddingException {
        try {
            this.showTitle("Test ES512");
            JwkClient jwkClient = new JwkClient(clientJwksUri);
            JwkResponse jwkResponse = jwkClient.exec();
            String signingInput = "eyJhbGciOiJIUzI1NiJ9.eyJub25jZSI6ICI2Qm9HN1QwR0RUZ2wiLCAiaWRfdG9rZW4iOiB7Im1heF9hZ2UiOiA4NjQwMH0sICJzdGF0ZSI6ICJTVEFURTAiLCAicmVkaXJlY3RfdXJpIjogImh0dHBzOi8vbG9jYWxob3N0L2NhbGxiYWNrMSIsICJ1c2VyaW5mbyI6IHsiY2xhaW1zIjogeyJuYW1lIjogbnVsbH19LCAiY2xpZW50X2lkIjogIkAhMTExMSEwMDA4IUU2NTQuQjQ2MCIsICJzY29wZSI6IFsib3BlbmlkIl0sICJyZXNwb25zZV90eXBlIjogWyJjb2RlIl19";
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
            String encodedSignature = cryptoProvider.sign(signingInput, keyId, null, SignatureAlgorithm.ES512);
            System.out.println("Encoded Signature: " + encodedSignature);
            boolean signatureVerified = cryptoProvider.verifySignature(signingInput, encodedSignature, keyId, jwkResponse.getJwks().toJSONObject(), null, SignatureAlgorithm.ES512);
            Assert.assertTrue((boolean)signatureVerified, (String)"Invalid signature");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Test
    public void getMessageDigestSHA256() {
        this.showTitle("sha256");
        try {
            String input = "The quick brown fox jumps over the lazy dog";
            System.out.println("Input: " + input);
            byte[] digest = JwtUtil.getMessageDigestSHA256((String)input);
            BigInteger result = new BigInteger(1, digest);
            BigInteger expectedResult = new BigInteger("d7a8fbb307d7809469ca9abcb0082e4f8d5651e46d3cdb762d02d0bf37c9e592", 16);
            System.out.println("Result  : " + result);
            System.out.println("Expected: " + expectedResult);
            Assert.assertEquals((Object)result, (Object)expectedResult);
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void getMessageDigestSHA384() {
        this.showTitle("sha384");
        try {
            String input = "The quick brown fox jumps over the lazy dog";
            System.out.println("Input: " + input);
            byte[] digest = JwtUtil.getMessageDigestSHA384((String)input);
            BigInteger result = new BigInteger(1, digest);
            BigInteger expectedResult = new BigInteger("ca737f1014a48f4c0b6dd43cb177b0afd9e5169367544c494011e3317dbf9a509cb1e5dc1e85a941bbee3d7f2afbc9b1", 16);
            System.out.println("Result   : " + result);
            System.out.println("Expected : " + expectedResult);
            Assert.assertEquals((Object)result, (Object)expectedResult);
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void getMessageDigestSHA512() {
        this.showTitle("sha512");
        try {
            String input = "The quick brown fox jumps over the lazy dog";
            System.out.println("Input: " + input);
            byte[] digest = JwtUtil.getMessageDigestSHA512((String)input);
            BigInteger result = new BigInteger(1, digest);
            BigInteger expectedResult = new BigInteger("07e547d9586f6a73f73fbac0435ed76951218fb7d0c8d788a309d785436bbb642e93a252a954f23912547d1e8a3b5ed6e1bfd7097821233fa0538f3db854fee6", 16);
            System.out.println("Result   : " + result);
            System.out.println("Expected : " + expectedResult);
            Assert.assertEquals((Object)result, (Object)expectedResult);
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

