/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.BaseRequest;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.client.TokenClient;
import org.xdi.oxauth.client.TokenRequest;
import org.xdi.oxauth.client.TokenResponse;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.crypto.AbstractCryptoProvider;
import org.xdi.oxauth.model.crypto.OxAuthCryptoProvider;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.register.RegisterRequestParam;
import org.xdi.oxauth.model.util.StringUtils;

public class TokenEndpointAuthMethodRestrictionHttpTest
extends BaseTest {
    @Parameters(value={"redirectUris", "sectorIdentifierUri"})
    @Test
    public void omittedTokenEndpointAuthMethod(String redirectUris, String sectorIdentifierUri) throws Exception {
        this.showTitle("omittedTokenEndpointAuthMethod");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_BASIC.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodClientSecretBasic(String redirectUris, String redirectUri, String userId, String userSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodClientSecretBasic");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_BASIC.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)tokenResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken(), (String)"The refresh token is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodClientSecretBasicFail1(String redirectUris, String redirectUri, String userId, String userSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodClientSecretBasicFail1");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_BASIC.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodClientSecretBasicFail2(String redirectUris, String redirectUri, String userId, String userSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodClientSecretBasicFail2");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_BASIC.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "RS256_keyId", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodClientSecretBasicFail3(String redirectUris, String redirectUri, String userId, String userSecret, String keyId, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodClientSecretBasicFail3");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_BASIC.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, null);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS256);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodClientSecretPost(String redirectUris, String redirectUri, String userId, String userSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodClientSecretPost");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_POST.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)tokenResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken(), (String)"The refresh token is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodClientSecretPostFail1(String redirectUris, String redirectUri, String userId, String userSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodClientSecretPostFail1");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_POST.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodClientSecretPostFail2(String redirectUris, String redirectUri, String userId, String userSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodClientSecretPostFail2");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_POST.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "RS256_keyId", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodClientSecretPostFail3(String redirectUris, String redirectUri, String userId, String userSecret, String keyId, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodClientSecretPostFail3");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_POST.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, null);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS256);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodClientSecretJwt(String redirectUris, String redirectUri, String userId, String userSecret, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodClientSecretJwt");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_JWT.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)tokenResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken(), (String)"The refresh token is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodClientSecretJwtHS256(String redirectUris, String redirectUri, String userId, String userSecret, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodClientSecretJwtHS256");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_JWT.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.HS256);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)tokenResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken(), (String)"The refresh token is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodClientSecretJwtHS384(String redirectUris, String redirectUri, String userId, String userSecret, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodClientSecretJwtHS384");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_JWT.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.HS384);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)tokenResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken(), (String)"The refresh token is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodClientSecretJwtHS512(String redirectUris, String redirectUri, String userId, String userSecret, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodClientSecretJwtHS512");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_JWT.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.HS512);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)tokenResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken(), (String)"The refresh token is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "dnName", "keyStoreFile", "keyStoreSecret", "RS256_keyId", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodClientSecretJwtRS256Fail(String redirectUris, String redirectUri, String userId, String userSecret, String dnName, String keyStoreFile, String keyStoreSecret, String keyId, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodClientSecretJwtRS256Fail");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_JWT.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS256);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "dnName", "keyStoreFile", "keyStoreSecret", "RS384_keyId", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodClientSecretJwtRS384Fail(String redirectUris, String redirectUri, String userId, String userSecret, String dnName, String keyStoreFile, String keyStoreSecret, String keyId, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodClientSecretJwtRS384Fail");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_JWT.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS384);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "dnName", "keyStoreFile", "keyStoreSecret", "RS512_keyId", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodClientSecretJwtRS512Fail(String redirectUris, String redirectUri, String userId, String userSecret, String dnName, String keyStoreFile, String keyStoreSecret, String keyId, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodClientSecretJwtRS512Fail");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_JWT.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS512);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "dnName", "keyStoreFile", "keyStoreSecret", "ES256_keyId", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodClientSecretJwtES256Fail(String redirectUris, String redirectUri, String userId, String userSecret, String dnName, String keyStoreFile, String keyStoreSecret, String keyId, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodClientSecretJwtES256Fail");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_JWT.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.ES256);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "dnName", "keyStoreFile", "keyStoreSecret", "ES384_keyId", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodClientSecretJwtES384Fail(String redirectUris, String redirectUri, String userId, String userSecret, String dnName, String keyStoreFile, String keyStoreSecret, String keyId, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodClientSecretJwtES384Fail");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_JWT.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.ES384);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "dnName", "keyStoreFile", "keyStoreSecret", "ES512_keyId", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodClientSecretJwtES512Fail(String redirectUris, String redirectUri, String userId, String userSecret, String dnName, String keyStoreFile, String keyStoreSecret, String keyId, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodClientSecretJwtES512Fail");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_JWT.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.ES512);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodClientSecretJwtSigningAlgHS256(String redirectUris, String redirectUri, String userId, String userSecret, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodClientSecretJwtSigningAlgHS256");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.HS256);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.HS256.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.HS256);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)tokenResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken(), (String)"The refresh token is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodClientSecretJwtSigningAlgHS256Fail1(String redirectUris, String redirectUri, String userId, String userSecret, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodClientSecretJwtSigningAlgHS256Fail1");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.HS256);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.HS256.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.HS384);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodClientSecretJwtSigningAlgHS256Fail2(String redirectUris, String redirectUri, String userId, String userSecret, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodClientSecretJwtSigningAlgHS256Fail2");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.HS256);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.HS256.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.HS512);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodClientSecretJwtSigningAlgHS384(String redirectUris, String redirectUri, String userId, String userSecret, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodClientSecretJwtSigningAlgHS384");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.HS384);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.HS384.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.HS384);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)tokenResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken(), (String)"The refresh token is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodClientSecretJwtSigningAlgHS384Fail1(String redirectUris, String redirectUri, String userId, String userSecret, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodClientSecretJwtSigningAlgHS384Fail1");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.HS384);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.HS384.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.HS256);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodClientSecretJwtSigningAlgHS384Fail2(String redirectUris, String redirectUri, String userId, String userSecret, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodClientSecretJwtSigningAlgHS384Fail2");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.HS384);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.HS384.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.HS512);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodClientSecretJwtSigningAlgHS512(String redirectUris, String redirectUri, String userId, String userSecret, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodClientSecretJwtSigningAlgHS512");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.HS512);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.HS512.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.HS512);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)tokenResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken(), (String)"The refresh token is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodClientSecretJwtSigningAlgHS512Fail1(String redirectUris, String redirectUri, String userId, String userSecret, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodClientSecretJwtSigningAlgHS512Fail1");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.HS512);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.HS512.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.HS256);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodClientSecretJwtSigningAlgHS512Fail2(String redirectUris, String redirectUri, String userId, String userSecret, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodClientSecretJwtSigningAlgHS512Fail2");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.HS512);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.HS512.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.HS384);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodClientSecretJwtFail1(String redirectUris, String redirectUri, String userId, String userSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodClientSecretJwtFail1");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_JWT.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodClientSecretJwtFail2(String redirectUris, String redirectUri, String userId, String userSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodClientSecretJwtFail2");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_JWT.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "RS256_keyId", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodClientSecretJwtFail3(String redirectUris, String redirectUri, String userId, String userSecret, String keyId, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodClientSecretJwtFail3");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_JWT.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, null);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS256);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "RS256_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwt(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwt");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS256);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)tokenResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken(), (String)"The refresh token is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtFail1(String redirectUris, String redirectUri, String userId, String userSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtFail1");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setJwksUri(this.jwksUri);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtFail2(String redirectUris, String redirectUri, String userId, String userSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtFail2");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setJwksUri(this.jwksUri);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtFail3(String redirectUris, String redirectUri, String userId, String userSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtFail3");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setJwksUri(this.jwksUri);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "RS256_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtRS256(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtRS256");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS256);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)tokenResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken(), (String)"The refresh token is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "RS384_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtRS384(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtRS384");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS384);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)tokenResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken(), (String)"The refresh token is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "RS512_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtRS512(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtRS512");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS512);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)tokenResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken(), (String)"The refresh token is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "ES256_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtES256(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtES256");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.ES256);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)tokenResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken(), (String)"The refresh token is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "ES384_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtES384(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtES384");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.ES384);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)tokenResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken(), (String)"The refresh token is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "ES512_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtES512(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtES512");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.ES512);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)tokenResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken(), (String)"The refresh token is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "RS256_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtSigningAlgRS256(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtSigningAlgRS256");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.RS256);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.RS256.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS256);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)tokenResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken(), (String)"The refresh token is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "RS384_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtSigningAlgRS256Fail1(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtSigningAlgRS256Fail1");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.RS256);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.RS256.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS384);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "RS512_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtSigningAlgRS256Fail2(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtSigningAlgRS256Fail2");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.RS256);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.RS256.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS512);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "ES256_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtSigningAlgRS256Fail3(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtSigningAlgRS256Fail3");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.RS256);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.RS256.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.ES256);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "ES384_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtSigningAlgRS256Fail4(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtSigningAlgRS256Fail4");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.RS256);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.RS256.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.ES384);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "ES512_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtSigningAlgRS256Fail5(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtSigningAlgRS256Fail5");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.RS256);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.RS256.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.ES512);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "RS384_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtSigningAlgRS384(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtSigningAlgRS384");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.RS384);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.RS384.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS384);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)tokenResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken(), (String)"The refresh token is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "RS256_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtSigningAlgRS384Fail1(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtSigningAlgRS384Fail1");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.RS384);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.RS384.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS256);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "RS512_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtSigningAlgRS384Fail2(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtSigningAlgRS384Fail2");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.RS384);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.RS384.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS512);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "ES256_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtSigningAlgRS384Fail3(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtSigningAlgRS384Fail3");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.RS384);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.RS384.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.ES256);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "ES384_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtSigningAlgRS384Fail4(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtSigningAlgRS384Fail4");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.RS384);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.RS384.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.ES384);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "ES512_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtSigningAlgRS384Fail5(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtSigningAlgRS384Fail5");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.RS384);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.RS384.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.ES512);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "RS512_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtSigningAlgRS512(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtSigningAlgRS512");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.RS512);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.RS512.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS512);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)tokenResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken(), (String)"The refresh token is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "RS256_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtSigningAlgRS512Fail1(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtSigningAlgRS512Fail1");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.RS512);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.RS512.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS256);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "RS384_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtSigningAlgRS512Fail2(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtSigningAlgRS512Fail2");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.RS512);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.RS512.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS384);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "ES256_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtSigningAlgRS512Fail3(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtSigningAlgRS512Fail3");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.RS512);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.RS512.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.ES256);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "ES384_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtSigningAlgRS512Fail4(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtSigningAlgRS512Fail4");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.RS512);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.RS512.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.ES384);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "ES512_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtSigningAlgRS512Fail5(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtSigningAlgRS512Fail5");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.RS512);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.RS512.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.ES512);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "ES256_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtSigningAlgES256(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtSigningAlgES256");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.ES256);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.ES256.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.ES256);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)tokenResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken(), (String)"The refresh token is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "RS256_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtSigningAlgES256Fail1(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtSigningAlgES256Fail1");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.ES256);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.ES256.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS256);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "RS384_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtSigningAlgES256Fail2(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtSigningAlgES256Fail2");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.ES256);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.ES256.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS384);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "RS512_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtSigningAlgES256Fail3(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtSigningAlgES256Fail3");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.ES256);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.ES256.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS512);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "ES384_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtSigningAlgES256Fail4(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtSigningAlgES256Fail4");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.ES256);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.ES256.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.ES384);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "ES512_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtSigningAlgES256Fail5(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtSigningAlgES256Fail5");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.ES256);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.ES256.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.ES512);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "ES384_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtSigningAlgES384(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtSigningAlgES384");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.ES384);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.ES384.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.ES384);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)tokenResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken(), (String)"The refresh token is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "RS256_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtSigningAlgES384Fail1(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtSigningAlgES384Fail1");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.ES384);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.ES384.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS256);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "RS384_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtSigningAlgES384Fail2(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtSigningAlgES384Fail2");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.ES384);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.ES384.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS384);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "RS512_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtSigningAlgES384Fail3(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtSigningAlgES384Fail3");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.ES384);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.ES384.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS512);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "ES256_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtSigningAlgES384Fail4(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtSigningAlgES384Fail4");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.ES384);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.ES384.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.ES256);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "ES512_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtSigningAlgES384Fail5(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtSigningAlgES384Fail5");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.ES384);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.ES384.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.ES512);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "ES512_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtSigningAlgES512(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtSigningAlgES512");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.ES512);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.ES512.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.ES512);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)tokenResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken(), (String)"The refresh token is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "RS256_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtSigningAlgES512Fail1(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtSigningAlgES512Fail1");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.ES512);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.ES512.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS256);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "RS384_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtSigningAlgES512Fail2(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtSigningAlgES512Fail2");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.ES512);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.ES512.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS384);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "RS512_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtSigningAlgES512Fail3(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtSigningAlgES512Fail3");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.ES512);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.ES512.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS512);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "ES256_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtSigningAlgES512Fail4(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtSigningAlgES512Fail4");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.ES512);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.ES512.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.ES256);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "ES384_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtSigningAlgES512Fail5(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtSigningAlgES512Fail5");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.ES512);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())), (String)SignatureAlgorithm.ES512.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.ES384);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }
}

