/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import java.security.PrivateKey;
import java.util.Arrays;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.BaseRequest;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.client.TokenClient;
import org.xdi.oxauth.client.TokenRequest;
import org.xdi.oxauth.client.TokenResponse;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.crypto.OxAuthCryptoProvider;
import org.xdi.oxauth.model.crypto.encryption.BlockEncryptionAlgorithm;
import org.xdi.oxauth.model.crypto.encryption.KeyEncryptionAlgorithm;
import org.xdi.oxauth.model.jwe.Jwe;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.util.StringUtils;

public class TokenEncryptionHttpTest
extends BaseTest {
    @Parameters(value={"userId", "userSecret", "redirectUris", "clientJwksUri", "RS256_enc_keyId", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void requestIdTokenAlgRSAOAEPEncA256GCM(String userId, String userSecret, String redirectUris, String jwksUri, String keyId, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) {
        try {
            this.showTitle("requestIdTokenAlgRSAOAEPEncA256GCM");
            List<GrantType> grantTypes = Arrays.asList(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setJwksUri(jwksUri);
            registerRequest.setIdTokenEncryptedResponseAlg(KeyEncryptionAlgorithm.RSA_OAEP);
            registerRequest.setIdTokenEncryptedResponseEnc(BlockEncryptionAlgorithm.A256GCM);
            registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
            registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
            registerRequest.setGrantTypes(grantTypes);
            RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
            registerClient.setRequest((BaseRequest)registerRequest);
            RegisterResponse response = registerClient.exec();
            TokenEncryptionHttpTest.showClient((BaseClient)registerClient);
            Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
            Assert.assertNotNull((Object)response.getClientId());
            Assert.assertNotNull((Object)response.getClientSecret());
            Assert.assertNotNull((Object)response.getRegistrationAccessToken());
            Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
            String clientId = response.getClientId();
            String clientSecret = response.getClientSecret();
            TokenRequest tokenRequest = new TokenRequest(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
            tokenRequest.setUsername(userId);
            tokenRequest.setPassword(userSecret);
            tokenRequest.setScope("openid");
            tokenRequest.setAuthUsername(clientId);
            tokenRequest.setAuthPassword(clientSecret);
            TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
            tokenClient.setRequest((BaseRequest)tokenRequest);
            TokenResponse tokenResponse = tokenClient.exec();
            TokenEncryptionHttpTest.showClient((BaseClient)tokenClient);
            Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
            Assert.assertNotNull((Object)tokenResponse.getEntity(), (String)"The entity is null");
            Assert.assertNotNull((Object)tokenResponse.getAccessToken(), (String)"The access token is null");
            Assert.assertNotNull((Object)tokenResponse.getTokenType(), (String)"The token type is null");
            Assert.assertNotNull((Object)tokenResponse.getRefreshToken(), (String)"The refresh token is null");
            Assert.assertNotNull((Object)tokenResponse.getScope(), (String)"The scope is null");
            Assert.assertNotNull((Object)tokenResponse.getIdToken(), (String)"The id token is null");
            String idToken = tokenResponse.getIdToken();
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, null);
            PrivateKey privateKey = cryptoProvider.getPrivateKey(keyId);
            Jwe jwe = Jwe.parse((String)idToken, (PrivateKey)privateKey, null);
            Assert.assertNotNull((Object)jwe.getHeader().getClaimAsString("typ"));
            Assert.assertNotNull((Object)jwe.getHeader().getClaimAsString("alg"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("iss"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("aud"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("exp"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("iat"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("sub"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("oxOpenIDConnectVersion"));
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage(), (Throwable)ex);
        }
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "clientJwksUri", "RS256_enc_keyId", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void requestIdTokenAlgRSA15EncA128CBCPLUSHS256(String userId, String userSecret, String redirectUris, String jwksUri, String keyId, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) {
        try {
            this.showTitle("requestIdTokenAlgRSA15EncA128CBCPLUSHS256");
            List<GrantType> grantTypes = Arrays.asList(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setJwksUri(jwksUri);
            registerRequest.setIdTokenEncryptedResponseAlg(KeyEncryptionAlgorithm.RSA1_5);
            registerRequest.setIdTokenEncryptedResponseEnc(BlockEncryptionAlgorithm.A128CBC_PLUS_HS256);
            registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
            registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
            registerRequest.setGrantTypes(grantTypes);
            RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
            registerClient.setRequest((BaseRequest)registerRequest);
            RegisterResponse response = registerClient.exec();
            TokenEncryptionHttpTest.showClient((BaseClient)registerClient);
            Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
            Assert.assertNotNull((Object)response.getClientId());
            Assert.assertNotNull((Object)response.getClientSecret());
            Assert.assertNotNull((Object)response.getRegistrationAccessToken());
            Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
            String clientId = response.getClientId();
            String clientSecret = response.getClientSecret();
            TokenRequest tokenRequest = new TokenRequest(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
            tokenRequest.setUsername(userId);
            tokenRequest.setPassword(userSecret);
            tokenRequest.setScope("openid");
            tokenRequest.setAuthUsername(clientId);
            tokenRequest.setAuthPassword(clientSecret);
            TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
            tokenClient.setRequest((BaseRequest)tokenRequest);
            TokenResponse tokenResponse = tokenClient.exec();
            TokenEncryptionHttpTest.showClient((BaseClient)tokenClient);
            Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
            Assert.assertNotNull((Object)tokenResponse.getEntity(), (String)"The entity is null");
            Assert.assertNotNull((Object)tokenResponse.getAccessToken(), (String)"The access token is null");
            Assert.assertNotNull((Object)tokenResponse.getTokenType(), (String)"The token type is null");
            Assert.assertNotNull((Object)tokenResponse.getRefreshToken(), (String)"The refresh token is null");
            Assert.assertNotNull((Object)tokenResponse.getScope(), (String)"The scope is null");
            Assert.assertNotNull((Object)tokenResponse.getIdToken(), (String)"The id token is null");
            String idToken = tokenResponse.getIdToken();
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, null);
            PrivateKey privateKey = cryptoProvider.getPrivateKey(keyId);
            Jwe jwe = Jwe.parse((String)idToken, (PrivateKey)privateKey, null);
            Assert.assertNotNull((Object)jwe.getHeader().getClaimAsString("typ"));
            Assert.assertNotNull((Object)jwe.getHeader().getClaimAsString("alg"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("iss"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("aud"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("exp"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("iat"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("sub"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("oxOpenIDConnectVersion"));
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage(), (Throwable)ex);
        }
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "clientJwksUri", "RS256_enc_keyId", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void requestIdTokenAlgRSA15EncA256CBCPLUSHS512(String userId, String userSecret, String redirectUris, String jwksUri, String keyId, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) {
        try {
            this.showTitle("requestIdTokenAlgRSA15EncA256CBCPLUSHS512");
            List<GrantType> grantTypes = Arrays.asList(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setJwksUri(jwksUri);
            registerRequest.setIdTokenEncryptedResponseAlg(KeyEncryptionAlgorithm.RSA1_5);
            registerRequest.setIdTokenEncryptedResponseEnc(BlockEncryptionAlgorithm.A256CBC_PLUS_HS512);
            registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
            registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
            registerRequest.setGrantTypes(grantTypes);
            RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
            registerClient.setRequest((BaseRequest)registerRequest);
            RegisterResponse response = registerClient.exec();
            TokenEncryptionHttpTest.showClient((BaseClient)registerClient);
            Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
            Assert.assertNotNull((Object)response.getClientId());
            Assert.assertNotNull((Object)response.getClientSecret());
            Assert.assertNotNull((Object)response.getRegistrationAccessToken());
            Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
            String clientId = response.getClientId();
            String clientSecret = response.getClientSecret();
            TokenRequest tokenRequest = new TokenRequest(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
            tokenRequest.setUsername(userId);
            tokenRequest.setPassword(userSecret);
            tokenRequest.setScope("openid");
            tokenRequest.setAuthUsername(clientId);
            tokenRequest.setAuthPassword(clientSecret);
            TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
            tokenClient.setRequest((BaseRequest)tokenRequest);
            TokenResponse tokenResponse = tokenClient.exec();
            TokenEncryptionHttpTest.showClient((BaseClient)tokenClient);
            Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
            Assert.assertNotNull((Object)tokenResponse.getEntity(), (String)"The entity is null");
            Assert.assertNotNull((Object)tokenResponse.getAccessToken(), (String)"The access token is null");
            Assert.assertNotNull((Object)tokenResponse.getTokenType(), (String)"The token type is null");
            Assert.assertNotNull((Object)tokenResponse.getRefreshToken(), (String)"The refresh token is null");
            Assert.assertNotNull((Object)tokenResponse.getScope(), (String)"The scope is null");
            Assert.assertNotNull((Object)tokenResponse.getIdToken(), (String)"The id token is null");
            String idToken = tokenResponse.getIdToken();
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, null);
            PrivateKey privateKey = cryptoProvider.getPrivateKey(keyId);
            Jwe jwe = Jwe.parse((String)idToken, (PrivateKey)privateKey, null);
            Assert.assertNotNull((Object)jwe.getHeader().getClaimAsString("typ"));
            Assert.assertNotNull((Object)jwe.getHeader().getClaimAsString("alg"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("iss"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("aud"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("exp"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("iat"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("sub"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("oxOpenIDConnectVersion"));
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage(), (Throwable)ex);
        }
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "sectorIdentifierUri"})
    @Test
    public void requestIdTokenAlgA128KWEncA128GCM(String userId, String userSecret, String redirectUris, String sectorIdentifierUri) {
        try {
            this.showTitle("requestIdTokenAlgA128KWEncA128GCM");
            List<GrantType> grantTypes = Arrays.asList(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setIdTokenEncryptedResponseAlg(KeyEncryptionAlgorithm.A128KW);
            registerRequest.setIdTokenEncryptedResponseEnc(BlockEncryptionAlgorithm.A128GCM);
            registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
            registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
            registerRequest.setGrantTypes(grantTypes);
            RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
            registerClient.setRequest((BaseRequest)registerRequest);
            RegisterResponse response = registerClient.exec();
            TokenEncryptionHttpTest.showClient((BaseClient)registerClient);
            Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
            Assert.assertNotNull((Object)response.getClientId());
            Assert.assertNotNull((Object)response.getClientSecret());
            Assert.assertNotNull((Object)response.getRegistrationAccessToken());
            Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
            String clientId = response.getClientId();
            String clientSecret = response.getClientSecret();
            TokenRequest tokenRequest = new TokenRequest(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
            tokenRequest.setUsername(userId);
            tokenRequest.setPassword(userSecret);
            tokenRequest.setScope("openid");
            tokenRequest.setAuthUsername(clientId);
            tokenRequest.setAuthPassword(clientSecret);
            TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
            tokenClient.setRequest((BaseRequest)tokenRequest);
            TokenResponse tokenResponse = tokenClient.exec();
            TokenEncryptionHttpTest.showClient((BaseClient)tokenClient);
            Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
            Assert.assertNotNull((Object)tokenResponse.getEntity(), (String)"The entity is null");
            Assert.assertNotNull((Object)tokenResponse.getAccessToken(), (String)"The access token is null");
            Assert.assertNotNull((Object)tokenResponse.getTokenType(), (String)"The token type is null");
            Assert.assertNotNull((Object)tokenResponse.getRefreshToken(), (String)"The refresh token is null");
            Assert.assertNotNull((Object)tokenResponse.getScope(), (String)"The scope is null");
            Assert.assertNotNull((Object)tokenResponse.getIdToken(), (String)"The id token is null");
            String idToken = tokenResponse.getIdToken();
            Jwe jwe = Jwe.parse((String)idToken, null, (byte[])clientSecret.getBytes("UTF-8"));
            Assert.assertNotNull((Object)jwe.getHeader().getClaimAsString("typ"));
            Assert.assertNotNull((Object)jwe.getHeader().getClaimAsString("alg"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("iss"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("aud"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("exp"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("iat"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("sub"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("oxOpenIDConnectVersion"));
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage(), (Throwable)ex);
        }
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "sectorIdentifierUri"})
    @Test
    public void requestIdTokenAlgA256KWEncA256GCM(String userId, String userSecret, String redirectUris, String sectorIdentifierUri) {
        try {
            this.showTitle("requestIdTokenAlgA256KWEncA256GCM");
            List<GrantType> grantTypes = Arrays.asList(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setIdTokenEncryptedResponseAlg(KeyEncryptionAlgorithm.A256KW);
            registerRequest.setIdTokenEncryptedResponseEnc(BlockEncryptionAlgorithm.A256GCM);
            registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
            registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
            registerRequest.setGrantTypes(grantTypes);
            RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
            registerClient.setRequest((BaseRequest)registerRequest);
            RegisterResponse response = registerClient.exec();
            TokenEncryptionHttpTest.showClient((BaseClient)registerClient);
            Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
            Assert.assertNotNull((Object)response.getClientId());
            Assert.assertNotNull((Object)response.getClientSecret());
            Assert.assertNotNull((Object)response.getRegistrationAccessToken());
            Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
            String clientId = response.getClientId();
            String clientSecret = response.getClientSecret();
            TokenRequest tokenRequest = new TokenRequest(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
            tokenRequest.setUsername(userId);
            tokenRequest.setPassword(userSecret);
            tokenRequest.setScope("openid");
            tokenRequest.setAuthUsername(clientId);
            tokenRequest.setAuthPassword(clientSecret);
            TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
            tokenClient.setRequest((BaseRequest)tokenRequest);
            TokenResponse tokenResponse = tokenClient.exec();
            TokenEncryptionHttpTest.showClient((BaseClient)tokenClient);
            Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
            Assert.assertNotNull((Object)tokenResponse.getEntity(), (String)"The entity is null");
            Assert.assertNotNull((Object)tokenResponse.getAccessToken(), (String)"The access token is null");
            Assert.assertNotNull((Object)tokenResponse.getTokenType(), (String)"The token type is null");
            Assert.assertNotNull((Object)tokenResponse.getRefreshToken(), (String)"The refresh token is null");
            Assert.assertNotNull((Object)tokenResponse.getScope(), (String)"The scope is null");
            Assert.assertNotNull((Object)tokenResponse.getIdToken(), (String)"The id token is null");
            String idToken = tokenResponse.getIdToken();
            Jwe jwe = Jwe.parse((String)idToken, null, (byte[])clientSecret.getBytes("UTF-8"));
            Assert.assertNotNull((Object)jwe.getHeader().getClaimAsString("typ"));
            Assert.assertNotNull((Object)jwe.getHeader().getClaimAsString("alg"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("iss"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("aud"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("exp"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("iat"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("sub"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("oxOpenIDConnectVersion"));
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage(), (Throwable)ex);
        }
    }
}

