/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.codehaus.jettison.json.JSONArray;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.BaseRequest;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.common.SubjectType;
import org.xdi.oxauth.model.crypto.encryption.BlockEncryptionAlgorithm;
import org.xdi.oxauth.model.crypto.encryption.KeyEncryptionAlgorithm;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.register.RegisterRequestParam;
import org.xdi.oxauth.model.util.StringUtils;

public class RegistrationRestWebServiceHttpTest
extends BaseTest {
    private String registrationAccessToken1;
    private String registrationClientUri1;
    private String registrationAccessToken2;
    private String registrationClientUri2;

    @Parameters(value={"redirectUris", "sectorIdentifierUri"})
    @Test
    public void requestClientAssociate1(String redirectUris, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestClientAssociate1");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse response = registerClient.exec();
        RegistrationRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getClientId());
        Assert.assertNotNull((Object)response.getClientSecret());
        Assert.assertNotNull((Object)response.getRegistrationAccessToken());
        Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
    }

    @Parameters(value={"redirectUris", "sectorIdentifierUri", "logoutUri"})
    @Test
    public void requestClientAssociate2(String redirectUris, String sectorIdentifierUri, String logoutUri) throws Exception {
        this.showTitle("requestClientAssociate2");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setContacts(Arrays.asList("javier@gluu.org", "javier.rojas.blum@gmail.com"));
        registerRequest.setScope(Arrays.asList("openid", "address", "profile", "email", "phone", "clientinfo", "invalid_scope"));
        registerRequest.setLogoUri("http://www.gluu.org/wp-content/themes/gluursn/images/logo.png");
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        registerRequest.setPolicyUri("http://www.gluu.org/policy");
        registerRequest.setJwksUri("http://www.gluu.org/jwks");
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        registerRequest.setSubjectType(SubjectType.PAIRWISE);
        registerRequest.setRequestUris(Arrays.asList("http://www.gluu.org/request"));
        registerRequest.setFrontChannelLogoutUris((List)Lists.newArrayList((Object[])new String[]{logoutUri}));
        registerRequest.setFrontChannelLogoutSessionRequired(Boolean.valueOf(true));
        registerRequest.setIdTokenSignedResponseAlg(SignatureAlgorithm.RS512);
        registerRequest.setIdTokenEncryptedResponseAlg(KeyEncryptionAlgorithm.RSA1_5);
        registerRequest.setIdTokenEncryptedResponseEnc(BlockEncryptionAlgorithm.A128CBC_PLUS_HS256);
        registerRequest.setUserInfoSignedResponseAlg(SignatureAlgorithm.RS384);
        registerRequest.setUserInfoEncryptedResponseAlg(KeyEncryptionAlgorithm.A128KW);
        registerRequest.setUserInfoEncryptedResponseEnc(BlockEncryptionAlgorithm.A128GCM);
        registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.RS256);
        registerRequest.setRequestObjectEncryptionAlg(KeyEncryptionAlgorithm.A256KW);
        registerRequest.setRequestObjectEncryptionEnc(BlockEncryptionAlgorithm.A256CBC_PLUS_HS512);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        registerRequest.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.ES256);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        registerClient.setExecutor(RegistrationRestWebServiceHttpTest.clientExecutor(true));
        RegisterResponse response = registerClient.exec();
        RegistrationRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getClientId());
        Assert.assertNotNull((Object)response.getClientSecret());
        Assert.assertNotNull((Object)response.getRegistrationAccessToken());
        Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
        Assert.assertNotNull(response.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        Assert.assertNotNull(response.getClaims().get(RegisterRequestParam.FRONT_CHANNEL_LOGOUT_SESSION_REQUIRED.toString()));
        Assert.assertTrue((boolean)Boolean.parseBoolean((String)response.getClaims().get(RegisterRequestParam.FRONT_CHANNEL_LOGOUT_SESSION_REQUIRED.toString())));
        Assert.assertNotNull(response.getClaims().get(RegisterRequestParam.FRONT_CHANNEL_LOGOUT_URI.toString()));
        Assert.assertTrue((boolean)new JSONArray((String)response.getClaims().get(RegisterRequestParam.FRONT_CHANNEL_LOGOUT_URI.toString())).getString(0).equals(logoutUri));
        Assert.assertNotNull(response.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertEquals((Object)SignatureAlgorithm.RS512, (Object)SignatureAlgorithm.fromString((String)((String)response.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()))));
        Assert.assertNotNull(response.getClaims().get(RegisterRequestParam.ID_TOKEN_ENCRYPTED_RESPONSE_ALG.toString()));
        Assert.assertEquals((Object)KeyEncryptionAlgorithm.RSA1_5, (Object)KeyEncryptionAlgorithm.fromName((String)((String)response.getClaims().get(RegisterRequestParam.ID_TOKEN_ENCRYPTED_RESPONSE_ALG.toString()))));
        Assert.assertNotNull(response.getClaims().get(RegisterRequestParam.ID_TOKEN_ENCRYPTED_RESPONSE_ENC.toString()));
        Assert.assertEquals((Object)BlockEncryptionAlgorithm.A128CBC_PLUS_HS256, (Object)BlockEncryptionAlgorithm.fromName((String)((String)response.getClaims().get(RegisterRequestParam.ID_TOKEN_ENCRYPTED_RESPONSE_ENC.toString()))));
        Assert.assertNotNull(response.getClaims().get(RegisterRequestParam.USERINFO_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertEquals((Object)SignatureAlgorithm.RS384, (Object)SignatureAlgorithm.fromString((String)((String)response.getClaims().get(RegisterRequestParam.USERINFO_SIGNED_RESPONSE_ALG.toString()))));
        Assert.assertNotNull(response.getClaims().get(RegisterRequestParam.USERINFO_ENCRYPTED_RESPONSE_ALG.toString()));
        Assert.assertEquals((Object)KeyEncryptionAlgorithm.A128KW, (Object)KeyEncryptionAlgorithm.fromName((String)((String)response.getClaims().get(RegisterRequestParam.USERINFO_ENCRYPTED_RESPONSE_ALG.toString()))));
        Assert.assertNotNull(response.getClaims().get(RegisterRequestParam.USERINFO_ENCRYPTED_RESPONSE_ENC.toString()));
        Assert.assertEquals((Object)BlockEncryptionAlgorithm.A128GCM, (Object)BlockEncryptionAlgorithm.fromName((String)((String)response.getClaims().get(RegisterRequestParam.USERINFO_ENCRYPTED_RESPONSE_ENC.toString()))));
        Assert.assertNotNull(response.getClaims().get(RegisterRequestParam.REQUEST_OBJECT_SIGNING_ALG.toString()));
        Assert.assertEquals((Object)SignatureAlgorithm.RS256, (Object)SignatureAlgorithm.fromString((String)((String)response.getClaims().get(RegisterRequestParam.REQUEST_OBJECT_SIGNING_ALG.toString()))));
        Assert.assertNotNull(response.getClaims().get(RegisterRequestParam.REQUEST_OBJECT_ENCRYPTION_ALG.toString()));
        Assert.assertEquals((Object)KeyEncryptionAlgorithm.A256KW, (Object)KeyEncryptionAlgorithm.fromName((String)((String)response.getClaims().get(RegisterRequestParam.REQUEST_OBJECT_ENCRYPTION_ALG.toString()))));
        Assert.assertNotNull(response.getClaims().get(RegisterRequestParam.REQUEST_OBJECT_ENCRYPTION_ENC.toString()));
        Assert.assertEquals((Object)BlockEncryptionAlgorithm.A256CBC_PLUS_HS512, (Object)BlockEncryptionAlgorithm.fromName((String)((String)response.getClaims().get(RegisterRequestParam.REQUEST_OBJECT_ENCRYPTION_ENC.toString()))));
        Assert.assertNotNull(response.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((Object)AuthenticationMethod.CLIENT_SECRET_JWT, (Object)AuthenticationMethod.fromString((String)((String)response.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()))));
        Assert.assertNotNull(response.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()));
        Assert.assertEquals((Object)SignatureAlgorithm.ES256, (Object)SignatureAlgorithm.fromString((String)((String)response.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()))));
        JSONArray scopesJsonArray = new JSONArray((Collection)StringUtils.spaceSeparatedToList((String)((String)response.getClaims().get(RegisterRequestParam.SCOPE.toString()))));
        ArrayList<String> scopes = new ArrayList<String>();
        for (int i = 0; i < scopesJsonArray.length(); ++i) {
            scopes.add(scopesJsonArray.get(i).toString());
        }
        Assert.assertTrue((boolean)scopes.contains("openid"));
        Assert.assertTrue((boolean)scopes.contains("address"));
        Assert.assertTrue((boolean)scopes.contains("email"));
        Assert.assertTrue((boolean)scopes.contains("profile"));
        Assert.assertTrue((boolean)scopes.contains("phone"));
        Assert.assertTrue((boolean)scopes.contains("clientinfo"));
        this.registrationAccessToken1 = response.getRegistrationAccessToken();
        this.registrationClientUri1 = response.getRegistrationClientUri();
    }

    @Test(dependsOnMethods={"requestClientAssociate2"})
    public void requestClientUpdate() throws Exception {
        this.showTitle("requestClientUpdate");
        String logoUriNewValue = "http://www.gluu.org/test/yuriy/logo.png";
        String contact1NewValue = "yuriy@gluu.org";
        String contact2NewValue = "yuriyz@gmail.com";
        Calendar clientSecretExpiresAtCalendar = Calendar.getInstance();
        clientSecretExpiresAtCalendar.add(6, 1);
        Date clientSecretExpiresAt = clientSecretExpiresAtCalendar.getTime();
        RegisterRequest registerRequest = new RegisterRequest(this.registrationAccessToken1);
        registerRequest.setHttpMethod("PUT");
        registerRequest.setContacts(Arrays.asList("yuriy@gluu.org", "yuriyz@gmail.com"));
        registerRequest.setLogoUri("http://www.gluu.org/test/yuriy/logo.png");
        registerRequest.setClientSecretExpiresAt(clientSecretExpiresAt);
        RegisterClient registerClient = new RegisterClient(this.registrationClientUri1);
        registerClient.setRequest((BaseRequest)registerRequest);
        registerClient.setExecutor(RegistrationRestWebServiceHttpTest.clientExecutor(true));
        RegisterResponse response = registerClient.exec();
        RegistrationRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getClientId());
        String responseContacts = (String)response.getClaims().get(RegisterRequestParam.CONTACTS.toString());
        String responseLogoUri = (String)response.getClaims().get(RegisterRequestParam.LOGO_URI.toString());
        Assert.assertTrue((responseContacts.contains("yuriy@gluu.org") && responseContacts.contains("yuriyz@gmail.com") ? 1 : 0) != 0);
        Assert.assertNotNull((Object)responseLogoUri.equals("http://www.gluu.org/test/yuriy/logo.png"));
        long diff = response.getClientSecretExpiresAt().getTime() / 10000L - clientSecretExpiresAt.getTime() / 10000L;
        System.out.println("Diff: " + diff + ", respTime: " + response.getClientSecretExpiresAt().getTime() + ", expAt: " + clientSecretExpiresAt.getTime());
        Assert.assertTrue((Math.abs(diff) == 0L ? 1 : 0) != 0);
    }

    @Test(dependsOnMethods={"requestClientAssociate2"})
    public void requestClientRead() throws Exception {
        this.showTitle("requestClientRead");
        RegisterRequest registerRequest = new RegisterRequest(this.registrationAccessToken1);
        RegisterClient registerClient = new RegisterClient(this.registrationClientUri1);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse response = registerClient.exec();
        RegistrationRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getClientId());
        Assert.assertNotNull((Object)response.getClientSecret());
        Assert.assertNotNull((Object)response.getRegistrationAccessToken());
        Assert.assertNotNull((Object)response.getRegistrationClientUri());
        Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
        Assert.assertNotNull(response.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(response.getClaims().get(RegisterRequestParam.POLICY_URI.toString()));
        Assert.assertNotNull(response.getClaims().get(RegisterRequestParam.REQUEST_OBJECT_SIGNING_ALG.toString()));
        Assert.assertNotNull(response.getClaims().get(RegisterRequestParam.CONTACTS.toString()));
        Assert.assertNotNull(response.getClaims().get(RegisterRequestParam.SECTOR_IDENTIFIER_URI.toString()));
        Assert.assertNotNull(response.getClaims().get(RegisterRequestParam.SUBJECT_TYPE.toString()));
        Assert.assertNotNull(response.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(response.getClaims().get(RegisterRequestParam.JWKS_URI.toString()));
        Assert.assertNotNull(response.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(response.getClaims().get(RegisterRequestParam.LOGO_URI.toString()));
        Assert.assertNotNull(response.getClaims().get(RegisterRequestParam.REQUEST_URIS.toString()));
        Assert.assertNotNull(response.getClaims().get(RegisterRequestParam.SCOPE.toString()));
    }

    @Parameters(value={"redirectUris", "sectorIdentifierUri", "logoutUri"})
    @Test
    public void requestClientAssociate3(String redirectUris, String sectorIdentifierUri, String logoutUri) throws Exception {
        this.showTitle("requestClientAssociate3");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setPostLogoutRedirectUris((List)Lists.newArrayList((Object[])new String[]{logoutUri}));
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        registerRequest.setSubjectType(SubjectType.PAIRWISE);
        registerRequest.setGrantTypes(Arrays.asList(GrantType.IMPLICIT));
        registerRequest.setResponseTypes(Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN));
        registerRequest.setScope(Arrays.asList("openid", "profile", "email"));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        registerRequest.setFrontChannelLogoutSessionRequired(Boolean.valueOf(true));
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        registerClient.setExecutor(RegistrationRestWebServiceHttpTest.clientExecutor(true));
        RegisterResponse response = registerClient.exec();
        RegistrationRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getClientId());
        Assert.assertNotNull((Object)response.getClientSecret());
        Assert.assertNotNull((Object)response.getRegistrationAccessToken());
        Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
        Assert.assertNotNull(response.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        Assert.assertNotNull(response.getClaims().get(RegisterRequestParam.FRONT_CHANNEL_LOGOUT_SESSION_REQUIRED.toString()));
        Assert.assertTrue((boolean)Boolean.parseBoolean((String)response.getClaims().get(RegisterRequestParam.FRONT_CHANNEL_LOGOUT_SESSION_REQUIRED.toString())));
        Assert.assertNotNull(response.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertEquals((Object)SignatureAlgorithm.RS256, (Object)SignatureAlgorithm.fromString((String)((String)response.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()))));
        Assert.assertEquals((Object)AuthenticationMethod.CLIENT_SECRET_POST, (Object)AuthenticationMethod.fromString((String)((String)response.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()))));
        JSONArray scopesJsonArray = new JSONArray((Collection)StringUtils.spaceSeparatedToList((String)((String)response.getClaims().get(RegisterRequestParam.SCOPE.toString()))));
        ArrayList<String> scopes = new ArrayList<String>();
        for (int i = 0; i < scopesJsonArray.length(); ++i) {
            scopes.add(scopesJsonArray.get(i).toString());
        }
        Assert.assertTrue((boolean)scopes.contains("openid"));
        Assert.assertTrue((boolean)scopes.contains("email"));
        Assert.assertTrue((boolean)scopes.contains("profile"));
        this.registrationAccessToken2 = response.getRegistrationAccessToken();
        this.registrationClientUri2 = response.getRegistrationClientUri();
    }

    @Test(dependsOnMethods={"requestClientAssociate3"})
    public void requestClientUpdate3() throws Exception {
        this.showTitle("requestClientUpdate3");
        String clientName = "Dynamically Registered Client #1 update_1";
        RegisterRequest registerRequest = new RegisterRequest(this.registrationAccessToken2);
        registerRequest.setHttpMethod("PUT");
        registerRequest.setRedirectUris(Arrays.asList("https://localhost:8443/auth"));
        registerRequest.setPostLogoutRedirectUris(Arrays.asList("https://localhost:8443/auth"));
        registerRequest.setApplicationType(ApplicationType.WEB);
        registerRequest.setClientName("Dynamically Registered Client #1 update_1");
        registerRequest.setSubjectType(SubjectType.PUBLIC);
        registerRequest.setGrantTypes(Arrays.asList(GrantType.IMPLICIT));
        registerRequest.setResponseTypes(Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN));
        registerRequest.setScope(Arrays.asList("openid", "address", "profile", "email", "phone", "clientinfo", "invalid_scope"));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        registerRequest.setFrontChannelLogoutSessionRequired(Boolean.valueOf(true));
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        RegisterClient registerClient = new RegisterClient(this.registrationClientUri2);
        registerClient.setRequest((BaseRequest)registerRequest);
        registerClient.setExecutor(RegistrationRestWebServiceHttpTest.clientExecutor(true));
        RegisterResponse response = registerClient.exec();
        RegistrationRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getClientId());
        Assert.assertTrue((boolean)response.getClaims().containsKey(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertEquals((String)"Dynamically Registered Client #1 update_1", (String)((String)response.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString())));
        JSONArray scopesJsonArray = new JSONArray((Collection)StringUtils.spaceSeparatedToList((String)((String)response.getClaims().get(RegisterRequestParam.SCOPE.toString()))));
        ArrayList<String> scopes = new ArrayList<String>();
        for (int i = 0; i < scopesJsonArray.length(); ++i) {
            scopes.add(scopesJsonArray.get(i).toString());
        }
        Assert.assertTrue((boolean)scopes.contains("openid"));
        Assert.assertTrue((boolean)scopes.contains("address"));
        Assert.assertTrue((boolean)scopes.contains("email"));
        Assert.assertTrue((boolean)scopes.contains("profile"));
        Assert.assertTrue((boolean)scopes.contains("phone"));
        Assert.assertTrue((boolean)scopes.contains("clientinfo"));
    }

    @Parameters(value={"redirectUris", "sectorIdentifierUri"})
    @Test
    public void requestClientRegistrationWithCustomAttributes(String redirectUris, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestClientRegistrationWithCustomAttributes");
        RegisterRequest request = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        request.addCustomAttribute("myCustomAttr1", "customAttrValue1");
        request.addCustomAttribute("myCustomAttr2", "customAttrValue2");
        request.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)request);
        RegisterResponse response = registerClient.exec();
        RegistrationRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getClientId());
        Assert.assertNotNull((Object)response.getClientSecret());
        Assert.assertNotNull((Object)response.getRegistrationAccessToken());
        Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
    }

    @Test
    public void requestClientRegistrationFail1() throws Exception {
        this.showTitle("requestClientRegistrationFail1");
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        RegisterResponse response = registerClient.execRegister(null, null, null);
        RegistrationRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)400, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)response.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)response.getErrorDescription(), (String)"The error description is null");
    }

    @Test
    public void requestClientRegistrationFail2() throws Exception {
        this.showTitle("requestClientRegistrationFail2");
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        RegisterResponse response = registerClient.execRegister(ApplicationType.WEB, "oxAuth test app", null);
        RegistrationRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)400, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)response.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)response.getErrorDescription(), (String)"The error description is null");
    }

    @Test
    public void requestClientRegistrationFail3() throws Exception {
        this.showTitle("requestClientRegistrationFail3");
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        RegisterResponse response = registerClient.execRegister(ApplicationType.WEB, "oxAuth test app", Arrays.asList("https://client.example.com/cb#fail_fragment"));
        RegistrationRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)400, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)response.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)response.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris"})
    @Test
    public void requestClientRegistrationFail4(String redirectUris) throws Exception {
        this.showTitle("requestClientRegistrationFail4");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setIdTokenSignedResponseAlg(SignatureAlgorithm.NONE);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        registerClient.setExecutor(RegistrationRestWebServiceHttpTest.clientExecutor(true));
        RegisterResponse response = registerClient.exec();
        RegistrationRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)400);
        Assert.assertNotNull((Object)response.getEntity());
        Assert.assertNotNull((Object)response.getErrorType());
        Assert.assertNotNull((Object)response.getErrorDescription());
    }

    @Parameters(value={"redirectUris"})
    @Test
    public void registerWithCustomURI(String redirectUris) throws Exception {
        this.showTitle("requestClientAssociate1");
        ArrayList redirectUriList = Lists.newArrayList((Iterable)StringUtils.spaceSeparatedToList((String)redirectUris));
        redirectUriList.add("myschema://client.example.com/cb");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.NATIVE, "oxAuth native test app with custom schema in URI", (List)redirectUriList);
        registerRequest.setSubjectType(SubjectType.PUBLIC);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setExecutor(RegistrationRestWebServiceHttpTest.clientExecutor(true));
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse response = registerClient.exec();
        RegistrationRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getClientId());
        Assert.assertNotNull((Object)response.getClientSecret());
        Assert.assertNotNull((Object)response.getRegistrationAccessToken());
        Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
    }

    @Parameters(value={"redirectUris", "sectorIdentifierUri"})
    @Test
    public void registerWithApplicationTypeNativeAndSubjectTypePairwise(String redirectUris, String sectorIdentifierUri) throws Exception {
        this.showTitle("registerWithApplicationTypeNativeAndSubjectTypePairwise");
        ArrayList redirectUriList = Lists.newArrayList((Iterable)StringUtils.spaceSeparatedToList((String)redirectUris));
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.NATIVE, "oxAuth native test app", (List)redirectUriList);
        registerRequest.setSubjectType(SubjectType.PAIRWISE);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setExecutor(RegistrationRestWebServiceHttpTest.clientExecutor(true));
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse response = registerClient.exec();
        RegistrationRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getClientId());
        Assert.assertNotNull((Object)response.getClientSecret());
        Assert.assertNotNull((Object)response.getRegistrationAccessToken());
        Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
    }

    @Parameters(value={"redirectUris"})
    @Test
    public void registerWithHttp1(String redirectUris) throws Exception {
        this.showTitle("registerWithHttp1");
        ArrayList redirectUriList = Lists.newArrayList((Iterable)StringUtils.spaceSeparatedToList((String)redirectUris));
        redirectUriList.add("http://localhost/cb");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth web test app with HTTP schema in URI", (List)redirectUriList);
        registerRequest.setSubjectType(SubjectType.PUBLIC);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setExecutor(RegistrationRestWebServiceHttpTest.clientExecutor(true));
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse response = registerClient.exec();
        RegistrationRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getClientId());
        Assert.assertNotNull((Object)response.getClientSecret());
        Assert.assertNotNull((Object)response.getRegistrationAccessToken());
        Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
    }

    @Parameters(value={"redirectUris"})
    @Test
    public void registerWithHttp2(String redirectUris) throws Exception {
        this.showTitle("registerWithHttp2");
        ArrayList redirectUriList = Lists.newArrayList((Iterable)StringUtils.spaceSeparatedToList((String)redirectUris));
        redirectUriList.add("http://127.0.0.1/cb");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth web test app with HTTP schema in URI", (List)redirectUriList);
        registerRequest.setSubjectType(SubjectType.PUBLIC);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setExecutor(RegistrationRestWebServiceHttpTest.clientExecutor(true));
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse response = registerClient.exec();
        RegistrationRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getClientId());
        Assert.assertNotNull((Object)response.getClientSecret());
        Assert.assertNotNull((Object)response.getRegistrationAccessToken());
        Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
    }

    @Parameters(value={"redirectUris"})
    @Test
    public void registerWithHttpFail(String redirectUris) throws Exception {
        this.showTitle("registerWithHttpFail");
        ArrayList redirectUriList = Lists.newArrayList((Iterable)StringUtils.spaceSeparatedToList((String)redirectUris));
        redirectUriList.add("http://www.example.com/cb");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth web test app with HTTP schema in URI", (List)redirectUriList);
        registerRequest.setSubjectType(SubjectType.PUBLIC);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setExecutor(RegistrationRestWebServiceHttpTest.clientExecutor(true));
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse response = registerClient.exec();
        RegistrationRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)400);
        Assert.assertNotNull((Object)response.getEntity());
        Assert.assertNotNull((Object)response.getErrorType());
        Assert.assertNotNull((Object)response.getErrorDescription());
    }
}

