/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.Asserter;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.BaseRequest;
import org.xdi.oxauth.client.JwkClient;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.client.TokenClient;
import org.xdi.oxauth.client.TokenRequest;
import org.xdi.oxauth.client.TokenResponse;
import org.xdi.oxauth.model.authorize.CodeVerifier;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.crypto.signature.RSAPublicKey;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.jws.RSASigner;
import org.xdi.oxauth.model.jwt.Jwt;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.util.StringUtils;

public class PkceHttpTest
extends BaseTest {
    @Parameters(value={"redirectUris", "userId", "userSecret", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void tokenWithPkceCheck(String redirectUris, String userId, String userSecret, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("tokenWithPkceCheck");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        registerRequest.setResponseTypes(responseTypes);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        PkceHttpTest.showClient((BaseClient)registerClient);
        Asserter.assertOk(registerResponse);
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        String nonce = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, registerResponse.getClientId(), scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        CodeVerifier verifier = authorizationRequest.generateAndSetCodeChallengeWithMethod();
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The ID Token is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        String authorizationCode = authorizationResponse.getCode();
        String idToken = authorizationResponse.getIdToken();
        Jwt jwt = Jwt.parse((String)idToken);
        Assert.assertNotNull((Object)jwt.getHeader().getClaimAsString("typ"));
        Assert.assertNotNull((Object)jwt.getHeader().getClaimAsString("alg"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("iss"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("aud"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("exp"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("iat"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("sub"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("c_hash"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("auth_time"));
        RSAPublicKey publicKey = JwkClient.getRSAPublicKey((String)this.jwksUri, (String)jwt.getHeader().getClaimAsString("kid"));
        RSASigner rsaSigner = new RSASigner(SignatureAlgorithm.RS256, publicKey);
        Assert.assertTrue((boolean)rsaSigner.validate(jwt));
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(registerResponse.getClientId());
        tokenRequest.setAuthPassword(registerResponse.getClientSecret());
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        tokenRequest.setCodeVerifier(verifier.getCodeVerifier());
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        PkceHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)tokenResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken(), (String)"The refresh token is null");
    }

    @Parameters(value={"redirectUris", "userId", "userSecret", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void invalidCodeVerifier(String redirectUris, String userId, String userSecret, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("invalidCodeVerifier");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        PkceHttpTest.showClient((BaseClient)registerClient);
        Asserter.assertOk(registerResponse);
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, registerResponse.getClientId(), scopes, redirectUri, null);
        authorizationRequest.setState(state);
        authorizationRequest.generateAndSetCodeChallengeWithMethod();
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(registerResponse.getClientId());
        tokenRequest.setAuthPassword(registerResponse.getClientSecret());
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        tokenRequest.setCodeVerifier("invalid_code_verifier");
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        PkceHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNull((Object)tokenResponse.getAccessToken(), (String)"The access token is null");
        tokenRequest.setCodeVerifier(null);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        tokenResponse = tokenClient.exec();
        PkceHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNull((Object)tokenResponse.getAccessToken(), (String)"The access token is null");
    }
}

