/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.AuthorizeClient;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.BaseRequest;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.client.TokenClient;
import org.xdi.oxauth.client.TokenRequest;
import org.xdi.oxauth.client.TokenResponse;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.util.StringUtils;

public class PersistClientAuthorizationsHttpTest
extends BaseTest {
    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void persistentClientAuthorizations(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("persistentClientAuthorizations");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        PersistClientAuthorizationsHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String sessionId = null;
        List<String> scopes = Arrays.asList("openid", "profile");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation());
        Assert.assertNotNull((Object)authorizationResponse.getCode());
        Assert.assertNotNull((Object)authorizationResponse.getIdToken());
        Assert.assertNotNull((Object)authorizationResponse.getState());
        String authorizationCode = authorizationResponse.getCode();
        sessionId = authorizationResponse.getSessionId();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        PersistClientAuthorizationsHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity());
        Assert.assertNotNull((Object)tokenResponse.getAccessToken());
        Assert.assertNotNull((Object)tokenResponse.getExpiresIn());
        Assert.assertNotNull((Object)tokenResponse.getTokenType());
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken());
        scopes = Arrays.asList("openid", "profile");
        nonce = UUID.randomUUID().toString();
        state = UUID.randomUUID().toString();
        authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationResponse = this.authenticateResourceOwner(this.authorizationEndpoint, authorizationRequest, userId, userSecret, false);
        Assert.assertNotNull((Object)authorizationResponse.getLocation());
        Assert.assertNotNull((Object)authorizationResponse.getCode());
        Assert.assertNotNull((Object)authorizationResponse.getIdToken());
        Assert.assertNotNull((Object)authorizationResponse.getState());
        authorizationCode = authorizationResponse.getCode();
        tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        tokenResponse = tokenClient.exec();
        PersistClientAuthorizationsHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity());
        Assert.assertNotNull((Object)tokenResponse.getAccessToken());
        Assert.assertNotNull((Object)tokenResponse.getExpiresIn());
        Assert.assertNotNull((Object)tokenResponse.getTokenType());
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken());
        scopes = Arrays.asList("openid", "address", "email");
        nonce = UUID.randomUUID().toString();
        state = UUID.randomUUID().toString();
        authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret, false);
        Assert.assertNotNull((Object)authorizationResponse.getLocation());
        Assert.assertNotNull((Object)authorizationResponse.getCode());
        Assert.assertNotNull((Object)authorizationResponse.getIdToken());
        Assert.assertNotNull((Object)authorizationResponse.getState());
        authorizationCode = authorizationResponse.getCode();
        tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        tokenResponse = tokenClient.exec();
        PersistClientAuthorizationsHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity());
        Assert.assertNotNull((Object)tokenResponse.getAccessToken());
        Assert.assertNotNull((Object)tokenResponse.getExpiresIn());
        Assert.assertNotNull((Object)tokenResponse.getTokenType());
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken());
        scopes = Arrays.asList("openid", "profile", "address", "email");
        nonce = UUID.randomUUID().toString();
        state = UUID.randomUUID().toString();
        authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationResponse = this.authenticateResourceOwner(this.authorizationEndpoint, authorizationRequest, userId, userSecret, false);
        Assert.assertNotNull((Object)authorizationResponse.getLocation());
        Assert.assertNotNull((Object)authorizationResponse.getCode());
        Assert.assertNotNull((Object)authorizationResponse.getIdToken());
        Assert.assertNotNull((Object)authorizationResponse.getState());
        authorizationCode = authorizationResponse.getCode();
        tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        tokenResponse = tokenClient.exec();
        PersistClientAuthorizationsHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity());
        Assert.assertNotNull((Object)tokenResponse.getAccessToken());
        Assert.assertNotNull((Object)tokenResponse.getExpiresIn());
        Assert.assertNotNull((Object)tokenResponse.getTokenType());
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken());
        scopes = Arrays.asList("openid", "profile", "address", "email");
        nonce = UUID.randomUUID().toString();
        state = UUID.randomUUID().toString();
        authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        authorizationRequest.setSessionId(sessionId);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest((BaseRequest)authorizationRequest);
        AuthorizationResponse authorizationResponse2 = authorizeClient.exec();
        Assert.assertNotNull((Object)authorizationResponse2.getLocation());
        Assert.assertNotNull((Object)authorizationResponse2.getCode());
        Assert.assertNotNull((Object)authorizationResponse2.getState());
        Assert.assertNotNull((Object)authorizationResponse2.getScope());
        String authorizationCode2 = authorizationResponse2.getCode();
        TokenRequest tokenRequest2 = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest2.setCode(authorizationCode2);
        tokenRequest2.setRedirectUri(redirectUri);
        tokenRequest2.setAuthUsername(clientId);
        tokenRequest2.setAuthPassword(clientSecret);
        tokenRequest2.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        TokenClient tokenClient2 = new TokenClient(this.tokenEndpoint);
        tokenClient2.setRequest((BaseRequest)tokenRequest2);
        TokenResponse tokenResponse2 = tokenClient2.exec();
        PersistClientAuthorizationsHttpTest.showClient((BaseClient)tokenClient2);
        Assert.assertEquals((int)tokenResponse2.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse2.getStatus()));
        Assert.assertNotNull((Object)tokenResponse2.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse2.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse2.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)tokenResponse2.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse2.getRefreshToken(), (String)"The refresh token is null");
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void persistentClientAuthorizationsSameSession(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("persistentClientAuthorizationsSameSession");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        PersistClientAuthorizationsHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String sessionId = null;
        List<String> scopes = Arrays.asList("openid", "profile");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation());
        Assert.assertNotNull((Object)authorizationResponse.getCode());
        Assert.assertNotNull((Object)authorizationResponse.getIdToken());
        Assert.assertNotNull((Object)authorizationResponse.getState());
        String authorizationCode = authorizationResponse.getCode();
        sessionId = authorizationResponse.getSessionId();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        PersistClientAuthorizationsHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity());
        Assert.assertNotNull((Object)tokenResponse.getAccessToken());
        Assert.assertNotNull((Object)tokenResponse.getExpiresIn());
        Assert.assertNotNull((Object)tokenResponse.getTokenType());
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken());
        scopes = Arrays.asList("openid", "profile");
        nonce = UUID.randomUUID().toString();
        state = UUID.randomUUID().toString();
        authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.setSessionId(sessionId);
        authorizationResponse = this.authenticateResourceOwner(this.authorizationEndpoint, authorizationRequest, null, null, false);
        Assert.assertNotNull((Object)authorizationResponse.getLocation());
        Assert.assertNotNull((Object)authorizationResponse.getCode());
        Assert.assertNotNull((Object)authorizationResponse.getIdToken());
        Assert.assertNotNull((Object)authorizationResponse.getState());
        authorizationCode = authorizationResponse.getCode();
        tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        tokenResponse = tokenClient.exec();
        PersistClientAuthorizationsHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity());
        Assert.assertNotNull((Object)tokenResponse.getAccessToken());
        Assert.assertNotNull((Object)tokenResponse.getExpiresIn());
        Assert.assertNotNull((Object)tokenResponse.getTokenType());
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken());
        scopes = Arrays.asList("openid", "address", "email");
        nonce = UUID.randomUUID().toString();
        state = UUID.randomUUID().toString();
        authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.setSessionId(sessionId);
        authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, null, null, false);
        Assert.assertNotNull((Object)authorizationResponse.getLocation());
        Assert.assertNotNull((Object)authorizationResponse.getCode());
        Assert.assertNotNull((Object)authorizationResponse.getIdToken());
        Assert.assertNotNull((Object)authorizationResponse.getState());
        authorizationCode = authorizationResponse.getCode();
        tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        tokenResponse = tokenClient.exec();
        PersistClientAuthorizationsHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity());
        Assert.assertNotNull((Object)tokenResponse.getAccessToken());
        Assert.assertNotNull((Object)tokenResponse.getExpiresIn());
        Assert.assertNotNull((Object)tokenResponse.getTokenType());
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken());
        scopes = Arrays.asList("openid", "profile", "address", "email");
        nonce = UUID.randomUUID().toString();
        state = UUID.randomUUID().toString();
        authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.setSessionId(sessionId);
        authorizationResponse = this.authenticateResourceOwner(this.authorizationEndpoint, authorizationRequest, null, null, false);
        Assert.assertNotNull((Object)authorizationResponse.getLocation());
        Assert.assertNotNull((Object)authorizationResponse.getCode());
        Assert.assertNotNull((Object)authorizationResponse.getIdToken());
        Assert.assertNotNull((Object)authorizationResponse.getState());
        authorizationCode = authorizationResponse.getCode();
        tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        tokenResponse = tokenClient.exec();
        PersistClientAuthorizationsHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity());
        Assert.assertNotNull((Object)tokenResponse.getAccessToken());
        Assert.assertNotNull((Object)tokenResponse.getExpiresIn());
        Assert.assertNotNull((Object)tokenResponse.getTokenType());
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken());
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void doNotPersistAuthorizationWhenPreAuthorized(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("doNotPersistAuthorizationWhenPreAuthorized");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        PersistClientAuthorizationsHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        List<String> scopes = Arrays.asList("openid", "profile");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwner(this.authorizationEndpoint, authorizationRequest, userId, userSecret, false);
        Assert.assertNotNull((Object)authorizationResponse.getLocation());
        Assert.assertNotNull((Object)authorizationResponse.getCode());
        Assert.assertNotNull((Object)authorizationResponse.getIdToken());
        Assert.assertNotNull((Object)authorizationResponse.getState());
        String authorizationCode = authorizationResponse.getCode();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        PersistClientAuthorizationsHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity());
        Assert.assertNotNull((Object)tokenResponse.getAccessToken());
        Assert.assertNotNull((Object)tokenResponse.getExpiresIn());
        Assert.assertNotNull((Object)tokenResponse.getTokenType());
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken());
    }
}

